/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.file;

import com.intellij.ideolog.file.LogFileFormatNotificationProviderKt;
import com.intellij.ideolog.highlighting.LogFileMapRenderer;
import com.intellij.ideolog.highlighting.LogHeavyFilterService;
import com.intellij.ideolog.highlighting.settings.LogHighlightingSettingsStore;
import com.intellij.ideolog.util.IdeologDocumentContextKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ideolog/file/LogFileEditor;", "Lcom/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorProvider;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/fileEditor/impl/text/TextEditorProvider;)V", "isReadOnly", "", "dispose", "", "resetIdeologStoredData", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "intellij.ideolog"})
public final class LogFileEditor
extends PsiAwareTextEditorImpl {
    private final boolean isReadOnly;

    public LogFileEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull TextEditorProvider provider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super(project, file, provider);
        LogFileMapRenderer.Companion.getOrCreateLogFileMapRenderer(this);
        int sizeThreshold = Integer.parseInt(LogHighlightingSettingsStore.Companion.getInstance().getMyState().getReadonlySizeThreshold());
        this.isReadOnly = file.getLength() > (long)(sizeThreshold * 1024);
        LogHighlightingSettingsStore.Companion.getInstance().addSettingsListener((Disposable)this, (Function0<Unit>)((Function0)() -> LogFileEditor._init_$lambda$0(this)));
        MarkupModelEx markupModelEx = this.getEditor().getMarkupModel();
        EditorMarkupModel editorMarkupModel = markupModelEx instanceof EditorMarkupModel ? (EditorMarkupModel)markupModelEx : null;
        if (editorMarkupModel != null) {
            editorMarkupModel.setTrafficLightIconVisible(false);
        }
        if (this.isReadOnly) {
            this.getEditor().getSettings().setUseSoftWraps(false);
            this.getEditor().putUserData(Key.create((String)"forced.soft.wraps"), (Object)false);
        } else {
            this.getEditor().getDocument().addDocumentListener(new DocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (event.getOldLength() != 0 || event.getNewLength() - event.getOldLength() > 1 || event.getOffset() != event.getDocument().getTextLength() - event.getNewLength()) {
                        this.resetIdeologStoredData();
                    }
                }
            });
        }
        this.getEditor().getSettings().setAdditionalColumnsCount(0);
        this.getEditor().setViewer(this.isReadOnly);
    }

    public void dispose() {
        DocumentEx documentEx = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        IdeologDocumentContextKt.getIdeologContext((Document)documentEx).clear();
        super.dispose();
    }

    private final void resetIdeologStoredData() {
        this.getEditor().putUserData(LogHeavyFilterService.Companion.getMarkupHighlightedExceptionsKey(), null);
        DocumentEx documentEx = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        IdeologDocumentContextKt.getIdeologContext((Document)documentEx).clear();
        LogFileMapRenderer logFileMapRenderer = (LogFileMapRenderer)LogFileMapRenderer.Companion.getLogFileMapRendererKey().get((UserDataHolder)this.getEditor());
        if (logFileMapRenderer != null) {
            logFileMapRenderer.detachFromEditor();
        }
        LogFileMapRenderer.Companion.getOrCreateLogFileMapRenderer(this);
        LogFileFormatNotificationProviderKt.update(this.file, this.project);
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(state instanceof TextEditorState)) {
            return;
        }
        super.setState(state);
        if (this.isReadOnly) {
            this.getEditor().getSettings().setUseSoftWraps(false);
        }
    }

    private static final Unit _init_$lambda$0(LogFileEditor this$0) {
        this$0.resetIdeologStoredData();
        return Unit.INSTANCE;
    }
}

