/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.foldings;

import com.intellij.ideolog.IdeologBundle;
import com.intellij.ideolog.highlighting.settings.LogHighlightingSettingsStore;
import com.intellij.ideolog.lex.LogFileFormat;
import com.intellij.ideolog.lex.LogFileFormatsKt;
import com.intellij.ideolog.lex.LogToken;
import com.intellij.ideolog.util.IdeologDocumentContext;
import com.intellij.ideolog.util.IdeologDocumentContextKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0003\u0018\u0000 72\u00020\u0001:\u00017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020-H\u0016J\b\u00101\u001a\u00020-H\u0002J\b\u00102\u001a\u00020'H\u0016J\u0018\u00103\u001a\u00020'2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u000fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR6\u0010\f\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e0\rj\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0017\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u000e0\u0018j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u000e`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0018j\b\u0012\u0004\u0012\u00020\u0007`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0018j\b\u0012\u0004\u0012\u00020\u0007`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u001c\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u000e0\u0018j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u000e`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001e\u0010#\u001a\u0012\u0012\u0004\u0012\u00020$0\rj\b\u0012\u0004\u0012\u00020$`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u00068"}, d2={"Lcom/intellij/ideolog/foldings/FoldingCalculatorTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fileName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "foldings", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "", "Lkotlin/collections/ArrayList;", "settings", "Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore;", "getSettings", "()Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore;", "context", "Lcom/intellij/ideolog/util/IdeologDocumentContext;", "hiddenItems", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "hiddenSubstrings", "whitelistedSubstrings", "whitelistedItems", "hideLinesAbove", "hideLinesBelow", "fileType", "Lcom/intellij/ideolog/lex/LogFileFormat;", "getFileType", "()Lcom/intellij/ideolog/lex/LogFileFormat;", "tokens", "Lcom/intellij/ideolog/lex/LogToken;", "lastAddedFoldingEndOffset", "myCancel", "", "getMyCancel", "()Z", "setMyCancel", "(Z)V", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onSuccess", "collapseFoldings", "shouldStartInBackground", "isLineVisible", "line", "", "lineNumber", "Companion", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nFoldingCalculatorTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FoldingCalculatorTask.kt\ncom/intellij/ideolog/foldings/FoldingCalculatorTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,173:1\n1863#2,2:174\n1863#2,2:176\n1863#2,2:178\n1755#2,3:180\n1734#2,3:183\n1863#2,2:186\n13409#3,2:188\n13409#3,2:190\n*S KotlinDebug\n*F\n+ 1 FoldingCalculatorTask.kt\ncom/intellij/ideolog/foldings/FoldingCalculatorTask\n*L\n115#1:174,2\n119#1:176,2\n139#1:178,2\n147#1:180,3\n152#1:183,3\n162#1:186,2\n72#1:188,2\n100#1:190,2\n*E\n"})
public final class FoldingCalculatorTask
extends Task.Backgroundable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final ArrayList<Pair<Integer, Integer>> foldings;
    @NotNull
    private final LogHighlightingSettingsStore settings;
    @NotNull
    private final IdeologDocumentContext context;
    @NotNull
    private final HashSet<Pair<Integer, String>> hiddenItems;
    @NotNull
    private final HashSet<String> hiddenSubstrings;
    @NotNull
    private final HashSet<String> whitelistedSubstrings;
    @NotNull
    private final HashSet<Pair<Integer, String>> whitelistedItems;
    private final int hideLinesAbove;
    private final int hideLinesBelow;
    @NotNull
    private final LogFileFormat fileType;
    @NotNull
    private final ArrayList<LogToken> tokens;
    private int lastAddedFoldingEndOffset;
    private boolean myCancel;
    @Nullable
    private static FoldingCalculatorTask lastLaunchedTask;

    public FoldingCalculatorTask(@NotNull Project project, @NotNull Editor editor, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Object[] objectArray = new Object[]{fileName};
        super(project, IdeologBundle.message("progress.title.calculating.foldings.for", objectArray), true);
        this.editor = editor;
        this.foldings = new ArrayList();
        this.settings = LogHighlightingSettingsStore.Companion.getInstance();
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.context = IdeologDocumentContextKt.getIdeologContext(document);
        this.hiddenItems = this.context.getHiddenItems();
        this.hiddenSubstrings = this.context.getHiddenSubstrings();
        this.whitelistedSubstrings = this.context.getWhitelistedSubstrings();
        this.whitelistedItems = this.context.getWhitelistedItems();
        this.hideLinesAbove = this.context.getHideLinesAbove();
        this.hideLinesBelow = this.context.getHideLinesBelow();
        this.fileType = LogFileFormatsKt.detectLogFileFormat(this.editor);
        this.tokens = new ArrayList();
        this.lastAddedFoldingEndOffset = -1;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final LogHighlightingSettingsStore getSettings() {
        return this.settings;
    }

    @NotNull
    public final LogFileFormat getFileType() {
        return this.fileType;
    }

    public final boolean getMyCancel() {
        return this.myCancel;
    }

    public final void setMyCancel(boolean bl) {
        this.myCancel = bl;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        ApplicationManager.getApplication().invokeAndWait(() -> FoldingCalculatorTask.run$lambda$1(this));
        int lastVisibleLine = -1;
        boolean lastLineWasVisible = false;
        for (int i = 0; i < document2.getLineCount(); ++i) {
            if (indicator.isCanceled() || this.myCancel) {
                return;
            }
            indicator.setFraction((double)i / (double)document2.getLineCount());
            int start = document2.getLineStartOffset(i);
            int end = document2.getLineEndOffset(i);
            CharSequence line = document2.getCharsSequence().subSequence(start, end);
            if (this.fileType.isLineEventStart(line) ? this.isLineVisible(line, i) : lastLineWasVisible) {
                lastLineWasVisible = true;
                if (i - lastVisibleLine > 1) {
                    this.foldings.add((Pair<Integer, Integer>)TuplesKt.to((Object)(lastVisibleLine + 1), (Object)(i - 1)));
                    if (this.foldings.size() >= 100) {
                        ApplicationManager.getApplication().invokeAndWait(() -> FoldingCalculatorTask.run$lambda$4(this));
                    }
                }
                lastVisibleLine = i;
                continue;
            }
            lastLineWasVisible = false;
        }
        if (document2.getLineCount() - lastVisibleLine > 1) {
            this.foldings.add((Pair<Integer, Integer>)TuplesKt.to((Object)(lastVisibleLine + 1), (Object)(document2.getLineCount() - 1)));
        }
    }

    public void onSuccess() {
        this.editor.getFoldingModel().runBatchFoldingOperation(() -> FoldingCalculatorTask.onSuccess$lambda$6(this));
    }

    private final void collapseFoldings() {
        Pair it;
        ArrayList<FoldRegion> addedFoldings = new ArrayList<FoldRegion>();
        Iterable $this$forEach$iv = this.foldings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            addedFoldings.add(this.editor.getFoldingModel().addFoldRegion(this.editor.getDocument().getLineStartOffset(((Number)it.getFirst()).intValue()), this.editor.getDocument().getLineEndOffset(((Number)it.getSecond()).intValue()), " ... " + (((Number)it.getSecond()).intValue() - ((Number)it.getFirst()).intValue() + 1) + " lines hidden ... "));
        }
        $this$forEach$iv = addedFoldings;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FoldRegion)element$iv;
            boolean bl = false;
            Pair pair = it;
            if (pair == null) continue;
            pair.setExpanded(false);
        }
    }

    public boolean shouldStartInBackground() {
        return true;
    }

    private final boolean isLineVisible(CharSequence line, int lineNumber) {
        String it;
        String second;
        int first;
        Pair pair;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        if (lineNumber < this.hideLinesAbove || lineNumber > this.hideLinesBelow) {
            return false;
        }
        Iterator<String> iterator = this.settings.getMyState().getHidden().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<String> iterator2 = iterator;
        while (iterator2.hasNext()) {
            String pattern;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (!StringsKt.contains((CharSequence)line, (CharSequence)pattern, (boolean)true)) continue;
            return false;
        }
        boolean hasParsedTokens = false;
        if (!((Collection)this.hiddenItems).isEmpty()) {
            this.tokens.clear();
            this.fileType.tokenize(line, (List<LogToken>)this.tokens, true);
            $this$forEach$iv = this.hiddenItems;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                pair = (Pair)element$iv;
                boolean bl = false;
                first = ((Number)pair.component1()).intValue();
                second = (String)pair.component2();
                if (first >= this.tokens.size() || !Intrinsics.areEqual((Object)second, (Object)((Object)this.tokens.get(first).takeFrom(line)).toString())) continue;
                return false;
            }
            hasParsedTokens = true;
        }
        if (!((Collection)this.hiddenSubstrings).isEmpty()) {
            boolean bl;
            block17: {
                Iterable $this$any$iv = this.hiddenSubstrings;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains$default((CharSequence)line, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
        }
        if (!((Collection)this.whitelistedSubstrings).isEmpty()) {
            boolean bl;
            block18: {
                Iterable $this$all$iv = this.whitelistedSubstrings;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (String)element$iv;
                        boolean bl3 = false;
                        if (StringsKt.contains$default((CharSequence)line, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block18;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                return false;
            }
        }
        if (!((Collection)this.whitelistedItems).isEmpty()) {
            if (!hasParsedTokens) {
                this.tokens.clear();
                this.fileType.tokenize(line, (List<LogToken>)this.tokens, true);
            }
            $this$forEach$iv = this.whitelistedItems;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                pair = (Pair)element$iv;
                boolean bl = false;
                first = ((Number)pair.component1()).intValue();
                second = (String)pair.component2();
                if (first < this.tokens.size() && Intrinsics.areEqual((Object)second, (Object)((Object)this.tokens.get(first).takeFrom(line)).toString())) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private static final void run$lambda$1$lambda$0() {
    }

    private static final void run$lambda$1(FoldingCalculatorTask this$0) {
        this$0.editor.getFoldingModel().runBatchFoldingOperation(FoldingCalculatorTask::run$lambda$1$lambda$0);
    }

    private static final void run$lambda$4$lambda$3(FoldingCalculatorTask this$0) {
        FoldRegion[] allFoldings;
        int lastNewFoldingOffset = this$0.editor.getDocument().getLineEndOffset(((Number)((Pair)CollectionsKt.last((List)this$0.foldings)).getSecond()).intValue());
        FoldRegion[] foldRegionArray = this$0.editor.getFoldingModel().getAllFoldRegions();
        Intrinsics.checkNotNullExpressionValue((Object)foldRegionArray, (String)"getAllFoldRegions(...)");
        FoldRegion[] $this$forEach$iv = allFoldings = foldRegionArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            FoldRegion element$iv;
            FoldRegion it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (it.getStartOffset() <= this$0.lastAddedFoldingEndOffset || it.getStartOffset() > lastNewFoldingOffset) continue;
            this$0.editor.getFoldingModel().removeFoldRegion(it);
        }
        this$0.collapseFoldings();
        this$0.lastAddedFoldingEndOffset = lastNewFoldingOffset;
    }

    private static final void run$lambda$4(FoldingCalculatorTask this$0) {
        this$0.editor.getFoldingModel().runBatchFoldingOperation(() -> FoldingCalculatorTask.run$lambda$4$lambda$3(this$0));
        this$0.foldings.clear();
    }

    private static final void onSuccess$lambda$6(FoldingCalculatorTask this$0) {
        int lastNewFoldingOffset = this$0.editor.getDocument().getCharsSequence().length();
        FoldRegion[] foldRegionArray = this$0.editor.getFoldingModel().getAllFoldRegions();
        Intrinsics.checkNotNullExpressionValue((Object)foldRegionArray, (String)"getAllFoldRegions(...)");
        Object[] $this$forEach$iv = foldRegionArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FoldRegion it = (FoldRegion)element$iv;
            boolean bl = false;
            if (it.getStartOffset() <= this$0.lastAddedFoldingEndOffset || it.getStartOffset() > lastNewFoldingOffset) continue;
            this$0.editor.getFoldingModel().removeFoldRegion(it);
        }
        this$0.collapseFoldings();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ideolog/foldings/FoldingCalculatorTask$Companion;", "", "<init>", "()V", "lastLaunchedTask", "Lcom/intellij/ideolog/foldings/FoldingCalculatorTask;", "restartFoldingCalculator", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.ideolog"})
    public static final class Companion {
        private Companion() {
        }

        public final void restartFoldingCalculator(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile file) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            FoldingCalculatorTask foldingCalculatorTask = lastLaunchedTask;
            if (foldingCalculatorTask != null) {
                foldingCalculatorTask.setMyCancel(true);
            }
            if ((object = file) == null || (object = object.getName()) == null) {
                object = "?";
            }
            FoldingCalculatorTask task = new FoldingCalculatorTask(project, editor, (String)object);
            lastLaunchedTask = task;
            ProgressManager.getInstance().run((Task)task);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

