/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.highlighting;

import com.intellij.ideolog.highlighting.DefaultLogEditorHighlighterProvider;
import com.intellij.ideolog.highlighting.LogHighlightingIterator;
import com.intellij.ideolog.lex.LogFileFormat;
import com.intellij.ideolog.lex.LogFileFormatsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0016J.\u0010!\u001a\u0004\u0018\u0001H\"\"\u0004\b\u0000\u0010\"2\u0017\u0010#\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H\"0$\u00a2\u0006\u0002\b%H\u0002\u00a2\u0006\u0002\u0010&R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/ideolog/highlighting/LogEditorHighlighter;", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "colors", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "myColors", "myText", "", "myEditor", "Lcom/intellij/openapi/editor/highlighter/HighlighterClient;", "getMyEditor", "()Lcom/intellij/openapi/editor/highlighter/HighlighterClient;", "setMyEditor", "(Lcom/intellij/openapi/editor/highlighter/HighlighterClient;)V", "defaultLogEditorHighlighter", "createIterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "startOffset", "", "setText", "", "text", "setEditor", "editor", "setColorScheme", "scheme", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "doDefaultHighlighterAction", "T", "action", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nLogFileHighlighterFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogFileHighlighterFactory.kt\ncom/intellij/ideolog/highlighting/LogEditorHighlighter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1557#2:100\n1628#2,3:101\n*S KotlinDebug\n*F\n+ 1 LogFileHighlighterFactory.kt\ncom/intellij/ideolog/highlighting/LogEditorHighlighter\n*L\n70#1:100\n70#1:101,3\n*E\n"})
public class LogEditorHighlighter
implements EditorHighlighter {
    @Nullable
    private final VirtualFile virtualFile;
    @NotNull
    private EditorColorsScheme myColors;
    @NotNull
    private CharSequence myText;
    @Nullable
    private HighlighterClient myEditor;
    @NotNull
    private EditorHighlighter defaultLogEditorHighlighter;

    public LogEditorHighlighter(@Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.virtualFile = virtualFile;
        this.myColors = colors;
        this.myText = "";
        this.defaultLogEditorHighlighter = (EditorHighlighter)new EmptyEditorHighlighter(new TextAttributes());
    }

    @Nullable
    protected final HighlighterClient getMyEditor() {
        return this.myEditor;
    }

    protected final void setMyEditor(@Nullable HighlighterClient highlighterClient) {
        this.myEditor = highlighterClient;
    }

    public LogEditorHighlighter(@NotNull EditorColorsScheme colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this(null, colors);
    }

    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        HighlighterIterator defaultHighlighterIterator = (HighlighterIterator)this.doDefaultHighlighterAction(arg_0 -> LogEditorHighlighter.createIterator$lambda$0(startOffset, arg_0));
        HighlighterIterator highlighterIterator = defaultHighlighterIterator;
        if (highlighterIterator == null) {
            HighlighterClient highlighterClient = this.myEditor;
            Intrinsics.checkNotNull((Object)highlighterClient, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.Editor");
            highlighterIterator = new LogHighlightingIterator(startOffset, (Editor)highlighterClient, (Function0<? extends CharSequence>)((Function0)() -> LogEditorHighlighter.createIterator$lambda$1(this)), (Function0<? extends EditorColorsScheme>)((Function0)() -> LogEditorHighlighter.createIterator$lambda$2(this)));
        }
        return highlighterIterator;
    }

    public void setText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.myText = text;
        this.doDefaultHighlighterAction(arg_0 -> LogEditorHighlighter.setText$lambda$3(text, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public void setEditor(@NotNull HighlighterClient editor) {
        block2: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.myEditor = editor;
            Iterable $this$map$iv = DefaultLogEditorHighlighterProvider.Companion.getDEFAULT_LOG_EDITOR_HIGHLIGHTER_PROVIDER_EP_NAME$intellij_ideolog().getExtensionList();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void provider;
                DefaultLogEditorHighlighterProvider defaultLogEditorHighlighterProvider = (DefaultLogEditorHighlighterProvider)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(provider.getEditorHighlighter(editor.getProject(), null, this.virtualFile, this.myColors));
            }
            EditorHighlighter editorHighlighter = (EditorHighlighter)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (editorHighlighter == null) break block2;
            EditorHighlighter highlighter = editorHighlighter;
            boolean bl = false;
            if (this.virtualFile != null && this.virtualFile.getLength() <= 524288L) {
                this.defaultLogEditorHighlighter = highlighter;
            }
        }
    }

    public void setColorScheme(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        this.myColors = scheme;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            CharSequence charSequence = event.getDocument().getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            this.setText(charSequence);
            HighlighterClient highlighterClient = this.myEditor;
            if (highlighterClient == null) break block0;
            highlighterClient.repaint(0, this.myText.length());
        }
    }

    private final <T> T doDefaultHighlighterAction(Function1<? super EditorHighlighter, ? extends T> action) {
        if (this.myEditor == null || !ApplicationManager.getApplication().isDispatchThread()) {
            return (T)action.invoke((Object)this.defaultLogEditorHighlighter);
        }
        HighlighterClient highlighterClient = this.myEditor;
        Intrinsics.checkNotNull((Object)highlighterClient, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.Editor");
        LogFileFormat logFileFormat = LogFileFormatsKt.detectLogFileFormat((Editor)highlighterClient);
        if (logFileFormat.getMyRegexLogParser() == null) {
            return (T)action.invoke((Object)this.defaultLogEditorHighlighter);
        }
        return null;
    }

    private static final HighlighterIterator createIterator$lambda$0(int $startOffset, EditorHighlighter $this$doDefaultHighlighterAction) {
        Intrinsics.checkNotNullParameter((Object)$this$doDefaultHighlighterAction, (String)"$this$doDefaultHighlighterAction");
        return $this$doDefaultHighlighterAction.createIterator($startOffset);
    }

    private static final CharSequence createIterator$lambda$1(LogEditorHighlighter this$0) {
        return this$0.myText;
    }

    private static final EditorColorsScheme createIterator$lambda$2(LogEditorHighlighter this$0) {
        return this$0.myColors;
    }

    private static final Unit setText$lambda$3(CharSequence $text, EditorHighlighter $this$doDefaultHighlighterAction) {
        Intrinsics.checkNotNullParameter((Object)$this$doDefaultHighlighterAction, (String)"$this$doDefaultHighlighterAction");
        $this$doDefaultHighlighterAction.setText($text);
        return Unit.INSTANCE;
    }
}

