/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.highlighting;

import com.intellij.ideolog.file.LogFileEditor;
import com.intellij.ideolog.highlighting.LogEvent;
import com.intellij.ideolog.highlighting.LogFileHighlighterFactoryKt;
import com.intellij.ideolog.highlighting.LogHighlightingIterator;
import com.intellij.ideolog.highlighting.settings.LogHighlightingPattern;
import com.intellij.ideolog.highlighting.settings.LogHighlightingSettingsStore;
import com.intellij.ideolog.lex.LogFileFormatsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 ,2\u00020\u0001:\u0001,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\b\u0010#\u001a\u00020\u001bH\u0002J\b\u0010$\u001a\u00020\u001bH\u0002J\u0006\u0010%\u001a\u00020\u001bJ\b\u0010&\u001a\u00020\u001bH\u0002J\u0013\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110\tH\u0002\u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u0016J\u0006\u0010+\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/ideolog/highlighting/LogFileMapRenderer;", "", "myLogFileEditor", "Lcom/intellij/ideolog/file/LogFileEditor;", "<init>", "(Lcom/intellij/ideolog/file/LogFileEditor;)V", "numBuckets", "", "highlighterBuckets", "", "Ljava/awt/Color;", "[Ljava/awt/Color;", "heatMapBuckets", "", "breadcrumbBuckets", "composedBuckets", "myHighlighters", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "[Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "settingsStore", "Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore;", "detachedFromEditor", "", "myMarkupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "myIsEnabledBreadcrumbs", "initBreadcrumbs", "", "getBucketForOffset", "offsStart", "myIsPendingEventMap", "myIsRunningEventMap", "myIsRenderingTimeHighlighting", "mySync", "Ljava/lang/Object;", "initEventMaps", "composeBuckets", "detachFromEditor", "beginInvokeComposeBuckets", "recreateHighlighters", "()[Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "setIsRenderingTimeHighlighting", "value", "invalidateHighlighters", "Companion", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nLogFileMapRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogFileMapRenderer.kt\ncom/intellij/ideolog/highlighting/LogFileMapRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,305:1\n1#2:306\n13409#3,2:307\n*S KotlinDebug\n*F\n+ 1 LogFileMapRenderer.kt\ncom/intellij/ideolog/highlighting/LogFileMapRenderer\n*L\n251#1:307,2\n*E\n"})
public final class LogFileMapRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LogFileEditor myLogFileEditor;
    private final int numBuckets;
    @NotNull
    private final Color[] highlighterBuckets;
    @NotNull
    private final double[] heatMapBuckets;
    @NotNull
    private final double[] breadcrumbBuckets;
    @NotNull
    private final Color[] composedBuckets;
    @Nullable
    private RangeHighlighter[] myHighlighters;
    @NotNull
    private final LogHighlightingSettingsStore settingsStore;
    private boolean detachedFromEditor;
    @NotNull
    private final MarkupModelEx myMarkupModel;
    private boolean myIsEnabledBreadcrumbs;
    private boolean myIsPendingEventMap;
    private boolean myIsRunningEventMap;
    private boolean myIsRenderingTimeHighlighting;
    @NotNull
    private final Object mySync;
    @NotNull
    private static final Key<LogFileMapRenderer> LogFileMapRendererKey;

    public LogFileMapRenderer(@NotNull LogFileEditor myLogFileEditor) {
        Intrinsics.checkNotNullParameter((Object)((Object)myLogFileEditor), (String)"myLogFileEditor");
        this.myLogFileEditor = myLogFileEditor;
        this.numBuckets = 1024;
        this.highlighterBuckets = new Color[this.numBuckets];
        this.heatMapBuckets = new double[this.numBuckets];
        this.breadcrumbBuckets = new double[this.numBuckets];
        this.composedBuckets = new Color[this.numBuckets];
        this.settingsStore = LogHighlightingSettingsStore.Companion.getInstance();
        MarkupModelEx markupModelEx = this.myLogFileEditor.getEditor().getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        this.myMarkupModel = markupModelEx;
        this.composeBuckets();
        this.initBreadcrumbs();
        this.initEventMaps();
        this.myIsEnabledBreadcrumbs = true;
        this.myIsPendingEventMap = true;
        this.mySync = new Object();
    }

    private final void initBreadcrumbs() {
        double growRate = 0.01;
        double interval = 0.333;
        int glowSize = 4;
        int minSize = 4;
        Ref.ObjectRef timer = new Ref.ObjectRef();
        Timer timer2 = new Timer();
        long l = 1000L;
        long l2 = (long)(interval * (double)1000);
        TimerTask timerTask = new TimerTask(this, timer, minSize, growRate, glowSize){
            final /* synthetic */ LogFileMapRenderer this$0;
            final /* synthetic */ Ref.ObjectRef $timer$inlined;
            final /* synthetic */ int $minSize$inlined;
            final /* synthetic */ double $growRate$inlined;
            final /* synthetic */ int $glowSize$inlined;
            {
                this.this$0 = logFileMapRenderer;
                this.$timer$inlined = objectRef;
                this.$minSize$inlined = n;
                this.$growRate$inlined = d;
                this.$glowSize$inlined = n2;
            }

            public void run() {
                TimerTask $this$initBreadcrumbs_u24lambda_u240 = this;
                boolean bl = false;
                if (LogFileMapRenderer.access$getMyLogFileEditor$p(this.this$0).getEditor().isDisposed() || LogFileMapRenderer.access$getDetachedFromEditor$p(this.this$0)) {
                    Object object = this.$timer$inlined.element;
                    Intrinsics.checkNotNull((Object)object);
                    ((TimerTask)object).cancel();
                } else {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this.this$0, this.$minSize$inlined, this.$growRate$inlined, this.$glowSize$inlined){
                        final /* synthetic */ LogFileMapRenderer this$0;
                        final /* synthetic */ int $minSize;
                        final /* synthetic */ double $growRate;
                        final /* synthetic */ int $glowSize;
                        {
                            this.this$0 = $receiver;
                            this.$minSize = $minSize;
                            this.$growRate = $growRate;
                            this.$glowSize = $glowSize;
                        }

                        public final void run() {
                            ApplicationManager.getApplication().runReadAction(new Runnable(this.this$0, this.$minSize, this.$growRate, this.$glowSize){
                                final /* synthetic */ LogFileMapRenderer this$0;
                                final /* synthetic */ int $minSize;
                                final /* synthetic */ double $growRate;
                                final /* synthetic */ int $glowSize;
                                {
                                    this.this$0 = $receiver;
                                    this.$minSize = $minSize;
                                    this.$growRate = $growRate;
                                    this.$glowSize = $glowSize;
                                }

                                public final void run() {
                                    if (LogFileMapRenderer.access$getMyIsEnabledBreadcrumbs$p(this.this$0) && !LogFileMapRenderer.access$getMyLogFileEditor$p(this.this$0).getEditor().isDisposed() && !LogFileMapRenderer.access$getDetachedFromEditor$p(this.this$0) && LogFileMapRenderer.access$getMyLogFileEditor$p(this.this$0).getEditor().getComponent().isVisible() && LogFileMapRenderer.access$getMyLogFileEditor$p(this.this$0).getEditor().getCaretModel().isUpToDate()) {
                                        double bc;
                                        double opacity;
                                        int nBucket;
                                        Rectangle rectangle = LogFileMapRenderer.access$getMyLogFileEditor$p(this.this$0).getEditor().getScrollingModel().getVisibleAreaOnScrollingFinished();
                                        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleAreaOnScrollingFinished(...)");
                                        Rectangle area = rectangle;
                                        int offsStart = LogFileMapRenderer.access$getMyLogFileEditor$p(this.this$0).getEditor().logicalPositionToOffset(LogFileMapRenderer.access$getMyLogFileEditor$p(this.this$0).getEditor().xyToLogicalPosition(area.getLocation()));
                                        int offsEnd = LogFileMapRenderer.access$getMyLogFileEditor$p(this.this$0).getEditor().logicalPositionToOffset(LogFileMapRenderer.access$getMyLogFileEditor$p(this.this$0).getEditor().xyToLogicalPosition(new Point(area.getLocation().x + area.width, area.getLocation().y + area.height)));
                                        int nBucketStart = LogFileMapRenderer.access$getBucketForOffset(this.this$0, offsStart);
                                        int nBucketEnd = LogFileMapRenderer.access$getBucketForOffset(this.this$0, offsEnd);
                                        if (nBucketEnd - nBucketStart < this.$minSize) {
                                            int deficit = this.$minSize - (nBucketEnd - nBucketStart);
                                            nBucketStart = Math.max(nBucketStart - (int)Math.floor((double)deficit / 2.0), 0);
                                            nBucketEnd = Math.min(nBucketEnd + (int)Math.ceil((double)deficit / 2.0), LogFileMapRenderer.access$getNumBuckets$p(this.this$0) - 1);
                                        }
                                        int n = nBucketEnd;
                                        for (nBucket = nBucketStart; nBucket < n; ++nBucket) {
                                            double bc2 = LogFileMapRenderer.access$getBreadcrumbBuckets$p(this.this$0)[nBucket];
                                            if (!(bc2 < 1.0)) continue;
                                            LogFileMapRenderer.access$getBreadcrumbBuckets$p((LogFileMapRenderer)this.this$0)[nBucket] = bc2 + (1.0 - bc2) * this.$growRate;
                                        }
                                        n = nBucketStart;
                                        for (nBucket = Math.max(nBucketStart - this.$glowSize, 0); nBucket < n; ++nBucket) {
                                            opacity = 1.0 - (double)(nBucketStart - nBucket + 1) / (double)(this.$glowSize + 1);
                                            bc = LogFileMapRenderer.access$getBreadcrumbBuckets$p(this.this$0)[nBucket];
                                            if (!(bc < opacity)) continue;
                                            LogFileMapRenderer.access$getBreadcrumbBuckets$p((LogFileMapRenderer)this.this$0)[nBucket] = bc + (opacity - bc) * this.$growRate;
                                        }
                                        n = Math.min(nBucketEnd + this.$glowSize, LogFileMapRenderer.access$getNumBuckets$p(this.this$0) - 1);
                                        for (nBucket = nBucketEnd; nBucket < n; ++nBucket) {
                                            opacity = 1.0 - (double)(nBucket - nBucketEnd + 1) / (double)(this.$glowSize + 1);
                                            bc = LogFileMapRenderer.access$getBreadcrumbBuckets$p(this.this$0)[nBucket];
                                            if (!(bc < opacity)) continue;
                                            LogFileMapRenderer.access$getBreadcrumbBuckets$p((LogFileMapRenderer)this.this$0)[nBucket] = bc + (opacity - bc) * this.$growRate;
                                        }
                                        LogFileMapRenderer.access$composeBuckets(this.this$0);
                                    }
                                }
                            });
                        }
                    });
                }
            }
        };
        timer2.scheduleAtFixedRate(timerTask, l, l2);
        timer.element = timerTask;
    }

    private final int getBucketForOffset(int offsStart) {
        return (int)((double)offsStart / (double)(this.myLogFileEditor.getEditor().getDocument().getTextLength() + 1) * (double)this.numBuckets);
    }

    private final void initEventMaps() {
        double interval = 1.0;
        Ref.ObjectRef timer = new Ref.ObjectRef();
        Timer timer2 = new Timer();
        long l = 1000L;
        long l2 = (long)(interval * (double)1000);
        TimerTask timerTask = new TimerTask(this, timer){
            final /* synthetic */ LogFileMapRenderer this$0;
            final /* synthetic */ Ref.ObjectRef $timer$inlined;
            {
                this.this$0 = logFileMapRenderer;
                this.$timer$inlined = objectRef;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void run() {
                block36: {
                    $this$initEventMaps_u24lambda_u2410 = this;
                    $i$a$-scheduleAtFixedRate-LogFileMapRenderer$initEventMaps$1 = false;
                    if (LogFileMapRenderer.access$getMyLogFileEditor$p(this.this$0).getEditor().isDisposed() || LogFileMapRenderer.access$getDetachedFromEditor$p(this.this$0)) {
                        v0 = this.$timer$inlined.element;
                        Intrinsics.checkNotNull((Object)v0);
                        ((TimerTask)v0).cancel();
                    } else {
                        var3_3 = LogFileMapRenderer.access$getMySync$p(this.this$0);
                        synchronized (var3_3) {
                            $i$a$-synchronized-LogFileMapRenderer$initEventMaps$1$1 = false;
                            if (LogFileMapRenderer.access$getMyIsPendingEventMap$p(this.this$0)) ** break block33
                        }
                        var5_11 = LogFileMapRenderer.access$getMySync$p(this.this$0);
                        synchronized (var5_11) {
                            $i$a$-synchronized-LogFileMapRenderer$initEventMaps$1$4 = false;
                            LogFileMapRenderer.access$setMyIsRunningEventMap$p(this.this$0, false);
                            $i$a$-synchronized-LogFileMapRenderer$initEventMaps$1$4 = Unit.INSTANCE;
                        }
                    }
                    break block36;
                    {
                        if (!LogFileMapRenderer.access$getMyIsRunningEventMap$p(this.this$0)) ** break block34
                    }
                    var5_12 = LogFileMapRenderer.access$getMySync$p(this.this$0);
                    synchronized (var5_12) {
                        $i$a$-synchronized-LogFileMapRenderer$initEventMaps$1$4 = false;
                        LogFileMapRenderer.access$setMyIsRunningEventMap$p(this.this$0, false);
                        $i$a$-synchronized-LogFileMapRenderer$initEventMaps$1$4 = Unit.INSTANCE;
                        break block36;
                    }
                    {
                        LogFileMapRenderer.access$setMyIsRunningEventMap$p(this.this$0, true);
                        LogFileMapRenderer.access$setMyIsPendingEventMap$p(this.this$0, false);
                        $i$a$-synchronized-LogFileMapRenderer$initEventMaps$1$1 = Unit.INSTANCE;
                        // MONITOREXIT @DISABLED, blocks:[3, 4, 7] lbl45 : MonitorExitStatement: MONITOREXIT : var3_3
                        {
                            catch (Throwable $i$a$-synchronized-LogFileMapRenderer$initEventMaps$1$1) {
                                throw $i$a$-synchronized-LogFileMapRenderer$initEventMaps$1$1;
                            }
                        }
                        offsetLimit = LogFileMapRenderer.access$getMyLogFileEditor$p(this.this$0).getEditor().getDocument().getTextLength();
                        fileFormat = LogFileFormatsKt.detectLogFileFormat((Editor)LogFileMapRenderer.access$getMyLogFileEditor$p(this.this$0).getEditor());
                        offs = 0;
                        isRenderingTimeHighlighting = LogFileMapRenderer.access$getMyIsRenderingTimeHighlighting$p(this.this$0);
                        $i$a$-synchronized-LogFileMapRenderer$initEventMaps$1$4 = LogHighlightingSettingsStore.Companion.getInstance().getMyState().getPatterns();
                        $i$f$filter = false;
                        var10_27 = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (LogHighlightingPattern)element$iv$iv;
                            $i$a$-filter-LogFileMapRenderer$initEventMaps$1$customPatterns$1 = false;
                            if (!(it.getEnabled() != false && it.getShowOnStripe() != false && fileFormat.validateFormatUUID(it.getUuid()) != false)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            it = (LogHighlightingPattern)item$iv$iv;
                            var17_35 = destination$iv$iv;
                            $i$a$-map-LogFileMapRenderer$initEventMaps$1$customPatterns$2 = false;
                            var17_35.add(TuplesKt.to((Object)Pattern.compile(it.getPattern(), 2), (Object)it));
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        $i$f$toTypedArray = false;
                        thisCollection$iv = $this$toTypedArray$iv;
                        customPatterns = thisCollection$iv.toArray(new Pair[0]);
                        v1 = (HashSet)LogFileMapRenderer.access$getMyLogFileEditor$p(this.this$0).getEditor().getUserData(LogFileHighlighterFactoryKt.getHighlightingSetUserKey());
                        customHighlightings = v1 != null ? (Set)v1 : SetsKt.emptySet();
                        v2 = LogFileMapRenderer.access$getMyLogFileEditor$p(this.this$0).getEditor().getColorsScheme().getDefaultBackground();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getDefaultBackground(...)");
                        colorDefaultBackground = v2;
                        nBucketCur = new Ref.IntRef();
                        nCurBucketMaxTimeDelta = new Ref.LongRef();
                        colorCurCustomHighlighter = new Ref.ObjectRef();
                        timestampPrev = null;
                        while (offs < offsetLimit && !((logEvent = LogEvent.Companion.fromEditor((Editor)LogFileMapRenderer.access$getMyLogFileEditor$p(this.this$0).getEditor(), offs)).getRawText().length() == 0)) {
                            block35: {
                                offs += logEvent.getRawText().length();
                                if (isRenderingTimeHighlighting) {
                                    it = logEvent.getDate();
                                    $i$a$-let-LogFileMapRenderer$initEventMaps$1$timestamp$1 = false;
                                    v3 = fileFormat.parseLogEventTimeSeconds(it);
                                    v4 = v3;
                                    if (v3 == null) {
                                        v4 = timestampPrev;
                                    }
                                } else {
                                    v4 = 0L;
                                }
                                timeDelta = (timestamp = v4) != null && timestampPrev != null ? timestamp - timestampPrev : 0L;
                                timestampPrev = timestamp;
                                colorCustomHighlighter = new Ref.ObjectRef();
                                var22_41 = customPatterns;
                                var17_35 = colorCustomHighlighter;
                                $i$f$firstOrNull = false;
                                var25_47 = ((void)$this$firstOrNull$iv).length;
                                for (var24_45 = 0; var24_45 < var25_47; ++var24_45) {
                                    it = element$iv = $this$firstOrNull$iv[var24_45];
                                    $i$a$-firstOrNull-LogFileMapRenderer$initEventMaps$1$colorCustomHighlighter$1 = false;
                                    if (!((Pattern)it.getFirst()).matcher(logEvent.getRawText()).find()) continue;
                                    v5 = element$iv;
                                    break block35;
                                }
                                v5 = null;
                            }
                            v6 = var17_35;
                            v7 = v5;
                            if (v5 != null && (v7 = (LogHighlightingPattern)v7.getSecond()) != null) {
                                var24_46 = v7;
                                var17_35 = v6;
                                $i$a$-let-LogFileMapRenderer$initEventMaps$1$colorCustomHighlighter$2 = false;
                                v8 = it.getForegroundColor();
                                if (v8 == null) {
                                    v8 = it.getBackgroundColor();
                                }
                                v9 = v8;
                                v6 = var17_35;
                            } else {
                                v9 = v6.element = null;
                            }
                            if (colorCustomHighlighter.element == null) {
                                for (String word : customHighlightings) {
                                    if (!StringsKt.contains$default((CharSequence)logEvent.getRawText(), (CharSequence)word, (boolean)false, (int)2, null)) continue;
                                    colorCustomHighlighter.element = LogHighlightingIterator.Companion.getLineBackground(word, colorDefaultBackground);
                                }
                            }
                            nBucketEnd = LogFileMapRenderer.access$getBucketForOffset(this.this$0, logEvent.getStartOffset() + logEvent.getRawText().length() - 1);
                            $this$forEach$iv = (Iterable)new IntRange(nBucketCur.element, nBucketEnd);
                            $i$f$forEach = false;
                            var24_44 = $this$forEach$iv.iterator();
                            while (var24_44.hasNext()) {
                                it = element$iv = ((IntIterator)var24_44).nextInt();
                                $i$a$-forEach-LogFileMapRenderer$initEventMaps$1$2 = false;
                                nCurBucketMaxTimeDelta.element = Math.max(nCurBucketMaxTimeDelta.element, timeDelta);
                                v10 = (Color)colorCurCustomHighlighter.element;
                                if (v10 == null) {
                                    v10 = colorCurCustomHighlighter.element = (Color)colorCustomHighlighter.element;
                                }
                                if (nBucketCur.element >= nBucketEnd) continue;
                                LogFileMapRenderer.access$initEventMaps$lambda$10$commitBucket(nBucketCur, this.this$0, colorCurCustomHighlighter, nCurBucketMaxTimeDelta);
                            }
                            v11 = var22_40 = nBucketCur.element == nBucketEnd;
                            if (!_Assertions.ENABLED || var22_40) continue;
                            $i$a$-assert-LogFileMapRenderer$initEventMaps$1$3 = false;
                            var23_43 = "miscounted";
                            throw new AssertionError((Object)var23_43);
                        }
                        LogFileMapRenderer.access$initEventMaps$lambda$10$commitBucket(nBucketCur, this.this$0, colorCurCustomHighlighter, nCurBucketMaxTimeDelta);
                        LogFileMapRenderer.access$beginInvokeComposeBuckets(this.this$0);
                        break block36;
                    }
                    catch (Throwable var7_20) {
                        throw var7_20;
                    }
                    {
                        finally {
                            var3_3 = LogFileMapRenderer.access$getMySync$p(this.this$0);
                            synchronized (var3_3) {
                                $i$a$-synchronized-LogFileMapRenderer$initEventMaps$1$4 = false;
                                LogFileMapRenderer.access$setMyIsRunningEventMap$p(this.this$0, false);
                                var4_8 = Unit.INSTANCE;
                            }
                        }
                    }
                }
            }
        };
        timer2.scheduleAtFixedRate(timerTask, l, l2);
        timer.element = timerTask;
    }

    /*
     * WARNING - void declaration
     */
    private final void composeBuckets() {
        RangeHighlighter[] rangeHighlighterArray = this.myHighlighters;
        RangeHighlighter[] highlighters = rangeHighlighterArray == null || rangeHighlighterArray.length == 0 ? this.recreateHighlighters() : this.myHighlighters;
        rangeHighlighterArray = highlighters;
        if (rangeHighlighterArray == null || rangeHighlighterArray.length == 0) {
            return;
        }
        int n = this.numBuckets;
        for (int nBucket = 0; nBucket < n; ++nBucket) {
            void $this$composeBuckets_u24lambda_u2411;
            TextAttributes textAttributes;
            Color newColor;
            if (this.highlighterBuckets[nBucket] != null) {
                Color color = this.highlighterBuckets[nBucket];
                v1 = color;
                Intrinsics.checkNotNull((Object)color);
            } else if (Intrinsics.areEqual((Object)this.settingsStore.getMyState().getErrorStripeMode(), (Object)"heatmap")) {
                double hue = this.heatMapBuckets[nBucket] * -1.0 / 3.0 + 0.3333333333333333;
                double bri = this.breadcrumbBuckets[nBucket] * 0.35 + 0.6;
                double sat = 0.5;
                v1 = Color.getHSBColor((float)hue, (float)sat, (float)bri);
            } else {
                v1 = newColor = null;
            }
            if (Intrinsics.areEqual((Object)this.composedBuckets[nBucket], (Object)newColor)) continue;
            this.composedBuckets[nBucket] = newColor;
            TextAttributes textAttributes2 = textAttributes = new TextAttributes();
            RangeHighlighter rangeHighlighter = highlighters[nBucket];
            MarkupModelEx markupModelEx = this.myMarkupModel;
            boolean bl = false;
            $this$composeBuckets_u24lambda_u2411.setAttributes(null, null, null, newColor, EffectType.BOXED, 0);
            Unit unit = Unit.INSTANCE;
            markupModelEx.setRangeHighlighterAttributes(rangeHighlighter, textAttributes);
        }
    }

    public final void detachFromEditor() {
        if (this.myHighlighters != null) {
            RangeHighlighter[] $this$forEach$iv = this.myHighlighters;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                RangeHighlighter element$iv;
                RangeHighlighter it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                this.myMarkupModel.removeHighlighter(it);
            }
        }
        this.myLogFileEditor.getEditor().putUserData(LogFileMapRendererKey, null);
        this.detachedFromEditor = true;
    }

    private final void beginInvokeComposeBuckets() {
        ApplicationManager.getApplication().invokeLater(() -> LogFileMapRenderer.beginInvokeComposeBuckets$lambda$14(this));
    }

    /*
     * WARNING - void declaration
     */
    private final RangeHighlighter[] recreateHighlighters() {
        if (this.detachedFromEditor || this.myLogFileEditor.getEditor().isDisposed()) {
            return new RangeHighlighter[0];
        }
        if (this.myHighlighters != null) {
            Intrinsics.checkNotNull((Object)this.myHighlighters);
            for (RangeHighlighter h : this.myHighlighters) {
                this.myMarkupModel.removeHighlighter(h);
            }
        }
        double docLen = this.myLogFileEditor.getEditor().getDocument().getTextLength();
        int n = 0;
        int n2 = this.numBuckets;
        RangeHighlighter[] rangeHighlighterArray = new RangeHighlighter[n2];
        LogFileMapRenderer logFileMapRenderer = this;
        while (n < n2) {
            void $this$recreateHighlighters_u24lambda_u2415;
            TextAttributes textAttributes;
            int n3 = n++;
            TextAttributes textAttributes2 = textAttributes = new TextAttributes();
            int n4 = 7;
            int n5 = (int)(docLen / (double)this.numBuckets * (double)(n3 + 1));
            int n6 = (int)(docLen / (double)this.numBuckets * (double)n3);
            MarkupModelEx markupModelEx = this.myMarkupModel;
            int n7 = n3;
            RangeHighlighter[] rangeHighlighterArray2 = rangeHighlighterArray;
            boolean bl = false;
            $this$recreateHighlighters_u24lambda_u2415.setAttributes(null, null, null, this.composedBuckets[n3], EffectType.BOXED, 0);
            Unit unit = Unit.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)markupModelEx.addRangeHighlighter(n6, n5, n4, textAttributes, HighlighterTargetArea.EXACT_RANGE), (String)"addRangeHighlighter(...)");
        }
        logFileMapRenderer.myHighlighters = rangeHighlighterArray;
        Intrinsics.checkNotNull((Object)this.myHighlighters);
        return this.myHighlighters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setIsRenderingTimeHighlighting(boolean value) {
        if (this.myIsRenderingTimeHighlighting == value) {
            return;
        }
        this.myIsRenderingTimeHighlighting = value;
        Object object = this.mySync;
        synchronized (object) {
            boolean bl = false;
            this.myIsPendingEventMap = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidateHighlighters() {
        Object object = this.mySync;
        synchronized (object) {
            boolean bl = false;
            this.myIsPendingEventMap = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void initEventMaps$lambda$10$commitBucket(Ref.IntRef nBucketCur, LogFileMapRenderer this$0, Ref.ObjectRef<Color> colorCurCustomHighlighter, Ref.LongRef nCurBucketMaxTimeDelta) {
        if (nBucketCur.element >= this$0.numBuckets) {
            return;
        }
        this$0.highlighterBuckets[nBucketCur.element] = colorCurCustomHighlighter.element;
        if (!Intrinsics.areEqual((Object)this$0.highlighterBuckets[Math.max(nBucketCur.element - 1, 0)], (Object)colorCurCustomHighlighter.element)) {
            this$0.highlighterBuckets[Math.max((int)(nBucketCur.element - 1), (int)0)] = colorCurCustomHighlighter.element;
        }
        colorCurCustomHighlighter.element = null;
        double maxSec = 15000.0;
        double heatValue = Math.max(0.0, (double)Math.min(nCurBucketMaxTimeDelta.element, 10L) / maxSec);
        nCurBucketMaxTimeDelta.element = 0L;
        this$0.heatMapBuckets[nBucketCur.element] = heatValue;
        if (this$0.heatMapBuckets[Math.max(nBucketCur.element - 1, 0)] < heatValue) {
            this$0.heatMapBuckets[Math.max((int)(nBucketCur.element - 1), (int)0)] = heatValue;
        }
        int n = nBucketCur.element;
        nBucketCur.element = n + 1;
    }

    private static final void beginInvokeComposeBuckets$lambda$14$lambda$13(LogFileMapRenderer this$0) {
        if (!this$0.myLogFileEditor.getEditor().isDisposed() && !this$0.detachedFromEditor && this$0.myLogFileEditor.getEditor().getComponent().isVisible() && this$0.myLogFileEditor.getEditor().getCaretModel().isUpToDate()) {
            this$0.composeBuckets();
        }
    }

    private static final void beginInvokeComposeBuckets$lambda$14(LogFileMapRenderer this$0) {
        ApplicationManager.getApplication().runReadAction(() -> LogFileMapRenderer.beginInvokeComposeBuckets$lambda$14$lambda$13(this$0));
    }

    public static final /* synthetic */ LogFileEditor access$getMyLogFileEditor$p(LogFileMapRenderer $this) {
        return $this.myLogFileEditor;
    }

    public static final /* synthetic */ boolean access$getDetachedFromEditor$p(LogFileMapRenderer $this) {
        return $this.detachedFromEditor;
    }

    public static final /* synthetic */ boolean access$getMyIsEnabledBreadcrumbs$p(LogFileMapRenderer $this) {
        return $this.myIsEnabledBreadcrumbs;
    }

    public static final /* synthetic */ int access$getBucketForOffset(LogFileMapRenderer $this, int offsStart) {
        return $this.getBucketForOffset(offsStart);
    }

    public static final /* synthetic */ int access$getNumBuckets$p(LogFileMapRenderer $this) {
        return $this.numBuckets;
    }

    public static final /* synthetic */ double[] access$getBreadcrumbBuckets$p(LogFileMapRenderer $this) {
        return $this.breadcrumbBuckets;
    }

    public static final /* synthetic */ void access$composeBuckets(LogFileMapRenderer $this) {
        $this.composeBuckets();
    }

    public static final /* synthetic */ boolean access$getMyIsPendingEventMap$p(LogFileMapRenderer $this) {
        return $this.myIsPendingEventMap;
    }

    public static final /* synthetic */ boolean access$getMyIsRunningEventMap$p(LogFileMapRenderer $this) {
        return $this.myIsRunningEventMap;
    }

    public static final /* synthetic */ void access$setMyIsRunningEventMap$p(LogFileMapRenderer $this, boolean bl) {
        $this.myIsRunningEventMap = bl;
    }

    public static final /* synthetic */ void access$setMyIsPendingEventMap$p(LogFileMapRenderer $this, boolean bl) {
        $this.myIsPendingEventMap = bl;
    }

    public static final /* synthetic */ void access$initEventMaps$lambda$10$commitBucket(Ref.IntRef nBucketCur, LogFileMapRenderer this$0, Ref.ObjectRef colorCurCustomHighlighter, Ref.LongRef nCurBucketMaxTimeDelta) {
        LogFileMapRenderer.initEventMaps$lambda$10$commitBucket(nBucketCur, this$0, (Ref.ObjectRef<Color>)colorCurCustomHighlighter, nCurBucketMaxTimeDelta);
    }

    public static final /* synthetic */ Object access$getMySync$p(LogFileMapRenderer $this) {
        return $this.mySync;
    }

    public static final /* synthetic */ boolean access$getMyIsRenderingTimeHighlighting$p(LogFileMapRenderer $this) {
        return $this.myIsRenderingTimeHighlighting;
    }

    public static final /* synthetic */ void access$beginInvokeComposeBuckets(LogFileMapRenderer $this) {
        $this.beginInvokeComposeBuckets();
    }

    static {
        Key key = Key.create((String)"LogFileMapRenderer");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        LogFileMapRendererKey = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rJ\u0015\u0010\u000e\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u000f2\u0006\u0010\f\u001a\u00020\u0010R$\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ideolog/highlighting/LogFileMapRenderer$Companion;", "", "<init>", "()V", "LogFileMapRendererKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ideolog/highlighting/LogFileMapRenderer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getLogFileMapRendererKey", "()Lcom/intellij/openapi/util/Key;", "getOrCreateLogFileMapRenderer", "editor", "Lcom/intellij/ideolog/file/LogFileEditor;", "getLogFileMapRenderer", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/openapi/editor/Editor;", "intellij.ideolog"})
    @SourceDebugExtension(value={"SMAP\nLogFileMapRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogFileMapRenderer.kt\ncom/intellij/ideolog/highlighting/LogFileMapRenderer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,305:1\n1#2:306\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<LogFileMapRenderer> getLogFileMapRendererKey() {
            return LogFileMapRendererKey;
        }

        @NotNull
        public final Object getOrCreateLogFileMapRenderer(@NotNull LogFileEditor editor) {
            Intrinsics.checkNotNullParameter((Object)((Object)editor), (String)"editor");
            LogFileMapRenderer logFileMapRenderer = this.getLogFileMapRenderer((Editor)editor.getEditor());
            if (logFileMapRenderer == null) {
                LogFileMapRenderer it = new LogFileMapRenderer(editor);
                boolean bl = false;
                editor.getEditor().putUserData(Companion.getLogFileMapRendererKey(), (Object)it);
                logFileMapRenderer = Unit.INSTANCE;
            }
            return logFileMapRenderer;
        }

        @Nullable
        public final LogFileMapRenderer getLogFileMapRenderer(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (LogFileMapRenderer)editor.getUserData(this.getLogFileMapRendererKey());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

