/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.highlighting;

import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.ideolog.filters.StackTraceFileFilter;
import com.intellij.ideolog.highlighting.DynamicLogFilterServiceClassProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ideolog/highlighting/LogHeavyFilterService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myFilters", "", "Lcom/intellij/execution/filters/Filter;", "myCompositeFilter", "Lcom/intellij/execution/filters/CompositeFilter;", "myAlarm", "Lcom/intellij/util/Alarm;", "enqueueHeavyFiltering", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "eventOffset", "", "event", "", "dispose", "Companion", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nLogHeavyFilterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogHeavyFilterService.kt\ncom/intellij/ideolog/highlighting/LogHeavyFilterService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n10072#2:98\n10494#2,5:99\n1053#3:104\n1863#3,2:106\n1863#3,2:108\n1872#3,3:110\n1#4:105\n*S KotlinDebug\n*F\n+ 1 LogHeavyFilterService.kt\ncom/intellij/ideolog/highlighting/LogHeavyFilterService\n*L\n31#1:98\n31#1:99,5\n32#1:104\n80#1:106,2\n61#1:108,2\n87#1:110,3\n*E\n"})
public class LogHeavyFilterService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Filter> myFilters;
    @NotNull
    private final CompositeFilter myCompositeFilter;
    @NotNull
    private final Alarm myAlarm;
    @NotNull
    private static final Key<HashSet<Integer>> markupHighlightedExceptionsKey;
    @NotNull
    private static final Key<EditorHyperlinkSupport> markupHyperlinkSupportKey;

    /*
     * WARNING - void declaration
     */
    public LogHeavyFilterService(@NotNull Project project) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = ConsoleFilterProvider.FILTER_PROVIDERS.getExtensions();
        LogHeavyFilterService logHeavyFilterService = this;
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            ConsoleFilterProvider it = (ConsoleFilterProvider)element$iv$iv;
            boolean bl = false;
            Filter[] filterArray = it.getDefaultFilters(project);
            Intrinsics.checkNotNullExpressionValue((Object)filterArray, (String)"getDefaultFilters(...)");
            Iterable list$iv$iv = ArraysKt.asIterable((Object[])filterArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        logHeavyFilterService.myFilters = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Filter it = (Filter)a;
                boolean bl = false;
                int n = it instanceof StackTraceFileFilter ? -1 : 1;
                it = (Filter)b;
                Comparable comparable = Integer.valueOf(n);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it instanceof StackTraceFileFilter ? -1 : 1));
            }
        });
        this.myCompositeFilter = new CompositeFilter(project, this.myFilters);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueHeavyFiltering(@NotNull Editor editor, int eventOffset, @NotNull CharSequence event) {
        HashSet<Integer> set;
        Object it;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (editor.isDisposed()) {
            return;
        }
        CompositeFilter compositeFilter = this.myCompositeFilter;
        MarkupModel markupModel = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        MarkupModel markupModel2 = markupModel;
        HashSet<Integer> hashSet = (HashSet<Integer>)markupModel2.getUserData(markupHighlightedExceptionsKey);
        if (hashSet == null) {
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            it = hashSet2;
            boolean bl = false;
            markupModel2.putUserData(markupHighlightedExceptionsKey, it);
            hashSet = hashSet2;
        }
        HashSet<Integer> hashSet3 = set = hashSet;
        synchronized (hashSet3) {
            boolean bl = false;
            if (set.contains(eventOffset)) {
                return;
            }
            bl = set.add(eventOffset);
        }
        Object object = (EditorHyperlinkSupport)markupModel2.getUserData(markupHyperlinkSupportKey);
        if (object == null) {
            Project project = editor.getProject();
            Intrinsics.checkNotNull((Object)project);
            Object it2 = it = new EditorHyperlinkSupport(editor, project);
            boolean bl = false;
            markupModel2.putUserData(markupHyperlinkSupportKey, it2);
            object = it;
        }
        EditorHyperlinkSupport hyperlinkSupport = object;
        it = new char[1];
        it[0] = 10;
        List lines = StringsKt.split$default((CharSequence)event, (char[])it, (boolean)false, (int)0, (int)6, null);
        DocumentImpl subDoc = new DocumentImpl(event);
        int offset = 0;
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            LogHeavyFilterService.enqueueHeavyFiltering$consumeResult(editor, eventOffset, hyperlinkSupport, markupModel2, compositeFilter.applyFilter(line, eventOffset + (offset += line.length())), false);
            ++offset;
        }
        this.myAlarm.addRequest(() -> LogHeavyFilterService.enqueueHeavyFiltering$lambda$11(compositeFilter, lines, subDoc, editor, eventOffset, hyperlinkSupport, markupModel2), 0);
    }

    public void dispose() {
    }

    private static final void enqueueHeavyFiltering$consumeResult$lambda$6(Editor $editor, boolean $addOffset, int $eventOffset, Filter.Result $result, EditorHyperlinkSupport $hyperlinkSupport, MarkupModel $markupModel) {
        if ($editor.isDisposed()) {
            return;
        }
        int extraOffset = $addOffset ? $eventOffset : 0;
        List list = $result.getResultItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResultItems(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Filter.ResultItem it = (Filter.ResultItem)element$iv;
            boolean bl = false;
            HyperlinkInfo hyperlinkInfo = it.getHyperlinkInfo();
            int highlightStartOffset = it.getHighlightStartOffset() + extraOffset;
            int highlightEndOffset = it.getHighlightEndOffset() + extraOffset;
            if (highlightEndOffset > $editor.getDocument().getTextLength()) continue;
            RangeHighlighter rangeHighlighter = hyperlinkInfo != null ? $hyperlinkSupport.createHyperlink(highlightStartOffset, highlightEndOffset, it.getHighlightAttributes(), hyperlinkInfo) : $markupModel.addRangeHighlighter(highlightStartOffset, highlightEndOffset, it.getHighlighterLayer(), it.getHighlightAttributes(), HighlighterTargetArea.EXACT_RANGE);
        }
    }

    private static final void enqueueHeavyFiltering$consumeResult(Editor $editor, int $eventOffset, EditorHyperlinkSupport hyperlinkSupport, MarkupModel markupModel, Filter.Result result, boolean addOffset) {
        if (result == null) {
            return;
        }
        if ($editor.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> LogHeavyFilterService.enqueueHeavyFiltering$consumeResult$lambda$6($editor, addOffset, $eventOffset, result, hyperlinkSupport, markupModel));
    }

    private static final Unit enqueueHeavyFiltering$lambda$11$lambda$10$lambda$8(Editor $editor, int $eventOffset, EditorHyperlinkSupport $hyperlinkSupport, MarkupModel $markupModel, FilterMixin.AdditionalHighlight it) {
        LogHeavyFilterService.enqueueHeavyFiltering$consumeResult($editor, $eventOffset, $hyperlinkSupport, $markupModel, (Filter.Result)it, true);
        return Unit.INSTANCE;
    }

    private static final void enqueueHeavyFiltering$lambda$11$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void enqueueHeavyFiltering$lambda$11(CompositeFilter $compositeFilter, List $lines, DocumentImpl $subDoc, Editor $editor, int $eventOffset, EditorHyperlinkSupport $hyperlinkSupport, MarkupModel $markupModel) {
        if ($compositeFilter.shouldRunHeavy()) {
            Iterable $this$forEachIndexed$iv = $lines;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String cfr_ignored_0 = (String)item$iv;
                int index = n;
                boolean bl = false;
                $compositeFilter.applyHeavyFilter((Document)$subDoc, 0, index, arg_0 -> LogHeavyFilterService.enqueueHeavyFiltering$lambda$11$lambda$10$lambda$9(arg_0 -> LogHeavyFilterService.enqueueHeavyFiltering$lambda$11$lambda$10$lambda$8($editor, $eventOffset, $hyperlinkSupport, $markupModel, arg_0), arg_0));
            }
        }
    }

    static {
        Key key = Key.create((String)"Log.ParsedExceptions");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        markupHighlightedExceptionsKey = key;
        Key key2 = Key.create((String)"Log.ExceptionsHyperlinks");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        markupHyperlinkSupportKey = key2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007RF\u0010\b\u001a7\u0012.\u0012,\u0012\u0004\u0012\u00020\u000b \r*\u0016\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nj\n\u0012\u0004\u0012\u00020\u000b\u0018\u0001`\f0\nj\b\u0012\u0004\u0012\u00020\u000b`\f0\t\u00a2\u0006\u0002\b\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R'\u0010\u0011\u001a\u0015\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00120\u00120\t\u00a2\u0006\u0002\b\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ideolog/highlighting/LogHeavyFilterService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ideolog/highlighting/LogHeavyFilterService;", "project", "Lcom/intellij/openapi/project/Project;", "markupHighlightedExceptionsKey", "Lcom/intellij/openapi/util/Key;", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getMarkupHighlightedExceptionsKey", "()Lcom/intellij/openapi/util/Key;", "markupHyperlinkSupportKey", "Lcom/intellij/execution/impl/EditorHyperlinkSupport;", "getMarkupHyperlinkSupportKey$intellij_ideolog", "intellij.ideolog"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LogHeavyFilterService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = (DynamicLogFilterServiceClassProvider)CollectionsKt.firstOrNull((List)DynamicLogFilterServiceClassProvider.EP_NAME.getExtensionList());
            if (object == null || (object = object.getFilterServiceClass()) == null) {
                object = LogHeavyFilterService.class;
            }
            Class<LogHeavyFilterService> serviceClass = object;
            Object object2 = project.getService(serviceClass);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getService(...)");
            return (LogHeavyFilterService)object2;
        }

        @NotNull
        public final Key<HashSet<Integer>> getMarkupHighlightedExceptionsKey() {
            return markupHighlightedExceptionsKey;
        }

        @NotNull
        public final Key<EditorHyperlinkSupport> getMarkupHyperlinkSupportKey$intellij_ideolog() {
            return markupHyperlinkSupportKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

