/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.highlighting.settings;

import com.intellij.ideolog.IdeologBundle;
import com.intellij.ideolog.highlighting.settings.LogHighlightingAction;
import com.intellij.ideolog.highlighting.settings.LogHighlightingPattern;
import com.intellij.ideolog.highlighting.settings.LogHighlightingSettingsStore;
import java.util.ArrayList;
import java.util.UUID;
import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0014\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\"\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0010J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0007J\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ideolog/highlighting/settings/LogPatternTableModel;", "Ljavax/swing/table/AbstractTableModel;", "store", "Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore$State;", "<init>", "(Lcom/intellij/ideolog/highlighting/settings/LogHighlightingSettingsStore$State;)V", "getRowCount", "", "getColumnCount", "isCellEditable", "", "rowIndex", "columnIndex", "getColumnClass", "Ljava/lang/Class;", "getColumnName", "", "column", "setValueAt", "", "aValue", "", "getValueAt", "addNewPattern", "pattern", "removePattern", "index", "updateStore", "myLogHighlightingStore", "intellij.ideolog"})
public final class LogPatternTableModel
extends AbstractTableModel {
    @NotNull
    private LogHighlightingSettingsStore.State store;

    public LogPatternTableModel(@NotNull LogHighlightingSettingsStore.State store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
    }

    @Override
    public int getRowCount() {
        return this.store.getPatterns().size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex < 2;
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int columnIndex) {
        return switch (columnIndex) {
            case 0 -> Boolean.class;
            case 1 -> String.class;
            case 2 -> LogHighlightingPattern.class;
            default -> Object.class;
        };
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        return switch (column) {
            case 0 -> IdeologBundle.message("column.enabled", new Object[0]);
            case 1 -> IdeologBundle.message("column.pattern", new Object[0]);
            case 2 -> IdeologBundle.message("column.action", new Object[0]);
            default -> "";
        };
    }

    @Override
    public void setValueAt(@Nullable Object aValue, int rowIndex, int columnIndex) {
        LogHighlightingPattern logHighlightingPattern = this.store.getPatterns().get(rowIndex);
        Intrinsics.checkNotNullExpressionValue((Object)logHighlightingPattern, (String)"get(...)");
        LogHighlightingPattern item = logHighlightingPattern;
        switch (columnIndex) {
            case 0: {
                Intrinsics.checkNotNull((Object)aValue, (String)"null cannot be cast to non-null type kotlin.Boolean");
                item.setEnabled((Boolean)aValue);
                break;
            }
            case 1: {
                Intrinsics.checkNotNull((Object)aValue, (String)"null cannot be cast to non-null type kotlin.String");
                item.setPattern((String)aValue);
            }
        }
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        LogHighlightingPattern logHighlightingPattern = this.store.getPatterns().get(rowIndex);
        Intrinsics.checkNotNullExpressionValue((Object)logHighlightingPattern, (String)"get(...)");
        LogHighlightingPattern value = logHighlightingPattern;
        return switch (columnIndex) {
            case 0 -> value.getEnabled();
            case 1 -> value.getPattern();
            case 2 -> value;
            default -> null;
        };
    }

    public final void addNewPattern(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        ArrayList<LogHighlightingPattern> arrayList = this.store.getPatterns();
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        arrayList.add(new LogHighlightingPattern(true, pattern, null, 0, LogHighlightingAction.HIGHLIGHT_FIELD, null, null, false, false, true, uUID));
        int index = this.store.getPatterns().size() - 1;
        this.fireTableRowsInserted(index, index);
    }

    public final void removePattern(int index) {
        this.store.getPatterns().remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public final void updateStore(@NotNull LogHighlightingSettingsStore.State myLogHighlightingStore) {
        Intrinsics.checkNotNullParameter((Object)myLogHighlightingStore, (String)"myLogHighlightingStore");
        this.store = myLogHighlightingStore;
        this.fireTableDataChanged();
    }
}

