/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.intentions;

import com.intellij.ideolog.highlighting.LogEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0005\u0018\u0000 22\u00020\u0001:\u00012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001fH\u0016J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J+\u0010+\u001a\u00020\u00072\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u00101R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\tR\u001a\u0010!\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\t\"\u0004\b#\u0010\u000bR\u001a\u0010$\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\t\"\u0004\b&\u0010\u000b\u00a8\u00063"}, d2={"Lcom/intellij/ideolog/intentions/FileMatch;", "", "evt", "Lcom/intellij/ideolog/highlighting/LogEvent;", "<init>", "(Lcom/intellij/ideolog/highlighting/LogEvent;)V", "levelPresent", "", "getLevelPresent", "()I", "setLevelPresent", "(I)V", "categoryPresent", "getCategoryPresent", "setCategoryPresent", "messageTrigramCount", "getMessageTrigramCount", "setMessageTrigramCount", "filenameMatch", "_vf", "Lcom/intellij/openapi/vfs/VirtualFile;", "value", "virtualFile", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setVirtualFile", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "priority", "getPriority", "calculateFilenameMatch", "name", "", "toString", "bestScore", "getBestScore", "setBestScore", "bestLine", "getBestLine", "setBestLine", "processFileOffset", "", "psiManager", "Lcom/intellij/psi/PsiManager;", "longestSubstring", "m", "", "", "a", "b", "([[ILjava/lang/String;Ljava/lang/String;)I", "Companion", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nLogJumpToSourceIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogJumpToSourceIntention.kt\ncom/intellij/ideolog/intentions/FileMatch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,286:1\n1872#2,3:287\n*S KotlinDebug\n*F\n+ 1 LogJumpToSourceIntention.kt\ncom/intellij/ideolog/intentions/FileMatch\n*L\n88#1:287,3\n*E\n"})
public final class FileMatch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LogEvent evt;
    private int levelPresent;
    private int categoryPresent;
    private int messageTrigramCount;
    private int filenameMatch;
    private VirtualFile _vf;
    private int bestScore;
    private int bestLine;
    private static final int LIMIT = 100;
    @NotNull
    private static final int[][] m;

    public FileMatch(@NotNull LogEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.evt = evt;
    }

    public final int getLevelPresent() {
        return this.levelPresent;
    }

    public final void setLevelPresent(int n) {
        this.levelPresent = n;
    }

    public final int getCategoryPresent() {
        return this.categoryPresent;
    }

    public final void setCategoryPresent(int n) {
        this.categoryPresent = n;
    }

    public final int getMessageTrigramCount() {
        return this.messageTrigramCount;
    }

    public final void setMessageTrigramCount(int n) {
        this.messageTrigramCount = n;
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this._vf;
        if (virtualFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_vf");
            virtualFile = null;
        }
        return virtualFile;
    }

    public final void setVirtualFile(@NotNull VirtualFile value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._vf = value;
        VirtualFile virtualFile = this._vf;
        if (virtualFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_vf");
            virtualFile = null;
        }
        String string = virtualFile.getNameWithoutExtension();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        this.filenameMatch = this.calculateFilenameMatch(string);
    }

    public final int getPriority() {
        return this.filenameMatch * 15 + this.categoryPresent * 3 + this.levelPresent * 2 + this.messageTrigramCount;
    }

    public final int calculateFilenameMatch(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!StringsKt.isBlank((CharSequence)this.evt.getCategory())) {
            if (Intrinsics.areEqual((Object)name, (Object)this.evt.getCategory())) {
                return 2;
            }
            if (StringsKt.startsWith$default((String)name, (String)this.evt.getCategory(), (boolean)false, (int)2, null) && (double)name.length() <= (double)this.evt.getCategory().length() * 1.5) {
                return 1;
            }
        } else {
            int n;
            Regex regex = new Regex("\\p{P}|\\s");
            CharSequence charSequence = this.evt.getRawText();
            if (regex.split(charSequence, n = 0).contains(name)) {
                return 1;
            }
        }
        return 0;
    }

    @NotNull
    public String toString() {
        return "Match(" + this.getVirtualFile().getPresentableName() + "): (level: " + this.levelPresent + ", category: " + this.categoryPresent + ", message: " + this.messageTrigramCount + " of " + this.evt.getMessageTrigrams().size() + ", priority:  " + this.getPriority() + ", filename: " + this.filenameMatch + ", best: " + this.bestScore + ")";
    }

    public final int getBestScore() {
        return this.bestScore;
    }

    public final void setBestScore(int n) {
        this.bestScore = n;
    }

    public final int getBestLine() {
        return this.bestLine;
    }

    public final void setBestLine(int n) {
        this.bestLine = n;
    }

    /*
     * WARNING - void declaration
     */
    public final void processFileOffset(@NotNull PsiManager psiManager) {
        Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
        String string = (String)ReadAction.compute(() -> FileMatch.processFileOffset$lambda$0(psiManager, this));
        if (string == null) {
            return;
        }
        String text = string;
        String strForSubstring = StringsKt.take((String)this.evt.getMessage(), (int)100);
        Iterable $this$forEachIndexed$iv = StringsKt.lines((CharSequence)text);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int score;
            void strInCode;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv;
            int line = n;
            boolean bl = false;
            String limitedStrInCode = StringsKt.take((String)((Object)StringsKt.trim((CharSequence)((CharSequence)strInCode))).toString(), (int)100);
            if (!StringsKt.contains$default((CharSequence)limitedStrInCode, (CharSequence)"\"", (boolean)false, (int)2, null) || (score = this.longestSubstring(m, strForSubstring, limitedStrInCode)) <= this.bestScore) continue;
            this.bestLine = line;
            this.bestScore = score;
        }
    }

    private final int longestSubstring(int[][] m, String a, String b) {
        if (((CharSequence)a).length() == 0 || ((CharSequence)b).length() == 0) {
            return 0;
        }
        int maxLength = 0;
        int i = 0;
        int n = StringsKt.getLastIndex((CharSequence)a);
        if (i <= n) {
            while (true) {
                int n2;
                int j;
                if ((j = 0) <= (n2 = StringsKt.getLastIndex((CharSequence)b))) {
                    while (true) {
                        if (a.charAt(i) == b.charAt(j)) {
                            m[i][j] = i != 0 && j != 0 ? m[i - 1][j - 1] + 1 : 1;
                            if (m[i][j] > maxLength) {
                                maxLength = m[i][j];
                            }
                        } else {
                            m[i][j] = 0;
                        }
                        if (j == n2) break;
                        ++j;
                    }
                }
                if (i == n) break;
                ++i;
            }
        }
        return maxLength;
    }

    private static final String processFileOffset$lambda$0(PsiManager $psiManager, FileMatch this$0) {
        PsiFile psiFile = $psiManager.findFile(this$0.getVirtualFile());
        return psiFile != null ? psiFile.getText() : null;
    }

    static {
        int n = 0;
        int[][] nArrayArray = new int[100][];
        while (n < 100) {
            int n2 = n++;
            nArrayArray[n2] = new int[100];
        }
        m = nArrayArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/intellij/ideolog/intentions/FileMatch$Companion;", "", "<init>", "()V", "LIMIT", "", "m", "", "", "getM", "()[[I", "[[I", "intellij.ideolog"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final int[][] getM() {
            return m;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

