/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ideolog.IdeologBundle;
import com.intellij.ideolog.fileType.LogFileType;
import com.intellij.ideolog.foldings.FoldingCalculatorTask;
import com.intellij.ideolog.util.IdeologDocumentContext;
import com.intellij.ideolog.util.IdeologDocumentContextKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B)\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J#\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0010H\u0016R#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ideolog/intentions/HideLinesAboveBelowIntentionBase;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "setter", "Lkotlin/Function2;", "Lcom/intellij/ideolog/util/IdeologDocumentContext;", "", "", "directionText", "", "<init>", "(Lkotlin/jvm/functions/Function2;Ljava/lang/String;)V", "getSetter", "()Lkotlin/jvm/functions/Function2;", "getText", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "startInWriteAction", "intellij.ideolog"})
public abstract class HideLinesAboveBelowIntentionBase
implements IntentionAction {
    @NotNull
    private final Function2<IdeologDocumentContext, Integer, Unit> setter;
    @NotNull
    private final String directionText;

    public HideLinesAboveBelowIntentionBase(@NotNull Function2<? super IdeologDocumentContext, ? super Integer, Unit> setter, @NotNull String directionText) {
        Intrinsics.checkNotNullParameter(setter, (String)"setter");
        Intrinsics.checkNotNullParameter((Object)directionText, (String)"directionText");
        this.setter = setter;
        this.directionText = directionText;
    }

    @NotNull
    public final Function2<IdeologDocumentContext, Integer, Unit> getSetter() {
        return this.setter;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.directionText};
        return IdeologBundle.message("intention.name.hide.lines", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return IdeologBundle.message("intention.family.name.logs", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        PsiFile psiFile = file;
        return Intrinsics.areEqual((Object)(psiFile != null ? psiFile.getFileType() : null), (Object)((Object)LogFileType.INSTANCE));
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.setter.invoke((Object)IdeologDocumentContextKt.getIdeologContext(document), (Object)editor.getCaretModel().getLogicalPosition().line);
        FoldingCalculatorTask.Companion.restartFoldingCalculator(project, editor, file);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

