/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ideolog.IdeologBundle;
import com.intellij.ideolog.fileType.LogFileType;
import com.intellij.ideolog.highlighting.LogFileHighlighterFactoryKt;
import com.intellij.ideolog.highlighting.LogFileMapRenderer;
import com.intellij.ideolog.util.IdeologDocumentContextKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J#\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0013\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ideolog/intentions/LogHighlightValueIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "<init>", "()V", "lastSelection", "", "getText", "getFamilyName", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "startInWriteAction", "intellij.ideolog"})
public final class LogHighlightValueIntention
implements IntentionAction {
    @NotNull
    private String lastSelection = "";

    @NotNull
    public String getText() {
        Object object;
        Object[] objectArray = new Object[1];
        if (this.lastSelection.length() > 25) {
            String string = this.lastSelection.substring(0, 25);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = string + "...";
        } else {
            object = this.lastSelection;
        }
        objectArray[0] = object;
        return IdeologBundle.message("intention.name.highlight", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return IdeologBundle.message("intention.family.name.logs", new Object[0]);
    }

    @Nullable
    public final CharSequence getText(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return IdeologDocumentContextKt.getSelectedText(editor);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile file) {
        boolean enabled;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        PsiFile psiFile = file;
        if (!Intrinsics.areEqual((Object)(psiFile != null ? psiFile.getFileType() : null), (Object)((Object)LogFileType.INSTANCE))) {
            return false;
        }
        CharSequence text = this.getText(editor);
        boolean bl = enabled = text != null;
        if (enabled) {
            this.lastSelection = ((Object)text).toString();
        }
        return enabled;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile file) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            CharSequence charSequence = this.getText(editor);
            if (charSequence == null) {
                return;
            }
            CharSequence selection = charSequence;
            HashSet hashSet = (HashSet)editor.getUserData(LogFileHighlighterFactoryKt.getHighlightingSetUserKey());
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            HashSet set = hashSet;
            set.add(((Object)selection).toString());
            editor.putUserData(LogFileHighlighterFactoryKt.getHighlightingSetUserKey(), (Object)set);
            ((EditorEx)editor).repaint(0, ((EditorEx)editor).getDocument().getTextLength());
            LogFileMapRenderer logFileMapRenderer = LogFileMapRenderer.Companion.getLogFileMapRenderer(editor);
            if (logFileMapRenderer == null) break block2;
            logFileMapRenderer.invalidateHighlighters();
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

