/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.ideolog.IdeologBundle;
import com.intellij.ideolog.fileType.LogFileType;
import com.intellij.ideolog.highlighting.LogEvent;
import com.intellij.ideolog.intentions.FileMatch;
import com.intellij.ideolog.intentions.LogJumpToSourceIntention;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u0011\u001a\u00020\bH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ideolog/intentions/LogJumpToSourceIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "<init>", "()V", "getText", "", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "startInWriteAction", "Companion", "intellij.ideolog"})
public final class LogJumpToSourceIntention
implements IntentionAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return IdeologBundle.message("intention.name.jump.to.source", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return IdeologBundle.message("intention.family.name.logs", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiFile psiFile = file;
        return Intrinsics.areEqual((Object)(psiFile != null ? psiFile.getFileType() : null), (Object)((Object)LogFileType.INSTANCE));
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Companion.doIt(project, editor);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ideolog/intentions/LogJumpToSourceIntention$Companion;", "", "<init>", "()V", "getMatchesFromFiles", "", "Lcom/intellij/ideolog/intentions/FileMatch;", "pfi", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "filesWithLevel", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "evt", "Lcom/intellij/ideolog/highlighting/LogEvent;", "vfs", "", "haveCategory", "", "getFilesToMatch", "project", "Lcom/intellij/openapi/project/Project;", "doIt", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.ideolog"})
    @SourceDebugExtension(value={"SMAP\nLogJumpToSourceIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogJumpToSourceIntention.kt\ncom/intellij/ideolog/intentions/LogJumpToSourceIntention$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,286:1\n1863#2,2:287\n1010#2,2:289\n1863#2,2:291\n774#2:293\n865#2,2:294\n1557#2:296\n1628#2,3:297\n*S KotlinDebug\n*F\n+ 1 LogJumpToSourceIntention.kt\ncom/intellij/ideolog/intentions/LogJumpToSourceIntention$Companion\n*L\n150#1:287,2\n233#1:289,2\n195#1:291,2\n226#1:293\n226#1:294,2\n226#1:296\n226#1:297,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<FileMatch> getMatchesFromFiles(ProjectFileIndex pfi, Set<VirtualFile> filesWithLevel, LogEvent evt, Iterable<? extends VirtualFile> vfs, boolean haveCategory) {
            ArrayList<FileMatch> matches = new ArrayList<FileMatch>();
            Iterable<? extends VirtualFile> $this$forEach$iv = vfs;
            boolean $i$f$forEach = false;
            Iterator<? extends VirtualFile> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                VirtualFile element$iv;
                VirtualFile vf = element$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)vf.getExtension(), (Object)LogFileType.INSTANCE.getDefaultExtension()) || !pfi.isInSourceContent(vf)) continue;
                FileMatch match = new FileMatch(evt);
                match.setVirtualFile(vf);
                if (haveCategory) {
                    match.setCategoryPresent(1);
                }
                if (filesWithLevel.contains(vf)) {
                    match.setLevelPresent(1);
                }
                matches.add(match);
            }
            return matches;
        }

        private final List<FileMatch> getFilesToMatch(Project project, LogEvent evt) {
            ArrayList filtered = new ArrayList();
            ApplicationManager.getApplication().runReadAction(() -> Companion.getFilesToMatch$lambda$5(project, evt, filtered));
            List $this$sortBy$iv = filtered;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        FileMatch it = (FileMatch)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(-it.getPriority());
                        it = (FileMatch)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(-it.getPriority()));
                    }
                });
            }
            return filtered;
        }

        public final void doIt(@NotNull Project project, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            String string = IdeologBundle.message("progress.title.finding.source", new Object[0]);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, editor, string){
                final /* synthetic */ Project $project;
                final /* synthetic */ Editor $editor;
                {
                    this.$project = $project;
                    this.$editor = $editor;
                    super($project, $super_call_param$1, false);
                }

                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    System.out.println((Object)"\n<JumpToSource>");
                    indicator.setText(IdeologBundle.message("progress.text.finding.source", new Object[0]));
                    indicator.setIndeterminate(true);
                    LogEvent event = (LogEvent)ReadAction.compute(() -> doIt.1.run$lambda$0(this.$editor));
                    event.prepareTrigrams();
                    System.out.println(event);
                    if (StringsKt.isBlank((CharSequence)event.getMessage())) {
                        return;
                    }
                    Intrinsics.checkNotNull((Object)event);
                    List sorted = com.intellij.ideolog.intentions.LogJumpToSourceIntention$Companion.access$getFilesToMatch(LogJumpToSourceIntention.Companion, this.$project, event);
                    List bestCandidates = CollectionsKt.toMutableList((Collection)CollectionsKt.take((Iterable)sorted, (int)3));
                    PsiManager psiManager = PsiManager.getInstance((Project)this.$project);
                    Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
                    PsiManager psiManager2 = psiManager;
                    System.out.println((Object)"Best candidates:");
                    Iterable $this$forEach$iv = bestCandidates;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        FileMatch it = (FileMatch)element$iv;
                        boolean bl = false;
                        it.processFileOffset(psiManager2);
                        System.out.println(it);
                    }
                    List $this$sortBy$iv = bestCandidates;
                    boolean $i$f$sortBy = false;
                    if ($this$sortBy$iv.size() > 1) {
                        CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                FileMatch it = (FileMatch)a;
                                boolean bl = false;
                                Comparable comparable = Integer.valueOf(-it.getBestScore());
                                it = (FileMatch)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(-it.getBestScore()));
                            }
                        });
                    }
                    FileMatch fileMatch = (FileMatch)CollectionsKt.firstOrNull((List)bestCandidates);
                    if (fileMatch == null) {
                        return;
                    }
                    FileMatch best = fileMatch;
                    ApplicationManager.getApplication().invokeLater(() -> doIt.1.run$lambda$3(this.$project, best));
                }

                private static final LogEvent run$lambda$0(Editor $editor) {
                    return LogEvent.Companion.fromEditor$default(LogEvent.Companion, $editor, 0, 2, null);
                }

                private static final void run$lambda$3(Project $project, FileMatch $best) {
                    OpenFileDescriptor descriptor = new OpenFileDescriptor($project, $best.getVirtualFile(), $best.getBestLine(), 0);
                    OpenFileDescriptor openFileDescriptor = descriptor.setUseCurrentWindow(true);
                    Intrinsics.checkNotNullExpressionValue((Object)openFileDescriptor, (String)"setUseCurrentWindow(...)");
                    OpenFileDescriptor navigable = openFileDescriptor;
                    if (navigable.canNavigate()) {
                        navigable.navigate(true);
                    }
                }
            });
        }

        private static final boolean getFilesToMatch$lambda$5$lambda$1(HashMap $fileIdMap, LogEvent $evt, VirtualFile it) {
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFileWithId");
            int fileId = ((VirtualFileWithId)it).getId();
            FileMatch structure = (FileMatch)$fileIdMap.get(fileId);
            if (structure == null) {
                structure = new FileMatch($evt);
                Integer n = fileId;
                ((Map)$fileIdMap).put(n, structure);
            }
            FileMatch fileMatch = structure;
            int n = fileMatch.getMessageTrigramCount();
            fileMatch.setMessageTrigramCount(n + 1);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private static final void getFilesToMatch$lambda$5(Project $project, LogEvent $evt, ArrayList $filtered) {
            CacheManager cacheManager = CacheManager.getInstance((Project)$project);
            Intrinsics.checkNotNullExpressionValue((Object)cacheManager, (String)"getInstance(...)");
            CacheManager cacheManager2 = cacheManager;
            HashMap fileIdMap = new HashMap();
            FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
            Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndex");
            FileBasedIndex indexManager = fileBasedIndex;
            indexManager.processFilesContainingAllKeys(TrigramIndex.INDEX_ID, (Collection)$evt.getMessageTrigrams(), GlobalSearchScope.projectScope((Project)$project), null, arg_0 -> Companion.getFilesToMatch$lambda$5$lambda$1(fileIdMap, $evt, arg_0));
            VirtualFile[] virtualFileArray = cacheManager2.getVirtualFilesWithWord($evt.getCategory(), (short)255, GlobalSearchScope.projectScope((Project)$project), false);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getVirtualFilesWithWord(...)");
            Set filesWithCategory = ArraysKt.toMutableSet((Object[])virtualFileArray);
            VirtualFile[] virtualFileArray2 = cacheManager2.getVirtualFilesWithWord($evt.getLevel(), (short)255, GlobalSearchScope.projectScope((Project)$project), false);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getVirtualFilesWithWord(...)");
            Set filesWithLevel = ArraysKt.toMutableSet((Object[])virtualFileArray2);
            ManagingFS managingFS = ManagingFS.getInstance();
            Intrinsics.checkNotNull((Object)managingFS, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.newvfs.persistent.PersistentFS");
            PersistentFS fs = (PersistentFS)managingFS;
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)$project);
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
            ProjectFileIndex pfi = projectFileIndex;
            Set set = fileIdMap.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach2 = false;
            for (Object element$iv22 : $this$forEach$iv) {
                Object[] objectArray;
                Map.Entry entry = (Map.Entry)element$iv22;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)entry);
                Object k = entry.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
                Integer fileId = (Integer)k;
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
                FileMatch match = (FileMatch)v;
                VirtualFile vf = fs.findFileById(fileId.intValue());
                if (vf == null || !pfi.isInSourceContent(vf) || !CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])(objectArray = new String[]{"kt", "java", "cs", "vb", "cpp"})), (Object)vf.getExtension())) continue;
                match.setVirtualFile(vf);
                if (filesWithCategory.contains(vf)) {
                    match.setCategoryPresent(1);
                    filesWithCategory.remove(vf);
                }
                if (filesWithLevel.contains(vf)) {
                    match.setLevelPresent(1);
                }
                $filtered.add(match);
            }
            $filtered.addAll((Collection)Companion.getMatchesFromFiles(pfi, filesWithLevel, $evt, filesWithCategory, true));
            if (StringsKt.isBlank((CharSequence)$evt.getCategory())) {
                void $this$mapTo$iv$iv;
                String it;
                Iterable $this$filterTo$iv$iv;
                void $this$filter$iv;
                Object $i$f$forEach2 = $evt.getMessage();
                Regex regex = new Regex("\\p{P}|\\s");
                int element$iv22 = 0;
                $i$f$forEach2 = regex.split((CharSequence)$i$f$forEach2, element$iv22);
                boolean $i$f$filter = false;
                void element$iv22 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!(it.length() >= 5)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)10);
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    VirtualFile[] virtualFileArray3 = cacheManager2.getVirtualFilesWithWord(it, (short)255, GlobalSearchScope.projectScope((Project)$project), false);
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray3, (String)"getVirtualFilesWithWord(...)");
                    collection.add(ArraysKt.toList((Object[])virtualFileArray3));
                }
                List filesWithMessagePart = CollectionsKt.distinct((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
                $filtered.addAll((Collection)Companion.getMatchesFromFiles(pfi, filesWithLevel, $evt, filesWithMessagePart, false));
            }
        }

        public static final /* synthetic */ List access$getFilesToMatch(Companion $this, Project project, LogEvent evt) {
            return $this.getFilesToMatch(project, evt);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

