/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ideolog.IdeologBundle;
import com.intellij.ideolog.fileType.LogFileType;
import com.intellij.ideolog.highlighting.LogFileHighlighterFactoryKt;
import com.intellij.ideolog.highlighting.LogFileMapRenderer;
import com.intellij.ideolog.highlighting.LogParsingUtils;
import com.intellij.ideolog.lex.LogFileFormat;
import com.intellij.ideolog.lex.LogFileFormatsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J%\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u0011\u001a\u00020\bH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ideolog/intentions/ToggleTimeHighlightingIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "<init>", "()V", "getText", "", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "startInWriteAction", "intellij.ideolog"})
public final class ToggleTimeHighlightingIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        return IdeologBundle.message("intention.name.toggle.time.highlighting", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return IdeologBundle.message("intention.family.name.logs", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        PsiFile psiFile = file;
        if (!Intrinsics.areEqual((Object)(psiFile != null ? psiFile.getFileType() : null), (Object)((Object)LogFileType.INSTANCE))) {
            return false;
        }
        LogFileFormat fileType = LogFileFormatsKt.detectLogFileFormat(editor);
        int columnCount = LogParsingUtils.INSTANCE.getEventColumnCount(editor);
        int currentColumn = LogParsingUtils.INSTANCE.getColumnByOffset(editor);
        return columnCount > 1 && currentColumn == fileType.getTimeFieldIndex() && currentColumn >= 0;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (editor == null) {
                return;
            }
            Boolean bl = (Boolean)editor.getUserData(LogFileHighlighterFactoryKt.getHighlightTimeKey());
            boolean newValue = !(bl != null ? bl : false);
            editor.putUserData(LogFileHighlighterFactoryKt.getHighlightTimeKey(), (Object)newValue);
            ((EditorEx)editor).repaint(0, ((EditorEx)editor).getDocument().getTextLength());
            LogFileMapRenderer logFileMapRenderer = LogFileMapRenderer.Companion.getLogFileMapRenderer(editor);
            if (logFileMapRenderer == null) break block1;
            logFileMapRenderer.setIsRenderingTimeHighlighting(newValue);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

