/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.intentions.base;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ideolog.IdeologBundle;
import com.intellij.ideolog.fileType.LogFileType;
import com.intellij.ideolog.foldings.FoldingCalculatorTask;
import com.intellij.ideolog.util.IdeologDocumentContext;
import com.intellij.ideolog.util.IdeologDocumentContextKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B+\u0012\"\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00070\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J#\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0016R*\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ideolog/intentions/base/HideLinesIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "setAccessor", "Lkotlin/Function1;", "Lcom/intellij/ideolog/util/IdeologDocumentContext;", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "lastSelection", "shortSelection", "getShortSelection", "()Ljava/lang/String;", "getFamilyName", "getText", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "startInWriteAction", "intellij.ideolog"})
public abstract class HideLinesIntention
implements IntentionAction {
    @NotNull
    private final Function1<IdeologDocumentContext, HashSet<String>> setAccessor;
    @NotNull
    private String lastSelection;

    public HideLinesIntention(@NotNull Function1<? super IdeologDocumentContext, ? extends HashSet<String>> setAccessor) {
        Intrinsics.checkNotNullParameter(setAccessor, (String)"setAccessor");
        this.setAccessor = setAccessor;
        this.lastSelection = "";
    }

    @NotNull
    public final String getShortSelection() {
        Object object;
        if (this.lastSelection.length() > 25) {
            String string = this.lastSelection.substring(0, 25);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = string + "...";
        } else {
            object = this.lastSelection;
        }
        return object;
    }

    @NotNull
    public String getFamilyName() {
        return IdeologBundle.message("intention.family.name.logs", new Object[0]);
    }

    @Nullable
    public final CharSequence getText(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return IdeologDocumentContextKt.getSelectedText(editor);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile file) {
        boolean enabled;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        PsiFile psiFile = file;
        if (!Intrinsics.areEqual((Object)(psiFile != null ? psiFile.getFileType() : null), (Object)((Object)LogFileType.INSTANCE))) {
            return false;
        }
        CharSequence text = this.getText(editor);
        boolean bl = enabled = text != null;
        if (enabled) {
            this.lastSelection = ((Object)text).toString();
        }
        return enabled;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        CharSequence charSequence = this.getText(editor);
        if (charSequence == null) {
            return;
        }
        CharSequence selection = charSequence;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        HashSet set = (HashSet)this.setAccessor.invoke((Object)IdeologDocumentContextKt.getIdeologContext(document));
        set.add(((Object)selection).toString());
        FoldingCalculatorTask.Companion.restartFoldingCalculator(project, editor, file);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

