/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.largeFile;

import com.intellij.ideolog.lex.LogFileFormat;
import com.intellij.ideolog.lex.RegexLogParser;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\u001a\"\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u001a\u001e\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"FORMAT_DETECTION_DELAY_MILLIS", "", "getLogFileFormatByFirstMatch", "Lcom/intellij/ideolog/lex/LogFileFormat;", "fileLines", "Lkotlin/sequences/Sequence;", "", "regexMatchers", "", "Lcom/intellij/ideolog/lex/RegexLogParser;", "matchLogFileFormatRegex", "input", "", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nIdeologLargeFileDocumentContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeologLargeFileDocumentContext.kt\ncom/intellij/ideolog/largeFile/IdeologLargeFileDocumentContextKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1317#2,2:47\n1863#3,2:49\n*S KotlinDebug\n*F\n+ 1 IdeologLargeFileDocumentContext.kt\ncom/intellij/ideolog/largeFile/IdeologLargeFileDocumentContextKt\n*L\n13#1:47,2\n24#1:49,2\n*E\n"})
public final class IdeologLargeFileDocumentContextKt {
    private static final long FORMAT_DETECTION_DELAY_MILLIS = 100L;

    @NotNull
    public static final LogFileFormat getLogFileFormatByFirstMatch(@NotNull Sequence<String> fileLines, @NotNull List<RegexLogParser> regexMatchers) {
        Intrinsics.checkNotNullParameter(fileLines, (String)"fileLines");
        Intrinsics.checkNotNullParameter(regexMatchers, (String)"regexMatchers");
        Sequence<String> $this$forEach$iv = fileLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            RegexLogParser matchedRegex = IdeologLargeFileDocumentContextKt.matchLogFileFormatRegex(line, regexMatchers);
            if (matchedRegex == null) continue;
            return new LogFileFormat(matchedRegex);
        }
        return new LogFileFormat(null);
    }

    @Nullable
    public static final RegexLogParser matchLogFileFormatRegex(@NotNull CharSequence input, @NotNull List<RegexLogParser> regexMatchers) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(regexMatchers, (String)"regexMatchers");
        CharSequence charSequence = StringUtil.newBombedCharSequence((CharSequence)input, (long)100L);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
        CharSequence bombedInput = charSequence;
        Iterable $this$forEach$iv = regexMatchers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RegexLogParser regexMatcher = (RegexLogParser)element$iv;
            boolean bl = false;
            try {
                if (!regexMatcher.getRegex().matcher(bombedInput).find()) continue;
                return regexMatcher;
            }
            catch (ProcessCanceledException processCanceledException) {
            }
        }
        return null;
    }
}

