/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.largeFile;

import com.intellij.ideolog.IdeologBundle;
import com.intellij.ideolog.file.LogFileFormatNotificationProviderKt;
import com.intellij.ideolog.highlighting.LogHeavyFilterService;
import com.intellij.ideolog.highlighting.settings.LogHighlightingSettingsStore;
import com.intellij.ideolog.largeFile.fileType.LargeLogFileType;
import com.intellij.ideolog.util.IdeologDocumentContextKt;
import com.intellij.largeFilesEditor.editor.EditorModel;
import com.intellij.largeFilesEditor.editor.LargeFileEditor;
import com.intellij.largeFilesEditor.encoding.LargeFileEditorAccess;
import com.intellij.largeFilesEditor.search.LfeSearchManager;
import com.intellij.largeFilesEditor.search.SearchResult;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0002J\u001d\u0010\n\u001a\u00020\b2\u0012\b\u0001\u0010\u000b\u001a\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0096\u0001J\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u0013\u001a\u00020\u0014H\u0096\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u0096\u0001J\u0013\u0010\u0017\u001a\f0\u0018\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0097\u0001J\u0016\u0010\u0019\u001a\n \u0011*\u0004\u0018\u00010\u001a0\u001aH\u0096\u0001\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\f0\u001d\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0097\u0001J\u0013\u0010\u001e\u001a\f0\u001f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0097\u0001J\u0016\u0010 \u001a\n \u0011*\u0004\u0018\u00010!0!H\u0096\u0001\u00a2\u0006\u0002\u0010\"J\t\u0010#\u001a\u00020\u0016H\u0096\u0001J\u0015\u0010$\u001a\u000e\u0018\u00010\u0018\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b%H\u0097\u0001J\u0016\u0010&\u001a\n \u0011*\u0004\u0018\u00010'0'H\u0096\u0001\u00a2\u0006\u0002\u0010(J\u0016\u0010)\u001a\n \u0011*\u0004\u0018\u00010*0*H\u0096\u0001\u00a2\u0006\u0002\u0010+JN\u0010,\u001a\u000e\u0018\u0001H-\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b%\"\u0010\b\u0000\u0010-*\n \u0011*\u0004\u0018\u00010.0.2 \b\u0001\u0010\u000b\u001a\u001a\u0012\f\u0012\n \u0011*\u0004\u0018\u0001H-H-0/\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0097\u0001\u00a2\u0006\u0002\u00100J\t\u00101\u001a\u000202H\u0096\u0001J\t\u00103\u001a\u000202H\u0096\u0001JX\u00104\u001a\u00020\b\"\u0010\b\u0000\u0010-*\n \u0011*\u0004\u0018\u00010.0.2 \b\u0001\u0010\u000b\u001a\u001a\u0012\f\u0012\n \u0011*\u0004\u0018\u0001H-H-0/\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000e2\u0014\b\u0001\u00105\u001a\u000e\u0018\u0001H-\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b%H\u0096\u0001\u00a2\u0006\u0002\u00106J\u001d\u00107\u001a\u00020\b2\u0012\b\u0001\u0010\u000b\u001a\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0096\u0001J\u001d\u00108\u001a\u00020\b2\u0012\b\u0001\u0010\u000b\u001a\f09\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0096\u0001J\u001e\u0010:\u001a\u00020\b2\u000e\u0010\u000b\u001a\n \u0011*\u0004\u0018\u00010;0;H\u0096\u0001\u00a2\u0006\u0002\u0010<J\u001d\u0010=\u001a\u00020\b2\u0012\b\u0001\u0010\u000b\u001a\f0>\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/ideolog/largeFile/LargeLogFileEditor;", "Lcom/intellij/largeFilesEditor/editor/LargeFileEditor;", "delegate", "<init>", "(Lcom/intellij/largeFilesEditor/editor/LargeFileEditor;)V", "getName", "", "dispose", "", "resetIdeologStoredData", "addPropertyChangeListener", "p0", "Ljava/beans/PropertyChangeListener;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "createAccessForEncodingWidget", "Lcom/intellij/largeFilesEditor/encoding/LargeFileEditorAccess;", "kotlin.jvm.PlatformType", "()Lcom/intellij/largeFilesEditor/encoding/LargeFileEditorAccess;", "getCaretPageNumber", "", "getCaretPageOffset", "", "getComponent", "Ljavax/swing/JComponent;", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "()Lcom/intellij/openapi/editor/Editor;", "getEditorModel", "Lcom/intellij/largeFilesEditor/editor/EditorModel;", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileDataProviderForSearch", "Lcom/intellij/largeFilesEditor/search/searchTask/FileDataProviderForSearch;", "()Lcom/intellij/largeFilesEditor/search/searchTask/FileDataProviderForSearch;", "getPageSize", "getPreferredFocusedComponent", "Lorg/jetbrains/annotations/Nullable;", "getProject", "Lcom/intellij/openapi/project/Project;", "()Lcom/intellij/openapi/project/Project;", "getSearchManager", "Lcom/intellij/largeFilesEditor/search/LfeSearchManager;", "()Lcom/intellij/largeFilesEditor/search/LfeSearchManager;", "getUserData", "T", "", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "isModified", "", "isValid", "putUserData", "p1", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "removePropertyChangeListener", "setState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "showSearchResult", "Lcom/intellij/largeFilesEditor/search/SearchResult;", "(Lcom/intellij/largeFilesEditor/search/SearchResult;)V", "trySetHighlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "intellij.ideolog"})
public final class LargeLogFileEditor
implements LargeFileEditor {
    @NotNull
    private final LargeFileEditor delegate;

    public LargeLogFileEditor(@NotNull LargeFileEditor delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.getEditor().getSettings().setUseSoftWraps(false);
        this.getEditor().putUserData(LargeFileEditor.LARGE_FILE_EDITOR_SOFT_WRAP_KEY, (Object)false);
        LogHighlightingSettingsStore.Companion.getInstance().addSettingsListener((Disposable)this, (Function0<Unit>)((Function0)() -> LargeLogFileEditor._init_$lambda$0(this)));
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        EditorHighlighter editorHighlighter = EditorHighlighterFactory.Companion.getInstance().createEditorHighlighter((FileType)LargeLogFileType.INSTANCE, scheme, this.getProject());
        this.trySetHighlighter(editorHighlighter);
    }

    @NotNull
    public String getName() {
        return IdeologBundle.message("large.log", new Object[0]);
    }

    public void dispose() {
        Document document = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        IdeologDocumentContextKt.getIdeologContext(document).clear();
        Disposer.dispose((Disposable)((Disposable)this.delegate));
    }

    private final void resetIdeologStoredData() {
        this.getEditor().putUserData(LogHeavyFilterService.Companion.getMarkupHighlightedExceptionsKey(), null);
        Document document = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        IdeologDocumentContextKt.getIdeologContext(document).clear();
        VirtualFile virtualFile = this.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        LogFileFormatNotificationProviderKt.update(virtualFile, project);
    }

    public LfeSearchManager getSearchManager() {
        return this.delegate.getSearchManager();
    }

    public void showSearchResult(SearchResult p0) {
        this.delegate.showSearchResult(p0);
    }

    public Project getProject() {
        return this.delegate.getProject();
    }

    public long getCaretPageNumber() {
        return this.delegate.getCaretPageNumber();
    }

    public int getCaretPageOffset() {
        return this.delegate.getCaretPageOffset();
    }

    public Editor getEditor() {
        return this.delegate.getEditor();
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.delegate.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        return virtualFile;
    }

    public LargeFileEditorAccess createAccessForEncodingWidget() {
        return this.delegate.createAccessForEncodingWidget();
    }

    public FileDataProviderForSearch getFileDataProviderForSearch() {
        return this.delegate.getFileDataProviderForSearch();
    }

    @NotNull
    public EditorModel getEditorModel() {
        EditorModel editorModel = this.delegate.getEditorModel();
        Intrinsics.checkNotNullExpressionValue((Object)editorModel, (String)"getEditorModel(...)");
        return editorModel;
    }

    public int getPageSize() {
        return this.delegate.getPageSize();
    }

    public void trySetHighlighter(@NotNull EditorHighlighter p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        this.delegate.trySetHighlighter(p0);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.delegate.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.delegate.getPreferredFocusedComponent();
    }

    public void setState(@NotNull FileEditorState p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        this.delegate.setState(p0);
    }

    public boolean isModified() {
        return this.delegate.isModified();
    }

    public boolean isValid() {
        return this.delegate.isValid();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        this.delegate.addPropertyChangeListener(p0);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        this.delegate.removePropertyChangeListener(p0);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> p0) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        return (T)this.delegate.getUserData(p0);
    }

    public <T> void putUserData(@NotNull Key<T> p0, @Nullable T p1) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        this.delegate.putUserData(p0, p1);
    }

    private static final Unit _init_$lambda$0(LargeLogFileEditor this$0) {
        this$0.resetIdeologStoredData();
        return Unit.INSTANCE;
    }
}

