/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.lex;

import com.intellij.ideolog.highlighting.settings.LogParsingPattern;
import com.intellij.ideolog.lex.LogFileLexer;
import com.intellij.ideolog.lex.LogToken;
import com.intellij.ideolog.lex.RegexLogParser;
import java.text.ParseException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0014\u001a\u00020\tJ\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017J\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017J\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017J\u0014\u0010\u001a\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017J\u0010\u0010\u001b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0015\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u000b\u00a2\u0006\u0002\u0010!R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"Lcom/intellij/ideolog/lex/LogFileFormat;", "", "myRegexLogParser", "Lcom/intellij/ideolog/lex/RegexLogParser;", "<init>", "(Lcom/intellij/ideolog/lex/RegexLogParser;)V", "getMyRegexLogParser", "()Lcom/intellij/ideolog/lex/RegexLogParser;", "isLineEventStart", "", "line", "", "getTimeFieldIndex", "", "tokenize", "", "event", "output", "", "Lcom/intellij/ideolog/lex/LogToken;", "onlyValues", "extractDate", "tokens", "", "extractSeverity", "extractCategory", "extractMessage", "validateFormatUUID", "uuid", "Ljava/util/UUID;", "parseLogEventTimeSeconds", "", "time", "(Ljava/lang/CharSequence;)Ljava/lang/Long;", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nLogFileFormats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogFileFormats.kt\ncom/intellij/ideolog/lex/LogFileFormat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n461#2,6:85\n*S KotlinDebug\n*F\n+ 1 LogFileFormats.kt\ncom/intellij/ideolog/lex/LogFileFormat\n*L\n58#1:85,6\n*E\n"})
public final class LogFileFormat {
    @Nullable
    private final RegexLogParser myRegexLogParser;

    public LogFileFormat(@Nullable RegexLogParser myRegexLogParser) {
        this.myRegexLogParser = myRegexLogParser;
    }

    @Nullable
    public final RegexLogParser getMyRegexLogParser() {
        return this.myRegexLogParser;
    }

    public final boolean isLineEventStart(@NotNull CharSequence line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Object object = this.myRegexLogParser;
        return object != null && (object = ((RegexLogParser)object).getLineRegex()) != null && (object = ((Pattern)object).matcher(line)) != null ? ((Matcher)object).find() : line.length() > 0 && !CharsKt.isWhitespace((char)line.charAt(0));
    }

    public final int getTimeFieldIndex() {
        Object object = this.myRegexLogParser;
        return object != null && (object = ((RegexLogParser)object).getOtherParsingSettings()) != null ? ((LogParsingPattern)object).getTimeColumnId() : 0;
    }

    public final void tokenize(@NotNull CharSequence event, @NotNull List<LogToken> output, boolean onlyValues) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(output, (String)"output");
        if (this.myRegexLogParser == null) {
            LogFileLexer.Companion.lexPlainLog(event, output, onlyValues);
        } else {
            LogFileLexer.Companion.lexRegex(event, output, onlyValues, this.myRegexLogParser);
        }
    }

    public static /* synthetic */ void tokenize$default(LogFileFormat logFileFormat, CharSequence charSequence, List list, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        logFileFormat.tokenize(charSequence, list, bl);
    }

    @Nullable
    public final LogToken extractDate(@NotNull List<LogToken> tokens) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Object object = this.myRegexLogParser;
        if (object == null || (object = ((RegexLogParser)object).getOtherParsingSettings()) == null) {
            return null;
        }
        int idx = ((LogParsingPattern)object).getTimeColumnId();
        if (tokens.size() > idx) {
            return (LogToken)SequencesKt.elementAtOrNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)tokens), LogFileFormat::extractDate$lambda$0), (int)idx);
        }
        return null;
    }

    @Nullable
    public final LogToken extractSeverity(@NotNull List<LogToken> tokens) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Object object = this.myRegexLogParser;
        if (object == null || (object = ((RegexLogParser)object).getOtherParsingSettings()) == null) {
            return null;
        }
        int idx = ((LogParsingPattern)object).getSeverityColumnId();
        if (tokens.size() > idx) {
            return (LogToken)SequencesKt.elementAtOrNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)tokens), LogFileFormat::extractSeverity$lambda$1), (int)idx);
        }
        return null;
    }

    @Nullable
    public final LogToken extractCategory(@NotNull List<LogToken> tokens) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Object object = this.myRegexLogParser;
        if (object == null || (object = ((RegexLogParser)object).getOtherParsingSettings()) == null) {
            return null;
        }
        int idx = ((LogParsingPattern)object).getCategoryColumnId();
        if (tokens.size() > idx) {
            return (LogToken)SequencesKt.elementAtOrNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)tokens), LogFileFormat::extractCategory$lambda$2), (int)idx);
        }
        return null;
    }

    @NotNull
    public final LogToken extractMessage(@NotNull List<LogToken> tokens) {
        LogToken element$iv;
        block1: {
            Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
            List<LogToken> $this$last$iv = tokens;
            boolean $i$f$last = false;
            ListIterator<LogToken> iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
            while (iterator$iv.hasPrevious()) {
                LogToken it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(!it.isSeparator())) continue;
                break block1;
            }
            throw new NoSuchElementException("List contains no element matching the predicate.");
        }
        return element$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean validateFormatUUID(@Nullable UUID uuid) {
        if (uuid == null) return true;
        RegexLogParser regexLogParser = this.myRegexLogParser;
        if (!Intrinsics.areEqual((Object)(regexLogParser != null ? regexLogParser.getUuid() : null), (Object)uuid)) return false;
        return true;
    }

    @Nullable
    public final Long parseLogEventTimeSeconds(@NotNull CharSequence time) {
        Long l;
        block6: {
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            RegexLogParser regexLogParser = this.myRegexLogParser;
            if (regexLogParser != null) {
                RegexLogParser it = regexLogParser;
                boolean bl = false;
                try {
                    l = it.getTimeFormat().parse(((Object)time).toString()).getTime();
                    break block6;
                }
                catch (ParseException parseException) {
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                l = null;
            } else {
                l = null;
            }
        }
        return l;
    }

    private static final boolean extractDate$lambda$0(LogToken it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isSeparator();
    }

    private static final boolean extractSeverity$lambda$1(LogToken it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isSeparator();
    }

    private static final boolean extractCategory$lambda$2(LogToken it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isSeparator();
    }
}

