/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.lex;

import com.intellij.ideolog.highlighting.LogFileHighlighterFactoryKt;
import com.intellij.ideolog.highlighting.LogTokenElementType;
import com.intellij.ideolog.lex.LogFileFormat;
import com.intellij.ideolog.lex.LogToken;
import com.intellij.ideolog.lex.RegexLogParser;
import com.intellij.lexer.LexerBase;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u0000 &2\u00020\u0001:\u0001&B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010 \u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u0012H\u0016J\b\u0010\"\u001a\u00020\u0019H\u0016J\b\u0010#\u001a\u00020\u0004H\u0002J\b\u0010$\u001a\u00020\u0010H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/ideolog/lex/LogFileLexer;", "Lcom/intellij/lexer/LexerBase;", "tokenCache", "", "Lcom/intellij/psi/tree/IElementType;", "findEventStart", "", "fileType", "Lcom/intellij/ideolog/lex/LogFileFormat;", "<init>", "(Ljava/util/List;ZLcom/intellij/ideolog/lex/LogFileFormat;)V", "getFileType", "()Lcom/intellij/ideolog/lex/LogFileFormat;", "setFileType", "(Lcom/intellij/ideolog/lex/LogFileFormat;)V", "myBuffer", "", "myBufferEnd", "", "myBufferStart", "myColumn", "currentTokenStart", "currentTokenEnd", "currentTokenType", "start", "", "buffer", "startOffset", "endOffset", "initialState", "getState", "getTokenType", "getTokenStart", "getTokenEnd", "advance", "getOrMakeElementToken", "getBufferSequence", "getBufferEnd", "Companion", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nLogFileLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogFileLexer.kt\ncom/intellij/ideolog/lex/LogFileLexer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class LogFileLexer
extends LexerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<IElementType> tokenCache;
    private boolean findEventStart;
    @NotNull
    private LogFileFormat fileType;
    @NotNull
    private CharSequence myBuffer;
    private int myBufferEnd;
    private int myBufferStart;
    private int myColumn;
    private int currentTokenStart;
    private int currentTokenEnd;
    @Nullable
    private IElementType currentTokenType;

    public LogFileLexer(@NotNull List<IElementType> tokenCache, boolean findEventStart, @NotNull LogFileFormat fileType) {
        Intrinsics.checkNotNullParameter(tokenCache, (String)"tokenCache");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        this.tokenCache = tokenCache;
        this.findEventStart = findEventStart;
        this.fileType = fileType;
        this.myBuffer = "";
        this.myBufferEnd = -1;
        this.myBufferStart = -1;
        this.currentTokenStart = -1;
        this.currentTokenEnd = -1;
    }

    @NotNull
    public final LogFileFormat getFileType() {
        return this.fileType;
    }

    public final void setFileType(@NotNull LogFileFormat logFileFormat) {
        Intrinsics.checkNotNullParameter((Object)logFileFormat, (String)"<set-?>");
        this.fileType = logFileFormat;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.myBuffer = buffer;
        this.myBufferStart = startOffset;
        this.myBufferEnd = endOffset;
        this.myColumn = initialState;
        this.currentTokenEnd = -1;
        this.currentTokenStart = -1;
        this.currentTokenType = null;
        this.advance();
    }

    public int getState() {
        return this.myColumn;
    }

    @Nullable
    public IElementType getTokenType() {
        return this.currentTokenType;
    }

    public int getTokenStart() {
        return this.currentTokenStart;
    }

    public int getTokenEnd() {
        return this.currentTokenEnd;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void advance() {
        int newTokenStart = this.currentTokenEnd < 0 ? this.myBufferStart : this.currentTokenEnd;
        this.currentTokenType = null;
        int newTokenPosition = newTokenStart;
        if (newTokenPosition >= this.myBufferEnd) {
            return;
        }
        boolean seenNewLine = false;
        while (newTokenPosition < this.myBufferEnd && (seenNewLine || this.myBuffer.charAt(newTokenPosition) != '|')) {
            if (this.myBuffer.charAt(newTokenPosition) == '\n') {
                seenNewLine = true;
                if (!this.findEventStart || this.fileType.isLineEventStart(this.myBuffer.subSequence(newTokenPosition + 1, this.myBufferEnd))) break;
            }
            ++newTokenPosition;
        }
        if (newTokenPosition == newTokenStart) {
            ++newTokenPosition;
        }
        this.currentTokenStart = newTokenStart;
        this.currentTokenEnd = newTokenPosition;
        if (newTokenStart == newTokenPosition - 1) {
            char it = this.myBuffer.charAt(newTokenStart);
            boolean bl = false;
            boolean bl2 = it == '|' || it == '\n';
            if (bl2) {
                this.currentTokenType = LogFileHighlighterFactoryKt.getLOG_TOKEN_SEPARATOR();
                if (this.myBuffer.charAt(newTokenStart) == '\n') {
                    this.myColumn = 0;
                    return;
                }
                int n = this.myColumn;
                this.myColumn = n + 1;
                return;
            }
        }
        this.currentTokenType = this.getOrMakeElementToken();
    }

    private final IElementType getOrMakeElementToken() {
        while (this.myColumn >= this.tokenCache.size()) {
            this.tokenCache.add(new LogTokenElementType(this.tokenCache.size()));
        }
        return this.tokenCache.get(this.myColumn);
    }

    @NotNull
    public CharSequence getBufferSequence() {
        return this.myBuffer;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ$\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ideolog/lex/LogFileLexer$Companion;", "", "<init>", "()V", "lexRegex", "", "event", "", "output", "", "Lcom/intellij/ideolog/lex/LogToken;", "onlyValues", "", "parser", "Lcom/intellij/ideolog/lex/RegexLogParser;", "lexPlainLog", "intellij.ideolog"})
    public static final class Companion {
        private Companion() {
        }

        public final void lexRegex(@NotNull CharSequence event, @NotNull List<LogToken> output, boolean onlyValues, @NotNull RegexLogParser parser) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            boolean eventIsMultiline = StringsKt.contains$default((CharSequence)event, (char)'\n', (boolean)false, (int)2, null);
            CharSequence dataToMatch = parser.getOtherParsingSettings().getRegexMatchFullEvent() || !eventIsMultiline ? event : event.subSequence(0, StringsKt.indexOf$default((CharSequence)event, (char)'\n', (int)0, (boolean)false, (int)6, null));
            Matcher matcher = parser.getRegex().matcher(dataToMatch);
            if (!matcher.find() || matcher.groupCount() == 0) {
                output.add(new LogToken(0, event.length(), false));
                return;
            }
            int lastGroupEnd = 0;
            int i = 1;
            int n = matcher.groupCount();
            if (i <= n) {
                while (true) {
                    int end;
                    int start;
                    if ((start = matcher.start(i)) >= lastGroupEnd && (end = matcher.end(i)) >= 0) {
                        if (start > lastGroupEnd && !onlyValues) {
                            output.add(new LogToken(lastGroupEnd, start, true));
                        }
                        output.add(new LogToken(start, end, false));
                        lastGroupEnd = end;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            if (eventIsMultiline && !parser.getOtherParsingSettings().getRegexMatchFullEvent()) {
                LogToken lastToken = output.remove(CollectionsKt.getLastIndex(output));
                output.add(new LogToken(lastToken.getStartOffset(), event.length(), false));
            } else if (lastGroupEnd < matcher.end() && !onlyValues) {
                output.add(new LogToken(lastGroupEnd, matcher.end(), true));
            }
        }

        public final void lexPlainLog(@NotNull CharSequence event, @NotNull List<LogToken> output, boolean onlyValues) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(output, (String)"output");
            int firstSpace = StringsKt.indexOf$default((CharSequence)event, (char)' ', (int)0, (boolean)false, (int)6, null);
            if (firstSpace <= 0) {
                output.add(new LogToken(0, event.length(), false));
                return;
            }
            output.add(new LogToken(0, firstSpace, false));
            if (!onlyValues) {
                output.add(new LogToken(firstSpace, firstSpace + 1, true));
            }
            output.add(new LogToken(firstSpace + 1, event.length(), false));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

