/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.statistics;

import com.intellij.ideolog.highlighting.settings.LogParsingPattern;
import com.intellij.ideolog.lex.LogFileFormat;
import com.intellij.ideolog.lex.RegexLogParser;
import com.intellij.ideolog.statistics.AllowedLogFileFormat;
import com.intellij.ideolog.statistics.LogFileFormatValues;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\b\u0010\u0013\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ideolog/statistics/IdeologUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "LOG_FILE_FORMAT_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "LOG_FILE_OPENED_IN_TERMINAL", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "DETECTED_LOG_FILE_FORMAT", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "logOpenLogFileInTerminal", "", "project", "Lcom/intellij/openapi/project/Project;", "logDetectedLogFormat", "logFileFormat", "Lcom/intellij/ideolog/lex/LogFileFormat;", "getGroup", "intellij.ideolog"})
public final class IdeologUsagesCollector
extends CounterUsagesCollector {
    @NotNull
    public static final IdeologUsagesCollector INSTANCE = new IdeologUsagesCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("ideolog", 1, null, 4, null);
    @NotNull
    private static final StringEventField LOG_FILE_FORMAT_FIELD = EventFields.String((String)"log_file_format", LogFileFormatValues.INSTANCE.getAllowedValues());
    @NotNull
    private static final EventId LOG_FILE_OPENED_IN_TERMINAL = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"log.file.in.terminal.opened", null, (int)2, null);
    @NotNull
    private static final VarargEventId DETECTED_LOG_FILE_FORMAT;

    private IdeologUsagesCollector() {
    }

    public final void logOpenLogFileInTerminal(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LOG_FILE_OPENED_IN_TERMINAL.log(project);
    }

    public final void logDetectedLogFormat(@Nullable LogFileFormat logFileFormat) {
        AllowedLogFileFormat allowedLogFileFormat;
        String logFileFormatName;
        Object object = logFileFormat;
        String string = object != null && (object = ((LogFileFormat)object).getMyRegexLogParser()) != null && (object = ((RegexLogParser)object).getOtherParsingSettings()) != null ? ((LogParsingPattern)object).getName() : (logFileFormatName = null);
        if (logFileFormatName == null) {
            allowedLogFileFormat = AllowedLogFileFormat.UNDETECTED;
        } else if (LogFileFormatValues.INSTANCE.getPhpValues().contains(logFileFormatName)) {
            String string2 = logFileFormatName;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            allowedLogFileFormat = AllowedLogFileFormat.valueOf(string3);
        } else {
            allowedLogFileFormat = AllowedLogFileFormat.CUSTOM;
        }
        AllowedLogFileFormat logFileFormatAllowedValue = allowedLogFileFormat;
        EventPair[] eventPairArray = new EventPair[]{LOG_FILE_FORMAT_FIELD.with((Object)logFileFormatAllowedValue.getValue())};
        DETECTED_LOG_FILE_FORMAT.log(eventPairArray);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    static {
        EventField[] eventFieldArray = new EventField[]{LOG_FILE_FORMAT_FIELD};
        DETECTED_LOG_FILE_FORMAT = GROUP.registerVarargEvent("log.file.format.detected", eventFieldArray);
    }
}

