/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.terminal;

import com.intellij.ideolog.largeFile.IdeologLargeFileDocumentContextKt;
import com.intellij.ideolog.lex.LogFileFormat;
import com.intellij.ideolog.lex.RegexLogParser;
import com.intellij.ideolog.terminal.highlighting.TerminalCommandBlockHighlighterKt;
import com.intellij.ideolog.util.IdeologDocumentContext;
import com.intellij.openapi.editor.Document;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\bH\u0016J$\u0010\u0012\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lcom/intellij/ideolog/terminal/IdeologTerminalDocumentContext;", "Lcom/intellij/ideolog/util/IdeologDocumentContext;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/editor/Document;)V", "formatByOffsetMap", "Ljava/util/HashMap;", "", "Lcom/intellij/ideolog/lex/LogFileFormat;", "Lkotlin/collections/HashMap;", "numberFirstLines", "getNumberFirstLines", "()I", "clear", "", "detectLogFileFormat", "startOffset", "getLogFileFormat", "fileLines", "Lkotlin/sequences/Sequence;", "", "regexMatchers", "", "Lcom/intellij/ideolog/lex/RegexLogParser;", "isLineEventStart", "", "atLine", "isLogFileReadCommand", "line", "", "Companion", "intellij.ideolog.terminal"})
@SourceDebugExtension(value={"SMAP\nIdeologTerminalDocumentContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeologTerminalDocumentContext.kt\ncom/intellij/ideolog/terminal/IdeologTerminalDocumentContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1755#2,3:53\n*S KotlinDebug\n*F\n+ 1 IdeologTerminalDocumentContext.kt\ncom/intellij/ideolog/terminal/IdeologTerminalDocumentContext\n*L\n49#1:53,3\n*E\n"})
public final class IdeologTerminalDocumentContext
extends IdeologDocumentContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<Integer, LogFileFormat> formatByOffsetMap;
    public static final int NUMBER_FIRST_LINES = 100;

    public IdeologTerminalDocumentContext(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        super(document, null);
        this.formatByOffsetMap = new HashMap();
    }

    @Override
    public int getNumberFirstLines() {
        return 100;
    }

    @Override
    public void clear() {
        super.clear();
        this.formatByOffsetMap.clear();
    }

    @Override
    @NotNull
    public LogFileFormat detectLogFileFormat(int startOffset) {
        LogFileFormat logFileFormat;
        LogFileFormat currentFormat = this.formatByOffsetMap.get(startOffset);
        if (currentFormat != null) {
            return currentFormat;
        }
        LogFileFormat it = logFileFormat = super.detectLogFileFormat(startOffset);
        boolean bl = false;
        Integer n = startOffset;
        ((Map)this.formatByOffsetMap).put(n, it);
        return logFileFormat;
    }

    @Override
    @NotNull
    public LogFileFormat getLogFileFormat(@NotNull Sequence<String> fileLines, @NotNull List<RegexLogParser> regexMatchers) {
        Intrinsics.checkNotNullParameter(fileLines, (String)"fileLines");
        Intrinsics.checkNotNullParameter(regexMatchers, (String)"regexMatchers");
        return IdeologLargeFileDocumentContextKt.getLogFileFormatByFirstMatch(fileLines, regexMatchers);
    }

    @Override
    public boolean isLineEventStart(int atLine) {
        LogFileFormat logFileFormat;
        CharSequence line = this.lineCharSequence(atLine);
        if (this.isLogFileReadCommand(line)) {
            return true;
        }
        int lineStartOffset = this.getDocument().getLineStartOffset(atLine);
        LogFileFormat it = logFileFormat = this.detectLogFileFormat(lineStartOffset);
        boolean bl = false;
        Integer n = lineStartOffset;
        ((Map)this.formatByOffsetMap).put(n, it);
        LogFileFormat format = logFileFormat;
        if (format.getMyRegexLogParser() == null && line.length() > 0) {
            return false;
        }
        return format.isLineEventStart(this.lineCharSequence(atLine));
    }

    private final boolean isLogFileReadCommand(CharSequence line) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = TerminalCommandBlockHighlighterKt.getFileReadCommands();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String baseCommand = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((CharSequence)line, (CharSequence)baseCommand, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl && StringsKt.endsWith((CharSequence)line, (CharSequence)".log", (boolean)true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ideolog/terminal/IdeologTerminalDocumentContext$Companion;", "", "<init>", "()V", "NUMBER_FIRST_LINES", "", "intellij.ideolog.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

