/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.terminal.highlighting;

import com.intellij.ideolog.highlighting.LogHighlightingIterator;
import com.intellij.ideolog.highlighting.settings.LogHighlightingPattern;
import com.intellij.ideolog.lex.LogFileFormat;
import com.intellij.ideolog.lex.LogFileFormatsKt;
import com.intellij.ideolog.terminal.highlighting.TerminalCommandBlockHighlighter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BA\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0006H\u0014J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0006H\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ideolog/terminal/highlighting/TerminalLogHighlightingIterator;", "Lcom/intellij/ideolog/highlighting/LogHighlightingIterator;", "highlightingInfos", "Ljava/util/TreeSet;", "Lcom/intellij/ideolog/terminal/highlighting/TerminalCommandBlockHighlighter$HighlightingInfo;", "startOffset", "", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "textGetter", "Lkotlin/Function0;", "", "colorGetter", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Ljava/util/TreeSet;ILcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "detectLogFileFormatByOffset", "Lcom/intellij/ideolog/lex/LogFileFormat;", "editor", "offset", "tryHighlightStacktrace", "", "event", "eventOffset", "acceptHighlighter", "", "logHighlightingPattern", "Lcom/intellij/ideolog/highlighting/settings/LogHighlightingPattern;", "fileFormat", "captureGroup", "intellij.ideolog.terminal"})
public final class TerminalLogHighlightingIterator
extends LogHighlightingIterator {
    @NotNull
    private final TreeSet<TerminalCommandBlockHighlighter.HighlightingInfo> highlightingInfos;

    public TerminalLogHighlightingIterator(@NotNull TreeSet<TerminalCommandBlockHighlighter.HighlightingInfo> highlightingInfos, int startOffset, @NotNull Editor myEditor, @NotNull Function0<? extends CharSequence> textGetter, @NotNull Function0<? extends EditorColorsScheme> colorGetter) {
        Intrinsics.checkNotNullParameter(highlightingInfos, (String)"highlightingInfos");
        Intrinsics.checkNotNullParameter((Object)myEditor, (String)"myEditor");
        Intrinsics.checkNotNullParameter(textGetter, (String)"textGetter");
        Intrinsics.checkNotNullParameter(colorGetter, (String)"colorGetter");
        super(startOffset, myEditor, textGetter, colorGetter);
        this.highlightingInfos = highlightingInfos;
    }

    @Override
    @NotNull
    public LogFileFormat detectLogFileFormatByOffset(@NotNull Editor editor, int offset) {
        TerminalCommandBlockHighlighter.HighlightingInfo lowerBoundInfo;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TerminalCommandBlockHighlighter.HighlightingInfo dummyOutputInfo = new TerminalCommandBlockHighlighter.HighlightingInfo(offset, false, 2, null);
        TreeSet<TerminalCommandBlockHighlighter.HighlightingInfo> treeSet = this.highlightingInfos;
        TerminalCommandBlockHighlighter.HighlightingInfo highlightingInfo = lowerBoundInfo = treeSet != null ? treeSet.floor(dummyOutputInfo) : null;
        int realOffset = highlightingInfo != null ? highlightingInfo.getCommandStartOffset() : offset;
        return LogFileFormatsKt.detectLogFileFormat(editor, realOffset);
    }

    @Override
    protected void tryHighlightStacktrace(@NotNull CharSequence event, int eventOffset) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    protected boolean acceptHighlighter(@NotNull LogHighlightingPattern logHighlightingPattern, @NotNull LogFileFormat fileFormat, int captureGroup) {
        Intrinsics.checkNotNullParameter((Object)logHighlightingPattern, (String)"logHighlightingPattern");
        Intrinsics.checkNotNullParameter((Object)fileFormat, (String)"fileFormat");
        return fileFormat.getMyRegexLogParser() != null && super.acceptHighlighter(logHighlightingPattern, fileFormat, captureGroup);
    }
}

