// Copyright 2000-2022 JetBrains s.r.o. and contributors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.codeInsight.controlFlow;

import com.jetbrains.php.codeInsight.controlFlow.instructions.*;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class PhpInstructionProcessor {

  private boolean myHaltTraversal;

  public boolean processInstruction(PhpInstruction instruction){
    return true;
  }

  public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction){
    return processInstruction(instruction);
  }

  public boolean processAccessConstantInstruction(PhpAccessConstantInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction){
    return processInstruction(instruction);
  }

  public boolean processExitPointInstruction(PhpExitPointInstruction instruction){
    return processInstruction(instruction);
  }

  public boolean processStatementInstruction(PhpStatementInstruction instruction){
    return processInstruction(instruction);
  }

  public boolean processReturnInstruction(PhpReturnInstruction instruction){
    return processInstruction(instruction);
  }

  public boolean processConditionInstruction(PhpConditionInstruction instruction){
    return processInstruction(instruction);
  }

  public boolean processIncludeInstruction(PhpIncludeInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processBreakContinueInstruction(PhpBreakContinueInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processThrowInstruction(PhpThrowInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processCatchConditionInstruction(PhpCatchConditionInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processInterruptScriptInstruction(PhpInterruptScriptInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processClassDeclarationInstruction(PhpClassDeclarationInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processFunctionDeclarationInstruction(PhpFunctionDeclarationInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processConstantDeclarationInstruction(PhpConstantDeclarationInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processVariableDocDeclarationInstruction(PhpVariableDocDeclarationInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processAccessFieldInObjectContextInstruction(PhpAccessFieldInObjectContextInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processCaseConditionInstruction(PhpCaseConditionInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processConstructorCallInstruction(final PhpConstructorCallInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processYieldInstruction(PhpYieldInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processFinallyEndInstruction(PhpFinallyEndInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processHostInstruction(PhpHostInstruction instruction) {
    return processInstruction(instruction);
  }

  public boolean processGotoLabelDefinitionInstruction(PhpGotoLabelDefinitionInstruction instruction) {
    return processInstruction(instruction);
  }

  public void handleSelfInstructionRecurringProcess(@NotNull PhpInstruction originalInstruction, @NotNull PhpInstruction instruction) {}

  /**
   * Use only in global mode
   */
  public boolean stopTraverseOnThrowInterruptingInstruction() {
    return false;
  }

  @ApiStatus.Internal
  public boolean shouldSkipAmbiguousPredecessors() {
    return false;
  }

  @ApiStatus.Internal
  protected void haltTraversal() {
    myHaltTraversal = true;
  }

  @ApiStatus.Internal
  boolean shouldHaltTraversal() {
    return myHaltTraversal;
  }
}
