// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.completion;

public class ClassUsageContext {

  private boolean inInstanceof = false;
  private boolean inExtends = false;
  private boolean inImplements = false;
  private boolean inNew = false;
  private boolean inClassUse = false;
  private boolean isStatic = false;
  private boolean inParameterType = false;
  private boolean inFieldType = false;
  private boolean inReturnType = false;
  private boolean inAttribute = false;
  public static final ClassUsageContext STATIC = new ClassUsageContext(true);

  public ClassUsageContext(boolean isStatic) {
    this.isStatic = isStatic;
  }

  public boolean isInInstanceof() {
    return inInstanceof;
  }

  public void setInInstanceof(boolean inInstanceof) {
    this.inInstanceof = inInstanceof;
  }

  public boolean isInExtends() {
    return inExtends;
  }

  public void setInExtends(boolean inExtends) {
    this.inExtends = inExtends;
  }

  public boolean isInImplements() {
    return inImplements;
  }

  public void setInImplements(boolean inImplements) {
    this.inImplements = inImplements;
  }

  public boolean isInNew() {
    return inNew;
  }

  public void setInNew(boolean inNew) {
    this.inNew = inNew;
  }

  public boolean isInClassUse() {
    return inClassUse;
  }

  public void setInClassUse(boolean inClassUse) {
    this.inClassUse = inClassUse;
  }

  public boolean isStatic() {
    return isStatic;
  }

  public boolean isInTypeDeclaration() {
    return inFieldType || inReturnType || inParameterType;
  }

  public boolean isInParameterType() {
    return inParameterType;
  }

  public void setInParameterType(boolean inParameterType) {
    this.inParameterType = inParameterType;
  }

  public boolean isInFieldType() {
    return inFieldType;
  }

  public void setInFieldType(boolean inFieldType) {
    this.inFieldType = inFieldType;
  }

  public boolean isInReturnType() {
    return inReturnType;
  }

  public void setInReturnType(boolean inReturnType) {
    this.inReturnType = inReturnType;
  }

  public boolean isGeneric() {
    return !isStatic() && !isInExtends() && !isInImplements() && !isInInstanceof() && !isInNew() && !isInClassUse() && !isInTypeDeclaration() && !isInAttribute();
  }

  public boolean isInAttribute() {
    return inAttribute;
  }

  public void setInAttribute(boolean inAttribute) {
    this.inAttribute = inAttribute;
  }
}
