// Copyright 2000-2022 JetBrains s.r.o. and contributors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.documentation.phpdoc.psi;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.stubs.PhpDocCommentStub;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.*;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public interface PhpDocComment extends PsiDocCommentBase, PhpDocPsiElement, StubBasedPsiElement<PhpDocCommentStub> {
  Condition<PsiElement> INSTANCEOF = use -> use instanceof PhpDocComment;

  @Nullable
  PhpDocParamTag getVarTag();

  @Nullable
  PhpDocReturnTag getReturnTag();

  @NotNull
  List<PhpDocParamTag> getParamTags();

  @NotNull
  List<PhpDocPropertyTag> getPropertyTags();

  PhpDocLinkTag @Nullable [] getLinkTags();

  PhpDocMethod @NotNull [] getMethods();

  PhpDocTag @NotNull [] getTagElementsByName(String tagName);
  
  PhpType[] getExceptionClasses();

  @Nullable
  PhpDocParamTag getParamTagByName(String name);

  boolean hasInheritDocTag();
}
