// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.documentation.phpdoc.psi.tags;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.stubs.PhpDocTagStub;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import org.jetbrains.annotations.NotNull;

public interface PhpDocTag extends PhpDocPsiElement, PhpTypedElement, StubBasedPsiElement<PhpDocTagStub> {

  Condition<PsiElement> INSTANCEOF = use -> use instanceof PhpDocTag;
  
  PhpDocTag[] EMPTY_ARRAY = new PhpDocTag[0];

  @NotNull
  @NlsSafe String getTagValue();
  @Override
  @NotNull
  String getName();
  @NotNull
  CharSequence getNameCS();
}
