// Copyright 2000-2021 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.inspections.reference;

import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public abstract class PhpEntryPointsManager extends EntryPointsManager {
  @NotNull
  public static PhpEntryPointsManager getProjectInstance(@NotNull Project project) {
    return project.getService(PhpEntryPointsManager.class);
  }

  public abstract boolean isAcceptedByPattern(@NotNull PsiElement element);

  public abstract void addEntryPointsForInitializers(@NotNull RefElement refElement, boolean isPersistent);
}
