// Copyright 2000-2022 JetBrains s.r.o. and contributors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import org.jetbrains.annotations.NotNull;

/**
 * Provides ability to defined custom noreturn function calls
 *
 * Such calls will be considered as always halting program execution during control flow analysis, so inspection won't traverse code further upon reaching such function call
 */
public interface PhpNoReturnProvider {
  ExtensionPointName<PhpNoReturnProvider> EP_NAME = ExtensionPointName.create("com.jetbrains.php.noReturnProvider");

  boolean isCustomNoReturn(@NotNull FunctionReference functionCall);

  static boolean customNoReturn(@NotNull FunctionReference reference) {
    return EP_NAME.getExtensionList().stream().anyMatch(t -> t.isCustomNoReturn(reference));
  }
}
