// Copyright 2000-2019 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.elements;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

public interface Function extends PhpNamedElement, PhpScopeHolder, PhpCallbackElement, PhpTypeDeclarationOwner<PhpReturnType>, PhpAttributesOwner {
  Condition<PsiElement> INSTANCEOF = use -> use instanceof Function;

  Parameter @NotNull [] getParameters();

  @Nullable
  Parameter getParameter(int index);

  @Nullable
  default Parameter getParameter(@Nullable String name) {
    if (name == null) return null;
    return ContainerUtil.find(getParameters(), p -> name.equals(p.getName()));
  }

  boolean hasRefParams();
  
  boolean isClosure();
  
  @NotNull
  PhpType getLocalType(boolean interactive);

  /**
   * PHP 7 style return type element
   * @deprecated use {@link Function#getTypeDeclaration()} instead
   */
  @Nullable
  @Deprecated()
  PhpReturnType getReturnType();

  /**
   * @deprecated use {@link #getDocComment()} and {@link com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment#getExceptionClasses()} instead, to be removed in 2018.2
   */
  @Deprecated
  Collection<String> getDocExceptions();

  default boolean isReturningByReference() {
    return false;
  }

  @Nullable
  default PsiElement getReturnByReferenceTokenFromAST() {
    return null;
  }
}
