// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.elements;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.util.ArrayFactory;
import com.jetbrains.php.lang.psi.stubs.PhpTraitUseRuleStub;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

/**
 * This is actually a method reference.
 * Should be a method definition proxy
 * Name is alias.
 */
public interface PhpTraitUseRule extends PhpNamedElement, StubBasedPsiElement<PhpTraitUseRuleStub> {

  PhpTraitUseRule[] EMPTY = new PhpTraitUseRule[0];
  ArrayFactory<PhpTraitUseRule> ARRAY_FACTORY = count -> count == 0 ? EMPTY : new PhpTraitUseRule[count];

  Condition<PsiElement> INSTANCEOF = use -> use instanceof PhpTraitUseRule;

  @Nullable
  Method getOriginal();

  @Nullable
  MethodReference getOriginalReference();
  @NotNull
  Collection<ClassReference> getOverrides();
  @Nullable
  String getAlias();

  boolean isInsteadOf();

  @Nullable Method getMethod();

  @NotNull
  PhpModifier.Access getAccess();

  String[] getTraitNames();

  @ApiStatus.Internal
  Collection<String> getOverriddenMethodFqns();
}
