// Copyright 2000-2020 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

import static com.intellij.openapi.util.text.StringUtil.startsWithChar;

@ApiStatus.Internal
public interface PhpKeyTypeProvider extends PhpTypeProvider4 {
  ExtensionPointName<PhpKeyTypeProvider> EP_NAME = ExtensionPointName.create("com.jetbrains.php.keyTypeProvider");

  @Override
  @NotNull PhpType getType(PsiElement array);

  @Override
  @NotNull PhpType complete(String expression, Project project);

  static Collection<PhpKeyTypeProvider> getProviders(String sig) {
    return ContainerUtil.filter(EP_NAME.getExtensions(), provider -> StringUtil.startsWithChar(sig, '#') && provider.getKey() == sig.charAt(1));
  }

  static boolean isArrayKeySignature(@NotNull String typeName) {
    return startsWithChar(typeName, '#') && EP_NAME.getExtensionList().stream().anyMatch(s -> typeName.contains("#" + s.getKey()));
  }
}
