// Copyright 2000-2020 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.stubs;

import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.Nullable;

public interface PhpParameterStub extends PhpNamedStub<Parameter>, PhpLanguageTypeMapOwnerStub {
  boolean isPassByRef();
  boolean isOptional();
  boolean isVariadic();
  @Nullable
  String getDefaultValuePresentation();

  boolean isPromotedField();
  int getPromotedFieldAccessIndex();
  boolean isReadonly();
  boolean hasPropertyHooksContainer();

  PhpType getDefaultValueType();
}