/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeception;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeception.CodeceptionFrameworkType;
import com.jetbrains.php.codeception.CodeceptionInfoComponent;
import com.jetbrains.php.codeception.CodeceptionSettingsManager;
import com.jetbrains.php.codeception.run.CodeceptionRunConfigurationType;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.testFramework.PhpTestFrameworkComposerConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeceptionComposerConfig
extends PhpTestFrameworkComposerConfig {
    private static final String PACKAGE = "codeception/codeception";
    private static final String RELATIVE_PATH = "codeception/codeception/codecept";

    public CodeceptionComposerConfig() {
        super(CodeceptionFrameworkType.getInstance(), PACKAGE, RELATIVE_PATH);
    }

    @NotNull
    protected String getDefaultConfigName() {
        return "codeception.yml";
    }

    @NotNull
    protected ConfigurationType getConfigurationType() {
        CodeceptionRunConfigurationType codeceptionRunConfigurationType = CodeceptionRunConfigurationType.getInstance();
        if (codeceptionRunConfigurationType == null) {
            CodeceptionComposerConfig.$$$reportNull$$$0(0);
        }
        return codeceptionRunConfigurationType;
    }

    protected void updateConfigurations(@NotNull Project project, @Nullable VirtualFile configFile, @Nullable VirtualFile composerConfig) {
        if (project == null) {
            CodeceptionComposerConfig.$$$reportNull$$$0(1);
        }
        ReadAction.nonBlocking(() -> CodeceptionComposerConfig.getUpdatedConfigurations(project, configFile, composerConfig)).expireWith((Disposable)ComposerDataService.getInstance((Project)project)).finishOnUiThread(ModalityState.nonModal(), configs -> {
            if (configs != null) {
                CodeceptionSettingsManager.getInstance(project).updateConfigurations((List<CodeceptionSettingsManager.Configuration>)configs);
            }
        }).submit((Executor)ComposerUtils.COMPOSER_CONFIG_EXECUTOR);
    }

    @Nullable
    private static List<CodeceptionSettingsManager.Configuration> getUpdatedConfigurations(@NotNull Project project, @Nullable VirtualFile configFile, @Nullable VirtualFile composerConfig) {
        VirtualFile baseDir;
        if (project == null) {
            CodeceptionComposerConfig.$$$reportNull$$$0(2);
        }
        VirtualFile composerDir = composerConfig != null ? composerConfig.getParent() : null;
        VirtualFile virtualFile = baseDir = composerDir != null ? composerDir : ProjectUtil.guessProjectDir((Project)project);
        if (baseDir == null) {
            return null;
        }
        List oldConfigurations = CodeceptionSettingsManager.getInstance(project).getExistedConfigurations();
        if (composerConfig != null) {
            oldConfigurations = ContainerUtil.filter(oldConfigurations, c -> !composerConfig.equals(CodeceptionComposerConfig.getComposerConfig((Project)project, (String)c.getPath())));
        }
        List<CodeceptionSettingsManager.Configuration> newConfigs = CodeceptionComposerConfig.getConfigurations(project, configFile, composerConfig, baseDir);
        return ContainerUtil.concat((List)oldConfigurations, newConfigs);
    }

    @NotNull
    private static List<CodeceptionSettingsManager.Configuration> getConfigurations(@NotNull Project project, @Nullable VirtualFile configFile, @Nullable VirtualFile composerConfig, VirtualFile baseDir) {
        List fromConfig;
        if (project == null) {
            CodeceptionComposerConfig.$$$reportNull$$$0(3);
        }
        List<Object> list = fromConfig = configFile != null ? CodeceptionInfoComponent.getConfigurations(project, configFile.getPath()) : Collections.emptyList();
        if (CodeceptionComposerConfig.isEnabledForTestFrameworkConfig((Project)project, (VirtualFile)configFile)) {
            fromConfig = ContainerUtil.filter(fromConfig, c -> CodeceptionComposerConfig.isControlledByComposer((Project)project, (String)c.getPath(), (VirtualFile)composerConfig));
        }
        if (!fromConfig.isEmpty()) {
            List list2 = fromConfig;
            if (list2 == null) {
                CodeceptionComposerConfig.$$$reportNull$$$0(4);
            }
            return list2;
        }
        return CodeceptionComposerConfig.getDefaultConfigs(project, composerConfig, baseDir);
    }

    @NotNull
    private static List<CodeceptionSettingsManager.Configuration> getDefaultConfigs(@NotNull Project project, @Nullable VirtualFile composerConfig, VirtualFile baseDir) {
        if (project == null) {
            CodeceptionComposerConfig.$$$reportNull$$$0(5);
        }
        List defaultConfigs = Collections.singletonList(new CodeceptionSettingsManager.Configuration(baseDir.getPath()));
        if (composerConfig != null) {
            defaultConfigs = ContainerUtil.filter(defaultConfigs, config -> PhpTestFrameworkComposerConfig.isDefaultTestRootAllowedByComposer((Project)project, (VirtualFile)composerConfig, (String)config.getPath()));
        }
        List list = defaultConfigs;
        if (list == null) {
            CodeceptionComposerConfig.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public Collection<String> getTestRoots(@NotNull Project project) {
        if (project == null) {
            CodeceptionComposerConfig.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.map(CodeceptionSettingsManager.getInstance(project).getConfigurations(), CodeceptionSettingsManager.Configuration::getPath);
        if (list == null) {
            CodeceptionComposerConfig.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeception/CodeceptionComposerConfig";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeception/CodeceptionComposerConfig";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigs";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateConfigurations";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedConfigurations";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigs";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTestRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 7 -> new IllegalArgumentException(string);
        };
    }
}

