/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeception;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.jetbrains.php.codeception.CodeceptionBundle;
import com.jetbrains.php.codeception.CodeceptionSettingsManager;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkBaseConfigurableForm;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkConfigurationInfoComponent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

public final class CodeceptionInfoComponent
extends PhpTestFrameworkConfigurationInfoComponent<CodeceptionSettingsManager.Configuration> {
    @NotNull
    private static final String GLOBAL_NAMESPACE = "<global namespace>";
    @NotNull
    private static final String DEFAULT_CONFIGURATION_FILENAME = "codeception.yml";
    @NotNull
    private static final String SUITE_CONFIGURATION_FILENAME_SUFFIX = ".suite.yml";
    @NotNull
    private static final List<String> CODECEPTION_SUFFIXES = List.of("unit", "functional");
    @NotNull
    private List<CodeceptionSettingsManager.Configuration> myConfigurations;

    public CodeceptionInfoComponent(@NotNull Project project, @Nullable PhpTestFrameworkBaseConfigurableForm form) {
        if (project == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(0);
        }
        super(project, form);
        this.myConfigurations = new ArrayList<CodeceptionSettingsManager.Configuration>();
    }

    @NotNull
    @Nls
    protected String getConfigurationsHeaderText() {
        String string = CodeceptionBundle.message("php.codeception.config.label", new Object[0]);
        if (string == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void printConfigurationsInfo(@NotNull StyledDocument doc, @NotNull Style style, @NotNull String configDirectoryPath) throws BadLocationException {
        if (doc == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(2);
        }
        if (style == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(3);
        }
        if (configDirectoryPath == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(4);
        }
        for (CodeceptionSettingsManager.Configuration configuration : this.myConfigurations) {
            doc.insertString(doc.getLength(), CodeceptionBundle.message("php.codeception.config.directory.label", new Object[0]), null);
            doc.insertString(doc.getLength(), " ", null);
            doc.insertString(doc.getLength(), FileUtil.getRelativePath((String)configDirectoryPath, (String)configuration.getPath(), (char)'/'), style);
            doc.insertString(doc.getLength(), "\n", null);
            doc.insertString(doc.getLength(), CodeceptionBundle.message("php.codeception.config.namespace.label", new Object[0]), null);
            doc.insertString(doc.getLength(), " ", null);
            doc.insertString(doc.getLength(), CodeceptionInfoComponent.getNamespacePresentation(configuration.getNamespace()), style);
            for (String suiteSuffix : CODECEPTION_SUFFIXES) {
                String suiteNamespace = configuration.getSuiteNamespace(suiteSuffix);
                if (suiteNamespace == null) continue;
                doc.insertString(doc.getLength(), "\n", null);
                String label = CodeceptionBundle.message("php.codeception.config.suite_namespace.label", StringUtil.capitalize((String)suiteSuffix));
                doc.insertString(doc.getLength(), label, null);
                doc.insertString(doc.getLength(), " ", null);
                doc.insertString(doc.getLength(), CodeceptionInfoComponent.getNamespacePresentation(suiteNamespace), style);
            }
            doc.insertString(doc.getLength(), "\n\n", null);
        }
    }

    @NotNull
    private static String getNamespacePresentation(@NotNull String namespace) {
        if (namespace == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(5);
        }
        String string = PhpLangUtil.isGlobalNamespaceName((String)namespace) ? GLOBAL_NAMESPACE : namespace;
        if (string == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(6);
        }
        return string;
    }

    public List<CodeceptionSettingsManager.Configuration> analyzeConfigurationFile(@NotNull String configurationPath) {
        if (configurationPath == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(7);
        }
        return CodeceptionInfoComponent.getConfigurations(this.myProject, configurationPath);
    }

    @NotNull
    public List<CodeceptionSettingsManager.Configuration> getDefaultConfigurations() {
        List<CodeceptionSettingsManager.Configuration> list = CodeceptionSettingsManager.getInstance(this.myProject).getDefaultConfigurations();
        if (list == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<CodeceptionSettingsManager.Configuration> getConfigurations() {
        List<CodeceptionSettingsManager.Configuration> list = this.myConfigurations;
        if (list == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<CodeceptionSettingsManager.Configuration> getConfigurationsFromSettings() {
        List<CodeceptionSettingsManager.Configuration> list = CodeceptionSettingsManager.getInstance(this.myProject).getConfigurations();
        if (list == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(10);
        }
        return list;
    }

    public void setConfigurations(@NotNull List<CodeceptionSettingsManager.Configuration> configurations) {
        if (configurations == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(11);
        }
        this.myConfigurations = configurations;
    }

    public void setConfigurationsToSettings(@NotNull List<CodeceptionSettingsManager.Configuration> configurations) {
        if (configurations == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(12);
        }
        CodeceptionSettingsManager.getInstance(this.myProject).updateConfigurations(configurations);
    }

    protected String getConfigurationPath(@NotNull CodeceptionSettingsManager.Configuration configuration) {
        if (configuration == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(13);
        }
        return configuration.getPath();
    }

    @NotNull
    public static List<CodeceptionSettingsManager.Configuration> getConfigurations(@NotNull Project project, @NotNull String path) {
        if (project == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(14);
        }
        if (path == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(15);
        }
        ArrayList<CodeceptionSettingsManager.Configuration> configurations = new ArrayList<CodeceptionSettingsManager.Configuration>();
        ArrayDeque<String> filesToProcess = new ArrayDeque<String>();
        HashSet<PsiFile> processedFiles = new HashSet<PsiFile>();
        filesToProcess.add(path);
        while (!filesToProcess.isEmpty()) {
            String configPath = (String)filesToProcess.poll();
            PsiFile file = PhpRunUtil.findPsiFile((Project)project, (String)configPath);
            if (file == null || file.getFileType() != YAMLFileType.YML || !processedFiles.add(file)) continue;
            String directoryPath = PathUtil.getParentPath((String)configPath);
            String fileName = CodeceptionInfoComponent.getFileName(configPath);
            CodeceptionSettingsManager.Configuration configuration = new CodeceptionSettingsManager.Configuration(directoryPath);
            for (YAMLKeyValue keyValue : YAMLUtil.getTopLevelKeys((YAMLFile)((YAMLFile)file))) {
                switch (keyValue.getKeyText()) {
                    case "include": {
                        Object object = keyValue.getValue();
                        if (!(object instanceof YAMLSequence)) break;
                        YAMLSequence yamlSequence = (YAMLSequence)object;
                        for (YAMLSequenceItem includeItem : yamlSequence.getItems()) {
                            YAMLValue value = includeItem.getValue();
                            if (value == null) continue;
                            filesToProcess.add(CodeceptionSettingsManager.Configuration.concatPaths(directoryPath, CodeceptionSettingsManager.Configuration.concatPaths(value.getText(), fileName)));
                        }
                        break;
                    }
                    case "paths": {
                        YAMLMapping yamlMapping;
                        YAMLValue directoryValue;
                        Object object = keyValue.getValue();
                        if (!(object instanceof YAMLMapping) || (directoryValue = (yamlMapping = (YAMLMapping)object).getKeyValueByKey("tests")) == null) break;
                        configuration.setPath(CodeceptionSettingsManager.Configuration.concatPaths(directoryPath, directoryValue.getValueText()));
                        break;
                    }
                    case "namespace": {
                        YAMLValue directoryValue = keyValue.getValue();
                        if (!(directoryValue instanceof YAMLScalar)) break;
                        YAMLScalar yamlScalar = (YAMLScalar)directoryValue;
                        configuration.setNamespace(yamlScalar.getTextValue());
                    }
                }
            }
            String configurationDirectory = configuration.getPath();
            for (String suiteSuffix : CODECEPTION_SUFFIXES) {
                YAMLValue namespaceValue;
                YAMLKeyValue namespaceKeyValue;
                PsiFile suiteConfigFile = PhpRunUtil.findPsiFile((Project)project, (String)CodeceptionSettingsManager.Configuration.concatPaths(configurationDirectory, suiteSuffix + SUITE_CONFIGURATION_FILENAME_SUFFIX));
                if (suiteConfigFile == null || suiteConfigFile.getFileType() != YAMLFileType.YML || (namespaceKeyValue = (YAMLKeyValue)ObjectUtils.chooseNotNull((Object)YAMLUtil.getQualifiedKeyInFile((YAMLFile)((YAMLFile)suiteConfigFile), (String[])new String[]{"suite_namespace"}), (Object)YAMLUtil.getQualifiedKeyInFile((YAMLFile)((YAMLFile)suiteConfigFile), (String[])new String[]{"namespace"}))) == null || !((namespaceValue = namespaceKeyValue.getValue()) instanceof YAMLScalar)) continue;
                configuration.setSuiteNamespace(suiteSuffix, ((YAMLScalar)namespaceValue).getTextValue());
            }
            configurations.add(configuration);
        }
        List<CodeceptionSettingsManager.Configuration> list = configurations.isEmpty() ? CodeceptionSettingsManager.getInstance(project).getDefaultConfigurations() : configurations;
        if (list == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    private static String getFileName(@NotNull String path) {
        String fileName;
        if (path == null) {
            CodeceptionInfoComponent.$$$reportNull$$$0(17);
        }
        return !(fileName = PathUtil.getFileName((String)path)).isEmpty() ? fileName : DEFAULT_CONFIGURATION_FILENAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 8, 9, 10, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeception/CodeceptionInfoComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDirectoryPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeception/CodeceptionInfoComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationsHeaderText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacePresentation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigurations";
                break;
            }
            case 9: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationsFromSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "printConfigurationsInfo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNamespacePresentation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "analyzeConfigurationFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurationsToSettings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationPath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurations";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 8, 9, 10, 16 -> new IllegalStateException(string);
        };
    }
}

