/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.interaction;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.ssh.common.ServerDescription;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.interaction.ProjectBasedConnectionOwner;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConnectionOwnerFactory {
    @NotNull
    public static ConnectionOwner createConnectionOwnerWithDialogMessages(@Nullable Project project, @Nullable Component component) {
        if (project != null || component == null) {
            return ConnectionOwnerFactory.createConnectionOwnerWithDialogMessages(project);
        }
        return ConnectionOwnerFactory.createConnectionOwner(component);
    }

    @NotNull
    public static ConnectionOwner createConnectionOwnerWithDialogMessages(final @Nullable Project project) {
        return new ProjectBasedConnectionOwner(project){

            @Override
            protected void showMessageImpl(@NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable ServerDescription server, @Nullable DoNotAskOption doNotAskOption) {
                if (message == null) {
                    1.P(0);
                }
                if (title == null) {
                    1.P(1);
                }
                MessagesService.getInstance().showMessageDialog(project, null, message, title, new String[]{CommonBundle.getOkButtonText()}, 0, 0, UIUtil.getInformationIcon(), doNotAskOption, false, null);
            }

            private static /* synthetic */ void P(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "title";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ssh/interaction/ConnectionOwnerFactory$1";
                objectArray[2] = "showMessageImpl";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static ConnectionOwner createConnectionOwner(@NotNull Component component) {
        if (component == null) {
            ConnectionOwnerFactory.t(0);
        }
        return new ComponentBasedConnectionOwner(component);
    }

    public static <T> T computeOnEDT(@NotNull Computable<? extends T> computable, @Nullable ProgressIndicator progressIndicator2, @NotNull ModalityState defaultModalityState) {
        if (computable == null) {
            ConnectionOwnerFactory.t(1);
        }
        if (defaultModalityState == null) {
            ConnectionOwnerFactory.t(2);
        }
        return ConnectionOwnerFactory.computeOnEDT(computable, progressIndicator2, defaultModalityState, null);
    }

    public static <T> T computeOnEDT(@NotNull Computable<? extends T> computable, @Nullable ProgressIndicator progressIndicator2, @NotNull ModalityState defaultModalityState, @Nullable ModalityState forcedModality) {
        ModalityState modalityState;
        if (computable == null) {
            ConnectionOwnerFactory.t(3);
        }
        if (defaultModalityState == null) {
            ConnectionOwnerFactory.t(4);
        }
        if (forcedModality != null) {
            modalityState = forcedModality;
        } else if (progressIndicator2 != null && !progressIndicator2.isCanceled()) {
            WaitForProgressToShow.execute((ProgressIndicator)progressIndicator2);
            modalityState = progressIndicator2.getModalityState();
        } else {
            modalityState = defaultModalityState;
        }
        Ref ref = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> ref.set(computable.compute()), modalityState);
        return (T)ref.get();
    }

    public static void invokeLater(@NotNull Runnable r, @Nullable ProgressIndicator progressIndicator2, @NotNull ModalityState defaultModalityState) {
        ModalityState modalityState;
        if (r == null) {
            ConnectionOwnerFactory.t(5);
        }
        if (defaultModalityState == null) {
            ConnectionOwnerFactory.t(6);
        }
        if (progressIndicator2 != null && !progressIndicator2.isCanceled()) {
            WaitForProgressToShow.execute((ProgressIndicator)progressIndicator2);
            modalityState = progressIndicator2.getModalityState();
        } else {
            modalityState = defaultModalityState;
        }
        ApplicationManager.getApplication().invokeLater(r, modalityState);
    }

    private static /* synthetic */ void t(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultModalityState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ssh/interaction/ConnectionOwnerFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createConnectionOwner";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computeOnEDT";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeLater";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ComponentBasedConnectionOwner
    implements ConnectionOwner {
        @NotNull
        private final Component myComponent;

        ComponentBasedConnectionOwner(@NotNull Component component) {
            if (component == null) {
                ComponentBasedConnectionOwner.t(0);
            }
            this.myComponent = component;
        }

        @Override
        public boolean promptYesNo(@NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable ProgressIndicator progressIndicator2) {
            if (message == null) {
                ComponentBasedConnectionOwner.t(1);
            }
            if (title == null) {
                ComponentBasedConnectionOwner.t(2);
            }
            Computable computable = () -> ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).icon(UIUtil.getWarningIcon())).ask(this.myComponent);
            return (Boolean)ConnectionOwnerFactory.computeOnEDT(computable, progressIndicator2, ModalityState.stateForComponent((Component)this.myComponent));
        }

        @Override
        @Nullable
        public String promptPassword(@NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable ProgressIndicator progressIndicator2) {
            if (message == null) {
                ComponentBasedConnectionOwner.t(3);
            }
            if (title == null) {
                ComponentBasedConnectionOwner.t(4);
            }
            Computable computable = () -> MessagesService.getInstance().showPasswordDialog((Project)null, message, title, UIUtil.getQuestionIcon(), null);
            return (String)ConnectionOwnerFactory.computeOnEDT(computable, progressIndicator2, ModalityState.stateForComponent((Component)this.myComponent));
        }

        @Override
        public void showMessage(@NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable ServerDescription server, @Nullable ProgressIndicator progressIndicator2, @Nullable DoNotAskOption doNotAskOption) {
            if (message == null) {
                ComponentBasedConnectionOwner.t(5);
            }
            if (title == null) {
                ComponentBasedConnectionOwner.t(6);
            }
            Runnable runnable = () -> Messages.showInfoMessage((Component)this.myComponent, (String)message, (String)title);
            ConnectionOwnerFactory.invokeLater(runnable, progressIndicator2, ModalityState.stateForComponent((Component)this.myComponent));
        }

        @Override
        public String getHash() {
            return String.valueOf(this.myComponent.hashCode());
        }

        @Override
        public void registerUIDisposable(final @Nullable Disposable disposable) {
            if (disposable == null) {
                return;
            }
            UiNotifyConnector.installOn((Component)this.myComponent, (Activatable)new Activatable(){

                public void hideNotify() {
                    Disposer.dispose((Disposable)disposable);
                }
            });
        }

        @Override
        @Nullable
        public Project getProjectForDialogCreation() {
            return null;
        }

        @Override
        public Component getComponentForDialogCreation() {
            return this.myComponent;
        }

        @Override
        public void checkDisposed() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentBasedConnectionOwner componentBasedConnectionOwner = (ComponentBasedConnectionOwner)o;
            return this.myComponent.equals(componentBasedConnectionOwner.myComponent);
        }

        public int hashCode() {
            return this.myComponent.hashCode();
        }

        private static /* synthetic */ void t(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ssh/interaction/ConnectionOwnerFactory$ComponentBasedConnectionOwner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "promptYesNo";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "promptPassword";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showMessage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

