/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.NameMapper;
import com.intellij.javascript.debugger.NameMapperKt;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u001a.\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0013"}, d2={"doExtractName", "", "kotlin.jvm.PlatformType", "rawGeneratedName", "", "context", "Lcom/intellij/psi/PsiElement;", "computeGeneratedName", "element", "generatedDocument", "Lcom/intellij/openapi/editor/Document;", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "mappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "isValidExpression", "", "generatedCode", "intellij.javascript.debugger.backend"})
public final class JavaScriptNameMapperKt {
    public static final String doExtractName(@Nullable CharSequence rawGeneratedName, @Nullable PsiElement context) {
        return (String)ApplicationManager.getApplication().runReadAction(() -> JavaScriptNameMapperKt.doExtractName$lambda$0(rawGeneratedName, context));
    }

    @Nullable
    public static final String computeGeneratedName(@NotNull PsiElement element, @NotNull Document generatedDocument, @NotNull SourceMap sourceMap, @NotNull List<? extends MappingEntry> mappings) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)generatedDocument, (String)"generatedDocument");
        Intrinsics.checkNotNullParameter((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        boolean isNamedElement = element.getParent() instanceof PsiNamedElement;
        if (isNamedElement && mappings.size() > 1) {
            return null;
        }
        CharSequence charSequence = generatedDocument.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence charSequence2 = charSequence;
        StringBuilder expressionBuilder = null;
        CharSequence result = null;
        int n = ((Collection)mappings).size();
        for (int i = 0; i < n; ++i) {
            MappingEntry mapping = mappings.get(i);
            MappingEntry mappingEntry = (MappingEntry)CollectionsKt.getOrNull(mappings, (int)(i + 1));
            if (mappingEntry == null) {
                mappingEntry = sourceMap.getGeneratedMappings().getNextOnTheSameLine(mapping);
            }
            MappingEntry nextMapping = mappingEntry;
            int generatedLineStartOffset = generatedDocument.getLineStartOffset(mapping.getGeneratedLine());
            int start2 = generatedLineStartOffset + mapping.getGeneratedColumn();
            int end = JavaScriptNameMapperKt.computeGeneratedName$computeEnd(mapping, generatedDocument, generatedLineStartOffset, nextMapping);
            if (nextMapping != null) {
                if (start2 > end && nextMapping.getGeneratedColumn() >= mapping.getGeneratedColumn()) {
                    JavaScriptDebugProcessKt.getLOG().warn("incorrect sourcemap, backwards mappings for named element " + element.getText());
                    return null;
                }
                if (isNamedElement && start2 == end) {
                    MappingEntry m = nextMapping;
                    while (start2 == (end = JavaScriptNameMapperKt.computeGeneratedName$computeEnd(mapping, generatedDocument, generatedLineStartOffset, m = sourceMap.getGeneratedMappings().getNext(m))) && m != null) {
                    }
                }
            }
            CharSequence name = charSequence2.subSequence(start2, end);
            if (isNamedElement) {
                result = JavaScriptNameMapperKt.doExtractName(name, element);
                String string = (String)result;
                return string != null ? string.toString() : null;
            }
            if (expressionBuilder == null) {
                expressionBuilder = new StringBuilder();
                result = expressionBuilder;
            }
            StringBuilder stringBuilder = name.length() == 1 && name.charAt(0) == '.' ? expressionBuilder.append('.') : expressionBuilder.append(NameMapper.Companion.trimName(name, i + 1 == mappings.size()));
        }
        if (JavaScriptNameMapperKt.isValidExpression(String.valueOf(result), element)) {
            return String.valueOf(result);
        }
        return null;
    }

    private static final boolean isValidExpression(String generatedCode, PsiElement context) {
        Object object = ApplicationManager.getApplication().runReadAction(() -> JavaScriptNameMapperKt.isValidExpression$lambda$0(generatedCode, context));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        return (Boolean)object;
    }

    private static final String doExtractName$lambda$0(CharSequence $rawGeneratedName, PsiElement $context) {
        if ($rawGeneratedName == null) {
            return null;
        }
        String string = NameMapperKt.getNAME_TRIMMER().trimFrom($rawGeneratedName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimFrom(...)");
        String generatedName = string;
        int i = StringsKt.indexOf$default((CharSequence)generatedName, (char)'=', (int)0, (boolean)false, (int)6, null);
        if (i > 0 && $context != null) {
            PsiElement eqExpr = $context;
            while (!eqExpr.textContains('=') && eqExpr.getParent() != null) {
                Intrinsics.checkNotNullExpressionValue((Object)eqExpr.getParent(), (String)"getParent(...)");
            }
            String string2 = eqExpr.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            int eqPos = StringsKt.indexOf$default((CharSequence)string2, (char)'=', (int)0, (boolean)false, (int)6, null);
            if (eqPos == -1) {
                return null;
            }
            String string3 = eqExpr.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            CharSequence charSequence = string3;
            String string4 = $context.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
            int elementPos = StringsKt.indexOf$default((CharSequence)charSequence, (String)string4, (int)0, (boolean)false, (int)6, null);
            if (elementPos < eqPos) {
                JSFlexAdapter lexer = new JSFlexAdapter(DialectOptionHolder.JS_WITH_JSX, false, false, 6, null);
                lexer.start((CharSequence)generatedName);
                while (lexer.getTokenType() != null) {
                    IElementType tokenType;
                    if (Intrinsics.areEqual((Object)tokenType, (Object)JSTokenTypes.IDENTIFIER)) {
                        return lexer.getTokenText();
                    }
                    lexer.advance();
                }
            } else {
                generatedName = StringsKt.substringAfter$default((String)generatedName, (char)'=', null, (int)2, null);
            }
        }
        if (JSNamesValidation.isIdentifierName((String)generatedName)) {
            return generatedName;
        }
        if ($context != null && $context.getParent() instanceof PsiNamedElement && JavaScriptNameMapperKt.isValidExpression(generatedName, $context)) {
            return generatedName;
        }
        return null;
    }

    private static final int computeGeneratedName$computeEnd(MappingEntry mapping, Document $generatedDocument, int generatedLineStartOffset, MappingEntry nextMapping) {
        return nextMapping == null || nextMapping.getGeneratedLine() != mapping.getGeneratedLine() ? $generatedDocument.getLineEndOffset(mapping.getGeneratedLine()) : generatedLineStartOffset + nextMapping.getGeneratedColumn();
    }

    private static final Boolean isValidExpression$lambda$0(String $generatedCode, PsiElement $context) {
        ASTNode aSTNode = JSChangeUtil.tryCreateExpressionWithContext((String)$generatedCode, (PsiElement)$context, (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_6);
        PsiElement expr = aSTNode != null ? aSTNode.getPsi() : null;
        return expr instanceof JSExpression && !PsiTreeUtil.hasErrorElements((PsiElement)expr) && !SideEffectChecker.mayHaveSideEffects((JSExpression)((JSExpression)expr));
    }
}

