/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.JBIterable;
import com.intellij.vcsUtil.ActionWithTempFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.CancelActionException;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.actions.ActionBaseFile;
import org.jetbrains.idea.perforce.actions.MessageManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceRunnerI;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;

public final class ActionEdit
extends ActionBaseFile {
    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ActionEdit.$$$reportNull$$$0(0);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (presentation.isEnabledAndVisible()) {
            Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
            ChangeListManager clm = ChangeListManager.getInstance((Project)project);
            if (JBIterable.from((Iterable)((Iterable)e.getData(VcsDataKeys.VIRTUAL_FILES))).filter(file -> !clm.isIgnoredFile(file) && !clm.isUnversioned(file)).isEmpty()) {
                presentation.setEnabled(false);
            }
        }
    }

    @Override
    protected void performAction(VirtualFile vFile, Project project, boolean alone, List<VirtualFile> filesToPostProcess) throws CancelActionException, VcsException {
        if (ChangeListManager.getInstance((Project)project).isIgnoredFile(vFile)) {
            return;
        }
        final P4File p4File = P4File.create(vFile);
        final PerforceRunnerI runner = PerforceRunner.getInstance(project).getProxy();
        ActionEdit.log("Action edit on file: " + p4File.getLocalPath());
        if (vFile.isDirectory()) {
            VirtualFile[] children;
            for (VirtualFile child : children = (VirtualFile[])ReadAction.compute(() -> vFile.getChildren())) {
                this.performAction(child, project, alone && children.length == 1, filesToPostProcess);
            }
        } else {
            FileStatus status = FileStatusManager.getInstance((Project)project).getStatus(vFile);
            if (status == FileStatus.IGNORED || status == FileStatus.UNKNOWN) {
                return;
            }
            if (!PerforceSettings.getSettings((Project)project).ENABLED) {
                filesToPostProcess.add(vFile);
                return;
            }
            FStat p4FStat = p4File.getFstat(project, true);
            if (p4FStat.status == FStat.STATUS_NOT_IN_CLIENTSPEC || p4FStat.status == FStat.STATUS_UNKNOWN) {
                if (vFile.isWritable()) {
                    return;
                }
                if (alone) {
                    String msg = PerforceBundle.message("error.message.file.not.under.any.clientspec", p4File.getLocalPath());
                    MessageManager.showMessageDialog(project, msg, PerforceBundle.message("message.title.cannot.edit", new Object[0]), Messages.getErrorIcon());
                } else {
                    String msg = PerforceBundle.message("confirmation.text.file.not.under.any.clientspec.continue.checkout", p4File.getLocalPath());
                    int answer = MessageManager.showDialog(project, msg, PerforceBundle.message("message.title.cannot.edit", new Object[0]), YES_NO_OPTIONS, 1, Messages.getErrorIcon());
                    if (answer != 0) {
                        throw new CancelActionException();
                    }
                }
            } else if (p4FStat.status == FStat.STATUS_NOT_ADDED || p4FStat.status == FStat.STATUS_ONLY_LOCAL) {
                if (alone) {
                    MessageManager.showMessageDialog(project, PerforceBundle.message("message.text.file.not.on.server", p4File.getLocalPath()), PerforceBundle.message("message.title.cannot.edit", new Object[0]), Messages.getErrorIcon());
                }
            } else if (p4FStat.status == FStat.STATUS_DELETED) {
                if (alone) {
                    MessageManager.showMessageDialog(project, PerforceBundle.message("message.text.file.deleted.from.server", p4File.getLocalPath()), PerforceBundle.message("message.title.cannot.edit", new Object[0]), Messages.getErrorIcon());
                }
            } else if (p4FStat.status == FStat.STATUS_ONLY_ON_SERVER) {
                String msg = PerforceBundle.message("confirmation.text.file.registered.as.only.on.server.replace.it", p4File.getLocalPath(), p4FStat.depotFile);
                int answer = MessageManager.showDialog(project, msg, PerforceBundle.message("confirmation.title.file.already.in.perforce", new Object[0]), YES_NO_CANCELREST_OPTIONS, 1, Messages.getErrorIcon());
                if (answer != 1) {
                    if (answer == 2 || answer == -1) {
                        throw new CancelActionException();
                    }
                    new ActionWithTempFile(this, p4File.getLocalFile()){

                        protected void executeInternal() throws VcsException {
                            runner.revert(p4File, false);
                            runner.sync(p4File, false);
                            runner.edit(p4File);
                        }
                    }.execute();
                }
            } else if (p4FStat.local == FStat.LOCAL_DELETING) {
                String msg = PerforceBundle.message("confirmation.text.file.marked.for.deletion.revert.and.replace", p4File.getLocalPath(), p4FStat.depotFile);
                int answer = MessageManager.showDialog(project, msg, PerforceBundle.message("confirmation.title.file.already.in.perforce", new Object[0]), YES_NO_CANCELREST_OPTIONS, 1, Messages.getErrorIcon());
                if (answer != 1) {
                    if (answer == 2 || answer == -1) {
                        throw new CancelActionException();
                    }
                    new ActionWithTempFile(this, p4File.getLocalFile()){

                        protected void executeInternal() throws VcsException {
                            runner.revert(p4File, false);
                            runner.edit(p4File);
                        }
                    }.execute();
                }
            } else if (p4FStat.local != FStat.LOCAL_CHECKED_IN && p4FStat.local != FStat.LOCAL_INTEGRATING) {
                if (alone) {
                    String msg = PerforceBundle.message("message.text.file.already.being.checked.out.or.added", p4File.getLocalPath());
                    MessageManager.showMessageDialog(project, msg, PerforceBundle.message("message.title.no.reason.to.edit", new Object[0]), Messages.getInformationIcon());
                }
            } else {
                filesToPostProcess.add(vFile);
            }
        }
    }

    @Override
    public void postProcessFiles(Project project, List<VirtualFile> filesToPostProcess) {
        VirtualFile[] fileArray = VfsUtilCore.toVirtualFileArray(filesToPostProcess);
        try {
            PerforceVcs.getInstance(project).getEditFileProvider().editFiles(fileArray);
        }
        catch (VcsException e) {
            AbstractVcsHelper.getInstance((Project)project).showError(e, "");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/perforce/actions/ActionEdit", "update"));
    }
}

