/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpspec.resolve.type;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.phpspec.PhpSpecUtil;
import com.jetbrains.php.phpspec.resolve.type.PhpSpecBaseTypeProvider;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class PhpSpecParameterTypeProvider
extends PhpSpecBaseTypeProvider {
    private static final String COLLABORATOR = "\\PhpSpec\\Wrapper\\Collaborator";
    private static final String METHOD_PROPHECY = "\\Prophecy\\Prophecy\\MethodProphecy";

    public char getKey() {
        return '\u01a4';
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        PhpExpression reference;
        PhpClass clazz;
        Project project = element.getProject();
        if (!PhpSpecParameterTypeProvider.isEnabled(project)) {
            return null;
        }
        Method method = (Method)PhpPsiUtil.getParentOfClass((PsiElement)element, Method.class);
        PhpClass phpClass = clazz = method != null ? method.getContainingClass() : null;
        if (clazz == null || !PhpSpecUtil.isSpecTestClass(project, clazz.getFQN())) {
            return null;
        }
        if (element instanceof Parameter && PhpSpecUtil.isSpecMethod(method)) {
            return new PhpType().add(COLLABORATOR);
        }
        if (element instanceof MethodReference && (reference = ((MethodReference)element).getClassReference()) instanceof Variable) {
            PhpType result = new PhpType();
            reference.getType().getTypes().stream().map(s -> "#" + this.getKey() + s).forEach(arg_0 -> ((PhpType)result).add(arg_0));
            return result;
        }
        return null;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        PhpIndex index = PhpIndex.getInstance((Project)project);
        boolean isCollaborator = (PhpType.isUnresolved((String)expression) ? index.getBySignature(expression, visited, depth) : index.getAnyByFQN(expression)).stream().anyMatch(e -> e instanceof PhpClass && PhpLangUtil.equalsClassNames((CharSequence)e.getFQN(), (CharSequence)COLLABORATOR));
        return isCollaborator ? index.getAnyByFQN(METHOD_PROPHECY) : null;
    }
}

