/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpspec.run;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.phpspec.PhpSpecFrameworkType;
import com.jetbrains.php.phpspec.PhpSpecInfoComponent;
import com.jetbrains.php.phpspec.PhpSpecSettingsManager;
import com.jetbrains.php.phpspec.run.PhpSpecRunConfigurationType;
import com.jetbrains.php.testFramework.PhpTestFrameworkComposerConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PhpSpecComposerConfig
extends PhpTestFrameworkComposerConfig {
    private static final String PACKAGE = "phpspec/phpspec";
    private static final String RELATIVE_PATH = "phpspec/phpspec/bin/phpspec";
    private static final String PHPSPEC_YML = "phpspec.yml";

    PhpSpecComposerConfig() {
        super(PhpSpecFrameworkType.getInstance(), PACKAGE, RELATIVE_PATH);
    }

    @NotNull
    protected String getDefaultConfigName() {
        return PHPSPEC_YML;
    }

    @NotNull
    protected ConfigurationType getConfigurationType() {
        PhpSpecRunConfigurationType phpSpecRunConfigurationType = PhpSpecRunConfigurationType.getInstance();
        if (phpSpecRunConfigurationType == null) {
            PhpSpecComposerConfig.$$$reportNull$$$0(0);
        }
        return phpSpecRunConfigurationType;
    }

    protected void updateConfigurations(@NotNull Project project, @Nullable VirtualFile configFile, @Nullable VirtualFile composerConfig) {
        if (project == null) {
            PhpSpecComposerConfig.$$$reportNull$$$0(1);
        }
        ReadAction.nonBlocking(() -> PhpSpecComposerConfig.getUpdatedConfigurations(project, configFile, composerConfig)).expireWith((Disposable)ComposerDataService.getInstance((Project)project)).finishOnUiThread(ModalityState.nonModal(), configs -> {
            if (configs != null) {
                PhpSpecSettingsManager.getInstance(project).updateSuites((List<PhpSpecSettingsManager.PhpSpecSuiteConfiguration>)configs);
            }
        }).submit((Executor)ComposerUtils.COMPOSER_CONFIG_EXECUTOR);
    }

    @RequiresReadLock
    @Nullable
    private static List<PhpSpecSettingsManager.PhpSpecSuiteConfiguration> getUpdatedConfigurations(@NotNull Project project, @Nullable VirtualFile configFile, @Nullable VirtualFile composerConfig) {
        VirtualFile baseDir;
        if (project == null) {
            PhpSpecComposerConfig.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.softAssertReadAccess();
        VirtualFile composerDir = composerConfig != null ? composerConfig.getParent() : null;
        VirtualFile virtualFile = baseDir = composerDir != null ? composerDir : ProjectUtil.guessProjectDir((Project)project);
        if (baseDir == null) {
            return null;
        }
        PhpSpecSettingsManager specSettingsManager = PhpSpecSettingsManager.getInstance(project);
        List oldConfigurations = specSettingsManager.getExistedSuites();
        if (composerConfig != null) {
            oldConfigurations = ContainerUtil.filter(oldConfigurations, c -> !composerConfig.equals(PhpSpecComposerConfig.getComposerConfig((Project)project, (String)c.getFullPath())));
        }
        List<PhpSpecSettingsManager.PhpSpecSuiteConfiguration> newConfigurations = PhpSpecComposerConfig.getPhpSpecSuiteConfigurations(project, configFile, composerConfig, baseDir);
        return ContainerUtil.concat((List)oldConfigurations, newConfigurations);
    }

    @NotNull
    private static List<PhpSpecSettingsManager.PhpSpecSuiteConfiguration> getPhpSpecSuiteConfigurations(@NotNull Project project, @Nullable VirtualFile configFile, @Nullable VirtualFile composerConfig, VirtualFile baseDir) {
        List fromConfig;
        if (project == null) {
            PhpSpecComposerConfig.$$$reportNull$$$0(3);
        }
        List<Object> list = fromConfig = configFile != null ? PhpSpecInfoComponent.getSpecSuites(project, configFile.getPath()) : Collections.emptyList();
        if (PhpSpecComposerConfig.isEnabledForTestFrameworkConfig((Project)project, (VirtualFile)configFile)) {
            fromConfig = ContainerUtil.filter(fromConfig, c -> PhpSpecComposerConfig.isControlledByComposer((Project)project, (String)c.getFullPath(), (VirtualFile)composerConfig));
        }
        if (!fromConfig.isEmpty()) {
            List list2 = fromConfig;
            if (list2 == null) {
                PhpSpecComposerConfig.$$$reportNull$$$0(4);
            }
            return list2;
        }
        return PhpSpecComposerConfig.getDefaultConfigs(project, composerConfig, baseDir);
    }

    @NotNull
    private static List<PhpSpecSettingsManager.PhpSpecSuiteConfiguration> getDefaultConfigs(@NotNull Project project, @Nullable VirtualFile composerConfig, VirtualFile baseDir) {
        if (project == null) {
            PhpSpecComposerConfig.$$$reportNull$$$0(5);
        }
        List defaultConfigs = Collections.singletonList(new PhpSpecSettingsManager.PhpSpecSuiteConfiguration(baseDir.getPath()));
        if (composerConfig != null) {
            defaultConfigs = ContainerUtil.filter(defaultConfigs, config -> PhpTestFrameworkComposerConfig.isDefaultTestRootAllowedByComposer((Project)project, (VirtualFile)composerConfig, (String)config.getPath()));
        }
        List list = defaultConfigs;
        if (list == null) {
            PhpSpecComposerConfig.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public Collection<String> getTestRoots(@NotNull Project project) {
        if (project == null) {
            PhpSpecComposerConfig.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.map(PhpSpecSettingsManager.getInstance(project).getSuites(), PhpSpecSettingsManager.PhpSpecSuiteConfiguration::getFullPath);
        if (list == null) {
            PhpSpecComposerConfig.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpspec/run/PhpSpecComposerConfig";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpspec/run/PhpSpecComposerConfig";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpSpecSuiteConfigurations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigs";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateConfigurations";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedConfigurations";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPhpSpecSuiteConfigurations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigs";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTestRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 7 -> new IllegalArgumentException(string);
        };
    }
}

