/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.GeoHelper;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DatabaseObjectNormalizer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.BaseObjectFormatter;
import com.intellij.database.extractors.BinaryDisplayType;
import com.intellij.database.extractors.DatabaseFormatterCreator;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.DbObjectFormatterUtil;
import com.intellij.database.extractors.DisplayType;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.extractors.JsonUtilKt;
import com.intellij.database.extractors.NumberDisplayType;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.extractors.TextInfo;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.remote.jdbc.GeoWrapper;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.helpers.CassJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.NestedObjectWrapper;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.remote.jdbc.impl.UnparsedValue;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtilCore;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.NumberFormatter;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbObjectFormatter
extends BaseObjectFormatter {
    private static final Pattern PG_HSTORE_REQUIRES_QUOTATION = Pattern.compile("\\s|,|=|>");
    private static final Pattern PG_ARRAY_ITEM_REQUIRES_QUOTATION = Pattern.compile("^$|^\\s|\\s$|[nN][uU][lL][lL]|[\\\\\\\"\\{\\}\\,]");
    private static final NotNullLazyKey<DbObjectFormatter, CoreGrid<GridRow, GridColumn>> FORMATTER_KEY = NotNullLazyKey.createLazyKey((String)"FORMATTER_KEY", DbObjectFormatter::new);
    private final Dbms myDbms;
    @Nullable
    private JdbcHelper myHelper;

    @NotNull
    public static DbObjectFormatter get(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            DbObjectFormatter.$$$reportNull$$$0(0);
        }
        DbObjectFormatter dbObjectFormatter = (DbObjectFormatter)((Object)FORMATTER_KEY.getValue(grid));
        if (dbObjectFormatter == null) {
            DbObjectFormatter.$$$reportNull$$$0(1);
        }
        return dbObjectFormatter;
    }

    private DbObjectFormatter(@NotNull FormatsCache formatsCache, @NotNull Dbms dbms) {
        if (formatsCache == null) {
            DbObjectFormatter.$$$reportNull$$$0(2);
        }
        if (dbms == null) {
            DbObjectFormatter.$$$reportNull$$$0(3);
        }
        super(formatsCache, (FormatterCreator)new DatabaseFormatterCreator(dbms));
        this.myToString.register(byte[].class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<byte[], String>(){

            public String convert(byte[] o, GridColumn column, ObjectFormatterConfig config) {
                return DbObjectFormatterUtil.isMsHierarchyid(DbObjectFormatter.this.myDbms, column) ? DbImplUtilCore.getDatabaseDialect(DbObjectFormatter.this.myDbms).getBinaryLiteralString(o) : (DbObjectFormatterUtil.isClickhouseUInt8Array(DbObjectFormatter.this.myDbms, column) ? DbObjectFormatter.this.arrayToString(DbObjectFormatter.bytesToObjectArray(o), column, config) : (config.getMode() != ObjectFormatterMode.SQL_SCRIPT && DbObjectFormatter.isOracleGUID(o, column, DbObjectFormatter.this.myDbms) ? ObjectFormatterUtil.toHexString((byte[])o) : DbObjectFormatter.this.bytesToStringImpl(o, config)));
            }
        });
        this.myToString.register(BitString.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<BitString, String>(this){

            public String convert(BitString o, GridColumn column, ObjectFormatterConfig config) {
                return DbObjectFormatterUtil.bitsToString(o, column);
            }
        });
        this.myToString.register(Clob.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<Clob, String>(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String convert(Clob o, GridColumn column, ObjectFormatterConfig config) {
                try {
                    long length = o.length();
                    int trimmed = DbObjectFormatter.trimToMax(length);
                    String string = trimmed > 0 ? o.getSubString(1L, trimmed) : "";
                    return string;
                }
                catch (Exception e) {
                    String string = e.toString();
                    return string;
                }
                finally {
                    LobInfo.freeLob((Clob)o);
                }
            }
        });
        this.myToString.register(LobInfo.ClobInfo.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<LobInfo.ClobInfo, String>(this){
            private static final int TOO_LONG_VALUE = 10000;

            public String convert(LobInfo.ClobInfo o, GridColumn column, ObjectFormatterConfig config) {
                return o.isTruncated() && o.data == null ? "" : 4.shortenIfTooLong(o.data, o, config);
            }

            @NotNull
            private static String shortenIfTooLong(@NotNull String result, @NotNull LobInfo.ClobInfo o, @NotNull ObjectFormatterConfig config) {
                if (result == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (o == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (config == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (4.shouldShortenResult(result, o, config)) {
                    String string = StringUtil.shortenTextWithEllipsis((String)result, (int)10000, (int)0);
                    if (string == null) {
                        4.$$$reportNull$$$0(3);
                    }
                    return string;
                }
                String string = result;
                if (string == null) {
                    4.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static boolean shouldShortenResult(@NotNull String result, @NotNull LobInfo.ClobInfo o, @NotNull ObjectFormatterConfig config) {
                if (result == null) {
                    4.$$$reportNull$$$0(5);
                }
                if (o == null) {
                    4.$$$reportNull$$$0(6);
                }
                if (config == null) {
                    4.$$$reportNull$$$0(7);
                }
                if (!o.isFullyReloaded()) {
                    return false;
                }
                if (result.length() <= 10000) {
                    return false;
                }
                return !config.isAllowedShowBigObjects();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 1: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 2: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "config";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/extractors/DbObjectFormatter$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/extractors/DbObjectFormatter$4";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "shortenIfTooLong";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "shortenIfTooLong";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "shouldShortenResult";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3, 4 -> new IllegalStateException(string);
                };
            }
        });
        this.myToString.register(LobInfo.FileClobInfo.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<LobInfo.FileClobInfo, String>(this){

            public String convert(LobInfo.FileClobInfo o, GridColumn column, ObjectFormatterConfig config) {
                return ExtractorsUtil.getPresentableSize(o.length) + " [" + o.file.getPath() + "]";
            }
        });
        this.myToString.register(Blob.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<Blob, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String convert(Blob o, GridColumn column, ObjectFormatterConfig config) {
                try {
                    long length = o.length();
                    int trimmed = DbObjectFormatter.trimToMax(length);
                    String string = DbObjectFormatter.this.bytesToStringImpl(o.getBytes(1L, trimmed), config);
                    return string;
                }
                catch (Exception e) {
                    String string = e.toString();
                    return string;
                }
                finally {
                    LobInfo.freeLob((Blob)o);
                }
            }
        });
        this.myToString.register(LobInfo.BlobInfo.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<LobInfo.BlobInfo, String>(){

            public String convert(LobInfo.BlobInfo o, GridColumn column, ObjectFormatterConfig config) {
                return o.isTruncated() && o.data == null ? "" : DbObjectFormatter.this.bytesToStringImpl(o.data, config);
            }
        });
        this.myToString.register(LobInfo.FileBlobInfo.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<LobInfo.FileBlobInfo, String>(this){

            public String convert(LobInfo.FileBlobInfo o, GridColumn column, ObjectFormatterConfig config) {
                return ExtractorsUtil.getPresentableSize(o.length) + " [" + o.file.getPath() + "]";
            }
        });
        this.myToString.register(Timestamp.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<Timestamp, String>(){

            public String convert(Timestamp o, GridColumn column, ObjectFormatterConfig config) {
                return DbObjectFormatter.this.timestampToString(o, column, config);
            }
        });
        this.myToString.register(ImageInfo.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<ImageInfo, String>(){

            public String convert(ImageInfo o, GridColumn column, ObjectFormatterConfig config) {
                if (config.getMode() == ObjectFormatterMode.DISPLAY || o.bytes == null) {
                    return o.width + "x" + o.height + " " + StringUtil.toUpperCase((String)o.format) + " image " + ExtractorsUtil.getPresentableSize(o.size);
                }
                return DbObjectFormatter.this.bytesToStringImpl(o.bytes, config);
            }
        });
        this.myToString.register(TextInfo.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<TextInfo, String>(){

            public String convert(TextInfo o, GridColumn column, ObjectFormatterConfig config) {
                if (config instanceof DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig) {
                    DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig dbConfig = (DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig)config;
                    DisplayType displayType = dbConfig.getDisplayType();
                    return DatabaseObjectFormatterConfig.isTypeAllowed((ObjectFormatterConfig)config, (BinaryDisplayType)BinaryDisplayType.TEXT) ? o.text : DbObjectFormatter.bytesToString(o.bytes, (BinaryDisplayType)ObjectUtils.tryCast((Object)displayType, BinaryDisplayType.class), DbObjectFormatter.this.myDbms, config.getMode());
                }
                return config.getMode() == ObjectFormatterMode.SQL_SCRIPT && DbObjectFormatter.this.myDbms.isPostgres() && DbObjectFormatter.isPgDecodedLiteral(column, o) ? o.text : (config.getMode() == ObjectFormatterMode.SQL_SCRIPT ? DbImplUtilCore.getDatabaseDialect(DbObjectFormatter.this.myDbms).getBinaryLiteralString(o.bytes) : o.text);
            }
        });
        this.myToString.register(Map.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<Map, String>(){

            public String convert(Map o, GridColumn column, ObjectFormatterConfig config) {
                ObjectFormatterMode itemsMode;
                ObjectFormatterMode objectFormatterMode = itemsMode = config.getMode() == ObjectFormatterMode.DISPLAY || config.getMode() == ObjectFormatterMode.JS_SCRIPT ? ObjectFormatterMode.JS_SCRIPT : ObjectFormatterMode.JSON;
                return DbObjectFormatter.this.myDbms.is(Dbms.CASSANDRA) ? CassJdbcHelper.toValidLiteral((Object)o) : (DbObjectFormatterUtil.isHstore(column) ? DbObjectFormatter.hstoreToString(o, config.getMode()) : (DbObjectFormatter.this.myDbms.in(Dbms.DOCUMENT_ORIENTED) || DbObjectFormatter.this.myDbms.is(Dbms.CLICKHOUSE) ? JsonUtilKt.toJson((Object)o, (ObjectFormatter)DbObjectFormatter.this, (ObjectFormatterMode)itemsMode, (boolean)false, (boolean)DbObjectFormatter.this.myDbms.in(Dbms.DOCUMENT_ORIENTED), (boolean)DbObjectFormatter.this.myDbms.is(Dbms.CLICKHOUSE)) : null));
            }
        });
        this.myToString.register(Set.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<Set, String>(){

            public String convert(Set o, GridColumn column, ObjectFormatterConfig config) {
                return DbObjectFormatter.this.myDbms.is(Dbms.CASSANDRA) ? CassJdbcHelper.toValidLiteral((Object)o) : null;
            }
        });
        this.myToString.register(List.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<List, String>(){

            public String convert(List o, GridColumn column, ObjectFormatterConfig config) {
                ObjectFormatterMode itemsMode;
                ObjectFormatterMode objectFormatterMode = itemsMode = config.getMode() == ObjectFormatterMode.DISPLAY || config.getMode() == ObjectFormatterMode.JS_SCRIPT ? ObjectFormatterMode.JS_SCRIPT : ObjectFormatterMode.JSON;
                return DbObjectFormatter.this.myDbms.is(Dbms.CASSANDRA) ? CassJdbcHelper.toValidLiteral((Object)o) : (DbObjectFormatter.this.myDbms.in(Dbms.DOCUMENT_ORIENTED) || DbObjectFormatter.this.myDbms.is(Dbms.CLICKHOUSE) ? JsonUtilKt.toJson((Object)o, (ObjectFormatter)DbObjectFormatter.this, (ObjectFormatterMode)itemsMode, (boolean)false, (boolean)DbObjectFormatter.this.myDbms.in(Dbms.DOCUMENT_ORIENTED), (boolean)DbObjectFormatter.this.myDbms.is(Dbms.CLICKHOUSE)) : null);
            }
        });
        this.myToString.register(Boolean.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<Boolean, String>(){

            public String convert(Boolean o, GridColumn column, ObjectFormatterConfig config) {
                return config.getMode() != ObjectFormatterMode.SQL_SCRIPT ? String.valueOf(o) : (DbObjectFormatter.this.myDbms.isTransactSql() ? (o.booleanValue() ? "1" : "0") : String.valueOf(o));
            }
        });
        this.myToString.register(TimeZonedTimestamp.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<TimeZonedTimestamp, String>(){

            public String convert(TimeZonedTimestamp o, GridColumn column, ObjectFormatterConfig config) {
                return ((Formatter)DbObjectFormatter.this.myFormatsCache.get(FormatsCache.getShortEraZonedTimestampFormatProvider((GridColumn)column, (ObjectFormatterConfig)config), DbObjectFormatter.this.myFormatterCreator, DbObjectFormatter.this.cacheColumnFormats())).format((Object)o);
            }
        });
        this.myToString.register(TimeZonedTime.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<TimeZonedTime, String>(){

            public String convert(TimeZonedTime o, GridColumn column, ObjectFormatterConfig config) {
                return ((Formatter)DbObjectFormatter.this.myFormatsCache.get(FormatsCache.getZonedTimeFormatProvider((GridColumn)column, (ObjectFormatterConfig)config), DbObjectFormatter.this.myFormatterCreator, DbObjectFormatter.this.cacheColumnFormats())).format((Object)o);
            }
        });
        this.myToString.register(UnparsedValue.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<UnparsedValue, String>(){

            public String convert(UnparsedValue o, GridColumn column, ObjectFormatterConfig config) {
                if (config.getMode() == ObjectFormatterMode.DISPLAY) {
                    Object object = DatabaseObjectNormalizer.convertUnparsedValue(o, column, DbObjectFormatter.this.myFormatsCache, DbObjectFormatter.this.myFormatterCreator);
                    return DbObjectFormatter.this.objectToString(object, column, config);
                }
                return o.getStringRepresentation();
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoValue.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<MongoJdbcHelper.MongoValue, String>(){

            public String convert(MongoJdbcHelper.MongoValue o, GridColumn column, ObjectFormatterConfig config) {
                return DbObjectFormatter.this.mongoValueToString(o, column, config);
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoObjectIdValue.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<MongoJdbcHelper.MongoObjectIdValue, String>(){

            public String convert(MongoJdbcHelper.MongoObjectIdValue o, GridColumn column, ObjectFormatterConfig config) {
                return config.getMode() == ObjectFormatterMode.JS_SCRIPT ? "new ObjectId(\"" + o.unwrap() + "\")" : DbObjectFormatter.this.mongoValueToString((MongoJdbcHelper.MongoValue)o, column, config);
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoRegexpValue.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<MongoJdbcHelper.MongoRegexpValue, String>(){

            public String convert(MongoJdbcHelper.MongoRegexpValue o, GridColumn column, ObjectFormatterConfig config) {
                return config.getMode() == ObjectFormatterMode.JSON ? DbObjectFormatter.this.mongoValueToString((MongoJdbcHelper.MongoValue)o, column, config) : "/" + o.pattern + "/" + o.options;
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoTimestampValue.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<MongoJdbcHelper.MongoTimestampValue, String>(){

            public String convert(MongoJdbcHelper.MongoTimestampValue o, GridColumn column, ObjectFormatterConfig config) {
                return config.getMode() == ObjectFormatterMode.JSON ? DbObjectFormatter.this.mongoValueToString((MongoJdbcHelper.MongoValue)o, column, config) : (config.getMode() == ObjectFormatterMode.JS_SCRIPT ? "new Timestamp(" + o.time + ", " + o.inc + ")" : "Timestamp(" + o.time + ", " + o.inc + ")");
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoMinKeyValue.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<MongoJdbcHelper.MongoMinKeyValue, String>(this){

            public String convert(MongoJdbcHelper.MongoMinKeyValue o, GridColumn column, ObjectFormatterConfig config) {
                if (o == null) {
                    return null;
                }
                return config.getMode() == ObjectFormatterMode.JS_SCRIPT ? "new MinKey()" : (config.getMode() == ObjectFormatterMode.JSON ? String.format("{\"$%s\": \"%s\"}", o.jsonTypeName(), o.unwrap()) : "MinKey()");
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoMaxKeyValue.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<MongoJdbcHelper.MongoMaxKeyValue, String>(this){

            public String convert(MongoJdbcHelper.MongoMaxKeyValue o, GridColumn column, ObjectFormatterConfig config) {
                if (o == null) {
                    return null;
                }
                return config.getMode() == ObjectFormatterMode.JS_SCRIPT ? "new MaxKey()" : (config.getMode() == ObjectFormatterMode.JSON ? String.format("{\"$%s\": \"%s\"}", o.jsonTypeName(), o.unwrap()) : "MaxKey()");
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoBinaryValue.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<MongoJdbcHelper.MongoBinaryValue, String>(){

            public String convert(MongoJdbcHelper.MongoBinaryValue o, GridColumn column, ObjectFormatterConfig config) {
                return DbObjectFormatter.this.convertMongoBinaryValue(o.data, o.type, column, config.getMode());
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoBlobInfo.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<MongoJdbcHelper.MongoBlobInfo, String>(){

            public String convert(MongoJdbcHelper.MongoBlobInfo o, GridColumn column, ObjectFormatterConfig config) {
                return DbObjectFormatter.this.convertMongoBinaryValue(o.data, o.type, column, config.getMode());
            }
        });
        this.myToString.register(UUID.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<UUID, String>(){

            public String convert(UUID o, GridColumn column, ObjectFormatterConfig config) {
                if (DbObjectFormatter.this.myDbms.is(Dbms.MONGO)) {
                    if (config.getMode() == ObjectFormatterMode.JSON) {
                        byte[] binaryData = new byte[16];
                        DbObjectFormatter.writeLongToArrayBigEndian(binaryData, 0, o.getMostSignificantBits());
                        DbObjectFormatter.writeLongToArrayBigEndian(binaryData, 8, o.getLeastSignificantBits());
                        return DbObjectFormatter.this.convertMongoBinaryValue(binaryData, (byte)4, column, config.getMode());
                    }
                    if (config.getMode() == ObjectFormatterMode.JS_SCRIPT) {
                        return "new UUID(\"" + o.toString() + "\")";
                    }
                }
                return o.toString();
            }
        });
        this.myToString.register(Number.class, new NumberLikeTimestampConvertor<Number>(Number::longValue, this::numberToString));
        this.myToString.register(BigInteger.class, new NumberLikeTimestampConvertor<BigInteger>(BigInteger::longValue, (o, column, config) -> ((NumberFormatter)this.myFormatsCache.get(FormatsCache.getLongFormatProvider((ObjectFormatterConfig)config), this.myFormatterCreator)).format(o)));
        this.myToString.register(GeoWrapper.class, (BaseObjectFormatter.Converter)new BaseObjectFormatter.Converter<GeoWrapper, String>(){

            public String convert(GeoWrapper o, GridColumn column, ObjectFormatterConfig config) {
                if (config.getMode() == ObjectFormatterMode.SQL_SCRIPT && DbObjectFormatter.this.myDbms.isMysql()) {
                    GeoHelper helper = (GeoHelper)GeoHelper.EP.forDbms(DbObjectFormatter.this.myDbms);
                    return helper.getDmlForWkt(o.getWkt());
                }
                return o.getWkt();
            }

            public boolean nullValueIndicatesFailedConversion() {
                return false;
            }
        });
        this.myDbms = dbms;
    }

    public DbObjectFormatter(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbObjectFormatter.$$$reportNull$$$0(4);
        }
        this(new FormatsCache(), dbms);
    }

    private DbObjectFormatter(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            DbObjectFormatter.$$$reportNull$$$0(5);
        }
        this(FormatsCache.get(grid), DataGridUtilCore.getDbms(grid));
    }

    private String timestampToString(Timestamp o, GridColumn column, ObjectFormatterConfig config) {
        FormatsCache.FormatProvider provider = FormatsCache.getTimestampFormatProvider((GridColumn)column, (ObjectFormatterConfig)config);
        Formatter format = (Formatter)this.myFormatsCache.get(provider, this.myFormatterCreator, this.cacheColumnFormats());
        String str = format.format((Object)o);
        return this.myDbms.is(Dbms.ORACLE) && config.getMode() == ObjectFormatterMode.SQL_SCRIPT ? DbObjectFormatter.getOracleSqlTimestamp(str, o, this.myFormatsCache, this.myFormatterCreator) : (this.myDbms.is(Dbms.MONGO) ? DbObjectFormatter.mongoDate(str, config.getMode()) : str);
    }

    private static Byte[] bytesToObjectArray(byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new Byte[0];
        }
        Byte[] result = new Byte[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            result[i2] = array[i2];
        }
        return result;
    }

    @Nullable
    protected String reservedCellValueToString(@Nullable ReservedCellValue o, ObjectFormatterConfig config) {
        return this.myDbms.is(Dbms.BIGQUERY) && o == ReservedCellValue.UNSET && config.getMode() == ObjectFormatterMode.DISPLAY ? "" : super.reservedCellValueToString(o, config);
    }

    @NotNull
    protected String dateToString(Date o, GridColumn column, @NotNull ObjectFormatterConfig config) {
        if (config == null) {
            DbObjectFormatter.$$$reportNull$$$0(6);
        }
        if (this.myDbms.is(Dbms.MONGO)) {
            Formatter format = (Formatter)this.myFormatsCache.get(FormatsCache.getTimestampFormatProvider((GridColumn)column, (ObjectFormatterConfig)config), this.myFormatterCreator, this.cacheColumnFormats());
            String str = format.format((Object)o);
            return DbObjectFormatter.mongoDate(str, config.getMode());
        }
        String string = super.dateToString(o, column, config);
        if (string == null) {
            DbObjectFormatter.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    protected String numberToString(@NotNull Number o, GridColumn column, @Nullable ObjectFormatterConfig config) {
        if (o == null) {
            DbObjectFormatter.$$$reportNull$$$0(8);
        }
        if (this.myDbms.is(Dbms.MONGO)) {
            ObjectFormatterMode mode;
            ObjectFormatterMode objectFormatterMode = mode = config != null ? config.getMode() : null;
            if (o instanceof Double) {
                if (Double.isInfinite((Double)o) || Double.isNaN((Double)o)) {
                    String v;
                    String string = (Double)o == Double.POSITIVE_INFINITY ? "Infinity" : (v = (Double)o == Double.NEGATIVE_INFINITY ? "-Infinity" : "NaN");
                    Object object = mode == ObjectFormatterMode.JSON ? "{\"$numberDecimal\": \"" + v + "\"}" : (mode == ObjectFormatterMode.JS_SCRIPT ? "new NumberDecimal(\"" + v + "\")" : v);
                    if (object == null) {
                        DbObjectFormatter.$$$reportNull$$$0(9);
                    }
                    return object;
                }
            } else if (o instanceof BigDecimal) {
                if (mode == ObjectFormatterMode.JSON) {
                    String string = String.format("{\"$numberDecimal\": %s}", ((BigDecimal)o).toPlainString());
                    if (string == null) {
                        DbObjectFormatter.$$$reportNull$$$0(10);
                    }
                    return string;
                }
                if (mode == ObjectFormatterMode.JS_SCRIPT) {
                    String string = "new NumberDecimal(\"" + ((BigDecimal)o).toPlainString() + "\")";
                    if (string == null) {
                        DbObjectFormatter.$$$reportNull$$$0(11);
                    }
                    return string;
                }
            } else if (o instanceof Long) {
                if (mode == ObjectFormatterMode.JS_SCRIPT) {
                    String string = "new NumberLong(\"" + String.valueOf(o) + "\")";
                    if (string == null) {
                        DbObjectFormatter.$$$reportNull$$$0(12);
                    }
                    return string;
                }
            } else if (o instanceof Integer && mode == ObjectFormatterMode.JS_SCRIPT) {
                String string = "new NumberInt(\"" + String.valueOf(o) + "\")";
                if (string == null) {
                    DbObjectFormatter.$$$reportNull$$$0(13);
                }
                return string;
            }
        }
        String string = super.numberToString(o, column, config);
        if (string == null) {
            DbObjectFormatter.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static String getOracleSqlTimestamp(@NotNull String str, @NotNull Timestamp o, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
        LocalDateTime localDateTime;
        if (str == null) {
            DbObjectFormatter.$$$reportNull$$$0(15);
        }
        if (o == null) {
            DbObjectFormatter.$$$reportNull$$$0(16);
        }
        if (formatsCache == null) {
            DbObjectFormatter.$$$reportNull$$$0(17);
        }
        if (formatterCreator == null) {
            DbObjectFormatter.$$$reportNull$$$0(18);
        }
        String prefix = DataGridFormattersUtilCore.isEmptyTime((TemporalAccessor)(localDateTime = DataGridFormattersUtilCore.fromDateToLocalDateTime((Date)o, (FormatsCache)formatsCache, (FormatterCreator)formatterCreator, null))) ? "DATE" : "TIMESTAMP";
        String string = prefix + " '" + str + "'";
        if (string == null) {
            DbObjectFormatter.$$$reportNull$$$0(19);
        }
        return string;
    }

    protected boolean cacheColumnFormats() {
        return !this.myDbms.in(Dbms.DOCUMENT_ORIENTED);
    }

    @NotNull
    private static String mongoDate(String str, ObjectFormatterMode mode) {
        Object object = mode == ObjectFormatterMode.JSON ? "{\"$date\": \"" + str + "\"}" : (mode == ObjectFormatterMode.JS_SCRIPT ? "new ISODate(\"" + str + "\")" : str);
        if (object == null) {
            DbObjectFormatter.$$$reportNull$$$0(20);
        }
        return object;
    }

    @Nullable
    private String mongoValueToString(@Nullable MongoJdbcHelper.MongoValue o, GridColumn column, ObjectFormatterConfig config) {
        if (o == null) {
            return null;
        }
        Object unwrapped = o.unwrap();
        String string = this.objectToString(unwrapped, column, config);
        return config.getMode() == ObjectFormatterMode.JSON ? (string != null && this.isStringLiteral(column, unwrapped, config.getMode()) ? String.format("{\"$%s\": \"%s\"}", o.jsonTypeName(), StringUtil.escapeStringCharacters((String)string)) : String.format("{\"$%s\": %s}", o.jsonTypeName(), string)) : string;
    }

    private static void writeLongToArrayBigEndian(byte[] bytes, int offset, long x) {
        bytes[offset + 7] = (byte)(0xFFL & x);
        bytes[offset + 6] = (byte)(0xFFL & x >> 8);
        bytes[offset + 5] = (byte)(0xFFL & x >> 16);
        bytes[offset + 4] = (byte)(0xFFL & x >> 24);
        bytes[offset + 3] = (byte)(0xFFL & x >> 32);
        bytes[offset + 2] = (byte)(0xFFL & x >> 40);
        bytes[offset + 1] = (byte)(0xFFL & x >> 48);
        bytes[offset] = (byte)(0xFFL & x >> 56);
    }

    private String convertMongoBinaryValue(byte[] data, byte type, GridColumn column, ObjectFormatterMode mode) {
        String string = Base64.getEncoder().encodeToString(data);
        if (mode != ObjectFormatterMode.JSON) {
            String v = "BinData(" + type + ", \"" + string + "\")";
            return mode == ObjectFormatterMode.JS_SCRIPT ? "new " + v : v;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String typeStr = Integer.toString(type, 16);
        map.put("base64", string);
        map.put("subType", typeStr.length() == 1 ? "0" + typeStr : typeStr);
        String str = this.objectToString(map, column, (ObjectFormatterConfig)new DatabaseObjectFormatterConfig(ObjectFormatterMode.JSON));
        return "{\"$binary\": " + str + "}";
    }

    private static boolean isOracleGUID(byte[] o, GridColumn column, Dbms dbms) {
        return dbms.isOracle() && o != null && o.length == 16 && "RAW".equals(column.getTypeName());
    }

    private static boolean isJson(@NotNull GridColumn column) {
        if (column == null) {
            DbObjectFormatter.$$$reportNull$$$0(21);
        }
        return StringUtil.findIgnoreCase((String)column.getTypeName(), (String[])new String[]{"json", "jsonb"});
    }

    private static boolean isPostgresArray(@NotNull GridColumn column) {
        if (column == null) {
            DbObjectFormatter.$$$reportNull$$$0(22);
        }
        return column.getType() == 2003;
    }

    private static boolean isBinaryTextColumn(@NotNull GridColumn column) {
        if (column == null) {
            DbObjectFormatter.$$$reportNull$$$0(23);
        }
        return StringUtil.equals((CharSequence)"bytea", (CharSequence)column.getTypeName());
    }

    private static String hstoreToString(Map<String, String> hstore, ObjectFormatterMode mode) {
        StringBuilder sb = new StringBuilder();
        boolean first2 = true;
        for (Map.Entry<String, String> entry : hstore.entrySet()) {
            if (!first2) {
                sb.append(',');
                sb.append(mode == ObjectFormatterMode.DISPLAY ? (char)'\n' : ' ');
            }
            DbObjectFormatter.appendHstoreValue(sb, entry.getKey(), mode != ObjectFormatterMode.DISPLAY, false);
            sb.append(" => ");
            DbObjectFormatter.appendHstoreValue(sb, StringUtil.notNullize((String)entry.getValue(), (String)"null"), mode != ObjectFormatterMode.DISPLAY, false);
            first2 = false;
        }
        return sb.toString();
    }

    private static void appendHstoreValue(StringBuilder sb, String value, boolean escape, boolean forceQuotation) {
        boolean requiresQuotation;
        boolean bl = requiresQuotation = forceQuotation || PG_HSTORE_REQUIRES_QUOTATION.matcher(value).find();
        if (requiresQuotation) {
            sb.append('\"');
        }
        sb.append(escape ? StringUtil.escapeQuotes((String)value) : value);
        if (requiresQuotation) {
            sb.append('\"');
        }
    }

    @NotNull
    protected String bytesToStringImpl(byte @NotNull [] o, ObjectFormatterConfig config) {
        if (o == null) {
            DbObjectFormatter.$$$reportNull$$$0(24);
        }
        BinaryDisplayType displayType = BinaryDisplayType.DETECT;
        if (config instanceof DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig) {
            displayType = ((DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig)config).getDisplayType();
        }
        return DbObjectFormatter.bytesToString(o, (BinaryDisplayType)ObjectUtils.tryCast((Object)displayType, BinaryDisplayType.class), this.myDbms, config.getMode());
    }

    @NotNull
    public String getStringLiteral(@NotNull String value, GridColumn column, @NotNull ObjectFormatterMode mode) {
        if (value == null) {
            DbObjectFormatter.$$$reportNull$$$0(25);
        }
        if (mode == null) {
            DbObjectFormatter.$$$reportNull$$$0(26);
        }
        String quoted = DbImplUtilCore.StringLiteralDecorator.PLAIN.decorate(value, this.myDbms, true);
        Object object = mode == ObjectFormatterMode.SQL_SCRIPT && this.myDbms.in(Dbms.MYSQL_LIKE) && column != null && DbObjectFormatterUtil.isBitString(column) ? "b" + quoted : quoted;
        if (object == null) {
            DbObjectFormatter.$$$reportNull$$$0(27);
        }
        return object;
    }

    @NotNull
    private JdbcHelper getHelper() {
        if (this.myHelper == null) {
            this.myHelper = DbImplUtilCore.getJdbcHelper(this.myDbms);
        }
        JdbcHelper jdbcHelper = this.myHelper;
        if (jdbcHelper == null) {
            DbObjectFormatter.$$$reportNull$$$0(28);
        }
        return jdbcHelper;
    }

    public boolean isStringLiteral(@Nullable GridColumn column, @Nullable Object value, @NotNull ObjectFormatterMode mode) {
        if (mode == null) {
            DbObjectFormatter.$$$reportNull$$$0(29);
        }
        if (mode == ObjectFormatterMode.JSON) {
            if (value instanceof Number || value instanceof Boolean || value instanceof Map || value instanceof List) {
                return false;
            }
            return !this.myDbms.isMongo() || !(value instanceof MongoJdbcHelper.MongoValue) && !(value instanceof Date) && !DbObjectFormatter.isSpecialDouble(value) && !(value instanceof LobInfo.BlobInfo) && !(value instanceof UUID);
        }
        if (this.myDbms.is(Dbms.MONGO)) {
            return switch (mode) {
                case ObjectFormatterMode.JS_SCRIPT -> {
                    if (value instanceof String || value instanceof LobInfo.ClobInfo) {
                        yield true;
                    }
                    yield false;
                }
                case ObjectFormatterMode.DEFAULT, ObjectFormatterMode.SQL_SCRIPT -> {
                    if (value instanceof String || value instanceof LobInfo.ClobInfo || value instanceof MongoJdbcHelper.MongoValue || value instanceof UUID || value instanceof java.sql.Date || value instanceof Map || value instanceof List || value instanceof NestedObjectWrapper || DbObjectFormatter.isSpecialDouble(value)) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        if (mode == ObjectFormatterMode.SQL_SCRIPT && this.myDbms.is(Dbms.ORACLE) && value instanceof Timestamp) {
            return false;
        }
        if (mode == ObjectFormatterMode.SQL_SCRIPT || mode == ObjectFormatterMode.DEFAULT || mode == ObjectFormatterMode.JS_SCRIPT) {
            return value instanceof LobInfo.ClobInfo || column != null && (DbObjectFormatter.isCommonLiteral(this.myDbms, column, value, this.getHelper()) || DbObjectFormatter.isJson(column) || DbObjectFormatter.isPostgresStringLiteral(this.myDbms, column, value));
        }
        return false;
    }

    private static boolean isSpecialDouble(@Nullable Object value) {
        return value instanceof Double && (Double.isNaN((Double)value) || Double.isInfinite((Double)value));
    }

    private static boolean isCommonLiteral(@NotNull Dbms dbms, @NotNull GridColumn column, @Nullable Object value, @Nullable JdbcHelper helper) {
        if (dbms == null) {
            DbObjectFormatter.$$$reportNull$$$0(30);
        }
        if (column == null) {
            DbObjectFormatter.$$$reportNull$$$0(31);
        }
        helper = helper != null ? helper : DbImplUtilCore.getJdbcHelper(dbms);
        int jdbcType = ExtractorsUtil.guessJdbcType(column, value, dbms);
        if (dbms.is(Dbms.CASSANDRA) && (StringUtil.equalsIgnoreCase((CharSequence)column.getTypeName(), (CharSequence)"uuid") || StringUtil.equalsIgnoreCase((CharSequence)column.getTypeName(), (CharSequence)"timeuuid"))) {
            return false;
        }
        return jdbcType == 1 || jdbcType == 12 || jdbcType == -1 || jdbcType == -15 || jdbcType == -9 || jdbcType == -16 || jdbcType == 92 || jdbcType == 91 || jdbcType == 2002 || jdbcType == 2005 || jdbcType == -8 || helper.isTimestamp(jdbcType) || helper.isZonedColumn(column.getTypeName(), jdbcType) || DbObjectFormatterUtil.isBitString(column) || StringUtil.equalsIgnoreCase((CharSequence)column.getTypeName(), (CharSequence)"uuid") || DbObjectFormatter.isSpecialNumber(value);
    }

    private static boolean isSpecialNumber(@Nullable Object value) {
        return value instanceof Float && (Float.isNaN(((Float)value).floatValue()) || Float.isInfinite(((Float)value).floatValue())) || value instanceof Double && (Double.isNaN((Double)value) || Double.isInfinite((Double)value));
    }

    private static boolean isPostgresStringLiteral(@NotNull Dbms dbms, @NotNull GridColumn column, @Nullable Object value) {
        if (dbms == null) {
            DbObjectFormatter.$$$reportNull$$$0(32);
        }
        if (column == null) {
            DbObjectFormatter.$$$reportNull$$$0(33);
        }
        return dbms.isPostgres() && (DbObjectFormatterUtil.isHstore(column) || DbObjectFormatterUtil.isPostgresRangeType(column) || DbObjectFormatter.isPostgresArray(column) || StringUtil.findIgnoreCase((String)column.getTypeName(), (String[])new String[]{"interval", "cird", "circle", "inet", "line", "lseg", "macaddr", "macaddr8", "money", "path", "point", "polygon", "tsquery", "tsvector", "xml"}) || DbObjectFormatter.isPgDecodedLiteral(column, value));
    }

    private static boolean isPgDecodedLiteral(@NotNull GridColumn column, @Nullable Object value) {
        if (column == null) {
            DbObjectFormatter.$$$reportNull$$$0(34);
        }
        return value instanceof TextInfo && DbObjectFormatter.isBinaryTextColumn(column);
    }

    @NotNull
    protected <T> String arrayToString(T[] o, GridColumn column, ObjectFormatterConfig config) {
        if (this.myDbms.is(Dbms.CLICKHOUSE)) {
            String string = JsonUtilKt.toJson(o, (ObjectFormatter)this, (ObjectFormatterMode)ObjectFormatterMode.JSON, (boolean)false, (boolean)false, (boolean)true);
            if (string == null) {
                DbObjectFormatter.$$$reportNull$$$0(35);
            }
            return string;
        }
        String string = super.arrayToString((Object[])o, column, config);
        if (string == null) {
            DbObjectFormatter.$$$reportNull$$$0(36);
        }
        return string;
    }

    protected <T> void appendArrayItem(StringBuilder sb, T o, GridColumn column, ObjectFormatterConfig config) {
        if (this.myDbms.is(Dbms.POSTGRES) && o instanceof String) {
            String repr = this.objectToString(o, column, config);
            if (repr == null || !PG_ARRAY_ITEM_REQUIRES_QUOTATION.matcher(repr).find()) {
                sb.append(repr);
                return;
            }
            repr = StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeChars((String)repr, (char[])new char[]{'\\', '\"'}));
            sb.append(repr);
            return;
        }
        super.appendArrayItem(sb, o, column, config);
    }

    @NotNull
    private static String bytesToString(byte @NotNull [] bytes, @Nullable BinaryDisplayType displayType, Dbms dbms, @NotNull ObjectFormatterMode mode) {
        if (mode == null) {
            DbObjectFormatter.$$$reportNull$$$0(37);
        }
        if (bytes == null) {
            DbObjectFormatter.$$$reportNull$$$0(38);
        }
        if (mode == ObjectFormatterMode.DISPLAY || mode == ObjectFormatterMode.DEFAULT) {
            String string = ObjectFormatterUtil.toPresentableString((byte[])bytes, (BinaryDisplayType)displayType);
            if (string == null) {
                DbObjectFormatter.$$$reportNull$$$0(39);
            }
            return string;
        }
        TextInfo value = TextInfo.tryDetectString((byte[])bytes);
        if (mode != ObjectFormatterMode.SQL_SCRIPT && value != null) {
            String string = value.text;
            if (string == null) {
                DbObjectFormatter.$$$reportNull$$$0(40);
            }
            return string;
        }
        String string = DbImplUtilCore.getDatabaseDialect(dbms).getBinaryLiteralString(bytes);
        if (string == null) {
            DbObjectFormatter.$$$reportNull$$$0(41);
        }
        return string;
    }

    private static int trimToMax(long length) {
        int maxLobLength = DatabaseSettings.getSettings().getBytesLimitPerValue();
        return (long)maxLobLength < length ? maxLobLength : (int)length;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 9, 10, 11, 12, 13, 14, 19, 20, 27, 28, 35, 36, 39, 40, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/DbObjectFormatter";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatsCache";
                break;
            }
            case 3: 
            case 4: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 8: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatterCreator";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 26: 
            case 29: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/DbObjectFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "dateToString";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "numberToString";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOracleSqlTimestamp";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "mongoDate";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteral";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelper";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayToString";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "bytesToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 41: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dateToString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "numberToString";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOracleSqlTimestamp";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isJson";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isPostgresArray";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryTextColumn";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "bytesToStringImpl";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getStringLiteral";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteral";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isCommonLiteral";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isPostgresStringLiteral";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isPgDecodedLiteral";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "bytesToString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 9, 10, 11, 12, 13, 14, 19, 20, 27, 28, 35, 36, 39, 40, 41 -> new IllegalStateException(string);
        };
    }

    private class NumberLikeTimestampConvertor<T>
    implements BaseObjectFormatter.Converter<T, String> {
        private final Function<T, Long> toLong;
        private final Function3<T, GridColumn, ObjectFormatterConfig, String> fallback;

        private NumberLikeTimestampConvertor(@NotNull Function<T, Long> toLong, Function3<T, GridColumn, ObjectFormatterConfig, String> fallback) {
            if (toLong == null) {
                NumberLikeTimestampConvertor.$$$reportNull$$$0(0);
            }
            if (fallback == null) {
                NumberLikeTimestampConvertor.$$$reportNull$$$0(1);
            }
            this.toLong = toLong;
            this.fallback = fallback;
        }

        public String convert(T o, GridColumn column, ObjectFormatterConfig config) {
            if (config instanceof DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig) {
                DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig fineConfig = (DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig)config;
                NumberDisplayType displayType = (NumberDisplayType)ObjectUtils.notNull((Object)((NumberDisplayType)ObjectUtils.tryCast((Object)fineConfig.getDisplayType(), NumberDisplayType.class)), (Object)NumberDisplayType.NUMBER);
                long valueToShow = this.toLong.apply(o);
                if (displayType != NumberDisplayType.NUMBER) {
                    try {
                        Timestamp myTimestamp;
                        if (displayType == NumberDisplayType.TIMESTAMP_SECONDS) {
                            myTimestamp = Timestamp.from(Instant.ofEpochSecond(valueToShow));
                        } else if (displayType == NumberDisplayType.TIMESTAMP_MILLISECONDS) {
                            myTimestamp = Timestamp.from(Instant.ofEpochMilli(valueToShow));
                        } else {
                            long seconds = valueToShow / 1000000L;
                            int micros = (int)(valueToShow % 1000000L);
                            int nanos = micros * 1000;
                            myTimestamp = Timestamp.from(Instant.ofEpochSecond(seconds, nanos));
                        }
                        return DbObjectFormatter.this.timestampToString(myTimestamp, column, config);
                    }
                    catch (IllegalArgumentException | DateTimeException e) {
                        return String.format("Incorrect timestamp (%s)", this.fallback.invoke(o, (Object)column, (Object)config));
                    }
                }
            }
            return (String)this.fallback.invoke(o, (Object)column, (Object)config);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "toLong";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fallback";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/extractors/DbObjectFormatter$NumberLikeTimestampConvertor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

