/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.MultiPredicateValue;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateSpecKt;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.remote.jdbc.helpers.CouchbaseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.run.ui.grid.editors.NumberFormatter;
import com.intellij.database.run.ui.grid.editors.UnparsedValueWithDomain;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtractorsUtil
extends GridExtractorsUtilCore {
    private ExtractorsUtil() {
    }

    @Nullable
    public static NumberFormatter getNumberFormatter(@NotNull Domain domain, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator, @Nullable ObjectFormatterConfig config) {
        if (domain == null) {
            ExtractorsUtil.$$$reportNull$$$0(0);
        }
        if (formatsCache == null) {
            ExtractorsUtil.$$$reportNull$$$0(1);
        }
        if (formatterCreator == null) {
            ExtractorsUtil.$$$reportNull$$$0(2);
        }
        if (ExtractorsUtil.isIntDomain(domain)) {
            return (NumberFormatter)formatsCache.get(FormatsCache.getIntFormatProvider((ObjectFormatterConfig)config), formatterCreator);
        }
        if (ExtractorsUtil.isLongDomain(domain)) {
            return (NumberFormatter)formatsCache.get(FormatsCache.getLongFormatProvider((ObjectFormatterConfig)config), formatterCreator);
        }
        ConversionPoint point = domain.getPoint();
        if (point == ConversionPoint.SINGLE_PRECISION) {
            return (NumberFormatter)formatsCache.get(FormatsCache.getFloatFormatProvider((ObjectFormatterConfig)config), formatterCreator);
        }
        if (point == ConversionPoint.DOUBLE_PRECISION) {
            return (NumberFormatter)formatsCache.get(FormatsCache.getDoubleFormatProvider((ObjectFormatterConfig)config), formatterCreator);
        }
        if (point == ConversionPoint.BIG_DECIMAL) {
            return (NumberFormatter)formatsCache.get(FormatsCache.getBigIntFormatProvider((ObjectFormatterConfig)config), formatterCreator);
        }
        return null;
    }

    @NotNull
    public static String getPresentableSize(long length) {
        String string = StringUtil.formatFileSize((long)length);
        if (string == null) {
            ExtractorsUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getTypeName(@Nullable GridColumn column, @Nullable Object value, @NotNull Dbms dbms) {
        if (dbms == null) {
            ExtractorsUtil.$$$reportNull$$$0(4);
        }
        return value instanceof UnparsedValueWithDomain ? ((UnparsedValueWithDomain)((Object)value)).getDomain().simpleName() : (dbms.is(Dbms.MONGO) ? MongoJdbcHelper.getTypeName((Object)value) : (dbms.is(Dbms.COUCHBASE_QUERY) ? CouchbaseJdbcHelper.getTypeName((Object)value) : (column != null && column.getTypeName() != null ? column.getTypeName() : "unknown")));
    }

    public static int guessJdbcType(@NotNull GridColumn column, @Nullable Object value, @NotNull Dbms dbms) {
        if (column == null) {
            ExtractorsUtil.$$$reportNull$$$0(5);
        }
        if (dbms == null) {
            ExtractorsUtil.$$$reportNull$$$0(6);
        }
        if (dbms.in(Dbms.DOCUMENT_ORIENTED) && value != null && !(value instanceof ReservedCellValue)) {
            Domain type;
            Domain domain = type = value instanceof UnparsedValueWithDomain ? ((UnparsedValueWithDomain)((Object)value)).getDomain() : null;
            if (type != null) {
                return ExtractorsUtil.guessJdbcType(type, dbms);
            }
            String typeName = dbms.is(Dbms.MONGO) ? MongoJdbcHelper.getTypeName((Object)value) : CouchbaseJdbcHelper.getTypeName((Object)value);
            return ExtractorsUtil.guessJdbcType(typeName, dbms);
        }
        JdbcHelper helper = DbImplUtilCore.getJdbcHelper(dbms);
        if (helper.isTimestamp(column.getType())) {
            return 93;
        }
        if (column.getType() != 1111 && column.getType() != 0 && (!dbms.is(Dbms.ORACLE) || column.getType() != 100 && column.getType() != 101)) {
            return column.getType();
        }
        if (!(column instanceof DataConsumer.Column)) {
            return column.getType();
        }
        DataConsumer.Column c2 = (DataConsumer.Column)column;
        int byType = JdbcUtil.guessJdbcTypeByName((String)column.getTypeName());
        String className = c2.getJavaClassName();
        if (className == null) {
            return byType;
        }
        if (byType == -6 && className.equals("java.lang.Boolean")) {
            return 16;
        }
        if (byType != 1111) {
            return byType;
        }
        if (JdbcUtil.isFloat((String)className)) {
            return 6;
        }
        if (JdbcUtil.isDouble((String)className)) {
            return 8;
        }
        if (JdbcUtil.isBigDecimal((String)className)) {
            return 3;
        }
        if (className.equals("java.lang.Boolean")) {
            return 16;
        }
        if (className.equals("java.lang.String")) {
            return 12;
        }
        if (className.equals("java.lang.Integer")) {
            return 4;
        }
        if (className.equals("java.lang.Double")) {
            return 8;
        }
        if (className.equals("java.lang.Float")) {
            return 6;
        }
        if (className.endsWith(".Date")) {
            return 91;
        }
        if (className.endsWith(".Time")) {
            return 92;
        }
        if (className.endsWith(".Timestamp")) {
            return 93;
        }
        if (className.endsWith(".UUID")) {
            return 12;
        }
        return column.getType();
    }

    public static int guessJdbcType(@NotNull Domain type, @NotNull Dbms dbms) {
        if (type == null) {
            ExtractorsUtil.$$$reportNull$$$0(7);
        }
        if (dbms == null) {
            ExtractorsUtil.$$$reportNull$$$0(8);
        }
        if (LogicalType.isText((LogicalType)type.getLogicType())) {
            return 12;
        }
        if (ExtractorsUtil.isIntDomain(type)) {
            return 4;
        }
        if (ExtractorsUtil.isLongDomain(type)) {
            return -5;
        }
        return switch (type.getLogicType()) {
            case LogicalType.CLOB -> 2005;
            case LogicalType.TIME -> 92;
            case LogicalType.DATE -> 91;
            case LogicalType.TIMESTAMP -> 93;
            case LogicalType.BOOLEAN -> 16;
            case LogicalType.DOUBLE_PRECISION -> 8;
            case LogicalType.SINGLE_PRECISION -> 6;
            case LogicalType.FIXED_POINT_NUMBER -> 3;
            default -> ExtractorsUtil.guessJdbcType(type.simpleName(), dbms);
        };
    }

    private static int guessJdbcType(@NotNull String typeName, @NotNull Dbms dbms) {
        if (typeName == null) {
            ExtractorsUtil.$$$reportNull$$$0(9);
        }
        if (dbms == null) {
            ExtractorsUtil.$$$reportNull$$$0(10);
        }
        Integer type = dbms.is(Dbms.MONGO) ? (Integer)MongoJdbcHelper.TYPES_MAP.get(typeName) : (Integer)CouchbaseJdbcHelper.TYPES_MAP.get(typeName);
        return type != null ? type : 1111;
    }

    private static boolean isIntDomain(@NotNull Domain domain) {
        if (domain == null) {
            ExtractorsUtil.$$$reportNull$$$0(11);
        }
        return domain instanceof IntegerDomain && domain.cardinality().equals(new Cardinality.MinMaxCardinality(-2.147483648E9, 2.147483647E9, false));
    }

    private static boolean isLongDomain(@NotNull Domain domain) {
        if (domain == null) {
            ExtractorsUtil.$$$reportNull$$$0(12);
        }
        return domain instanceof IntegerDomain && domain.cardinality().equals(new Cardinality.MinMaxCardinality(-9.223372036854776E18, 9.223372036854776E18, false));
    }

    public static List<List<Triple<ColumnRef, ModelIndex<GridColumn>, Object>>> collectColumnsAndValuesList(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndexSet<GridRow> selectedRows, @NotNull IntSet keyColumns, @NotNull Function<ModelIndex<GridRow>, List<Triple<ColumnRef, ModelIndex<GridColumn>, Object>>> producer) {
        if (grid == null) {
            ExtractorsUtil.$$$reportNull$$$0(13);
        }
        if (selectedRows == null) {
            ExtractorsUtil.$$$reportNull$$$0(14);
        }
        if (keyColumns == null) {
            ExtractorsUtil.$$$reportNull$$$0(15);
        }
        if (producer == null) {
            ExtractorsUtil.$$$reportNull$$$0(16);
        }
        return ExtractorsUtil.collectColumnsAndValuesList(selectedRows, keyColumns, (row, column) -> grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column), (o1, o2) -> GridCellEditorHelper.get((CoreGrid)grid).areValuesEqual(o1, o2, grid), producer);
    }

    public static List<List<Triple<ColumnRef, ModelIndex<GridColumn>, Object>>> collectColumnsAndValuesList(@NotNull ModelIndexSet<GridRow> selectedRows, @NotNull IntSet keyColumns, @NotNull BiFunction<ModelIndex<GridRow>, ModelIndex<GridColumn>, Object> getValueAt, @NotNull BiFunction<Object, Object, Boolean> areValuesEqual, @NotNull Function<ModelIndex<GridRow>, List<Triple<ColumnRef, ModelIndex<GridColumn>, Object>>> producer) {
        if (selectedRows == null) {
            ExtractorsUtil.$$$reportNull$$$0(17);
        }
        if (keyColumns == null) {
            ExtractorsUtil.$$$reportNull$$$0(18);
        }
        if (getValueAt == null) {
            ExtractorsUtil.$$$reportNull$$$0(19);
        }
        if (areValuesEqual == null) {
            ExtractorsUtil.$$$reportNull$$$0(20);
        }
        if (producer == null) {
            ExtractorsUtil.$$$reportNull$$$0(21);
        }
        boolean checkUniqueness = selectedRows.size() <= 500;
        LinkedList<ModelIndex> visitedRows = new LinkedList<ModelIndex>();
        ArrayList<List<Triple<ColumnRef, ModelIndex<GridColumn>, Object>>> columnsAndValuesList = new ArrayList<List<Triple<ColumnRef, ModelIndex<GridColumn>, Object>>>();
        for (ModelIndex selectedRow : selectedRows.asIterable()) {
            boolean uniqueValues;
            boolean bl = uniqueValues = !checkUniqueness || ContainerUtil.all(visitedRows, visitedRow -> !ContainerUtil.all((Collection)keyColumns, column -> {
                ModelIndex columnIdx = ModelIndex.forColumn((GridModel)null, (int)column);
                Object usedValue = getValueAt.apply((ModelIndex<GridRow>)visitedRow, (ModelIndex<GridColumn>)columnIdx);
                Object currentValue = getValueAt.apply(selectedRow, columnIdx);
                return (Boolean)areValuesEqual.apply(usedValue, currentValue);
            }));
            if (!uniqueValues) continue;
            visitedRows.add(selectedRow);
            List<Triple<ColumnRef, ModelIndex<GridColumn>, Object>> columnsAndValues = producer.apply((ModelIndex<GridRow>)selectedRow);
            if (columnsAndValues == null || columnsAndValues.isEmpty()) continue;
            columnsAndValuesList.add(columnsAndValues);
        }
        return columnsAndValuesList;
    }

    @NotNull
    public static <T> WhereClause createWhereClauseTask(boolean newLineBeforeOuterOp, boolean supportsInOperator, @NotNull List<List<Triple<ColumnRef, ModelIndex<GridColumn>, T>>> columnsAndValuesList, @NotNull BiFunction<ModelIndex<GridColumn>, T, PredicateValue> createPredicateValue) {
        if (columnsAndValuesList == null) {
            ExtractorsUtil.$$$reportNull$$$0(22);
        }
        if (createPredicateValue == null) {
            ExtractorsUtil.$$$reportNull$$$0(23);
        }
        ColumnRef columnRef = columnsAndValuesList.size() <= 1 || columnsAndValuesList.get(0).isEmpty() ? null : (ColumnRef)columnsAndValuesList.get(0).get(0).getFirst();
        boolean singleColumn = columnRef != null && ContainerUtil.find(columnsAndValuesList, list -> ContainerUtil.find((Iterable)list, v -> !((ColumnRef)v.getFirst()).equals(columnRef)) != null) == null;
        boolean useLikeOperatorFlag = Registry.is((String)"database.sqlGenerator.forceUseLike", (boolean)false);
        Set<PredicateOperation> ops = PredicateSpecKt.DEFAULT_OPS;
        if (useLikeOperatorFlag) {
            ops.add(new LikePredicateOperation(LikeOpType.MATCHES, true, false));
        }
        if (singleColumn && supportsInOperator) {
            List predicateValues = ContainerUtil.flatMap(columnsAndValuesList, columnsAndValues -> ContainerUtil.map((Collection)columnsAndValues, v -> (PredicateValue)createPredicateValue.apply((ModelIndex)v.getSecond(), v.getThird())));
            return new ValuesWhereClause(Collections.singletonList(Collections.singletonList(new Triple((Object)columnRef, (Object)new MultiPredicateValue(predicateValues), ops))), "", "", false, null);
        }
        return new ValuesWhereClause((List<? extends List<? extends Triple<? extends ColumnRef, ? extends PredicateValue, ? extends Set<? extends PredicateOperation>>>>)ContainerUtil.map(columnsAndValuesList, columnsAndValues -> ContainerUtil.map((Collection)columnsAndValues, v -> new Triple((Object)((ColumnRef)v.getFirst()), (Object)((PredicateValue)createPredicateValue.apply((ModelIndex)v.getSecond(), v.getThird())), (Object)ops))), "AND", "OR", newLineBeforeOuterOp, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatsCache";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatterCreator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/ExtractorsUtil";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRows";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyColumns";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getValueAt";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "areValuesEqual";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsAndValuesList";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createPredicateValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/ExtractorsUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNumberFormatter";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "guessJdbcType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isIntDomain";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isLongDomain";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectColumnsAndValuesList";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createWhereClauseTask";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

