/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 83626825209894L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-482992950 + -9110, -482992950 + -16157, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-482992950 + -9109, -482992950 + -((char)-29954), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 77773315185646L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.t();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(47447340 - (char)-15826, -47447340 - -((char)-4049), (int)l2) + string + WindowsNamedPipeAgentIpc.b(47447340 - (char)-15827, -47447340 - -32536, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(47447340 - (char)-15820, -47447340 - -((char)-24754), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l2;
                    block15: {
                        block16: {
                            l2 = 109133063778708L;
                            Object object = this.lock;
                            synchronized (object) {
                                boolean bl3;
                                bl2 = SshAgentIpcService.t();
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-2055177600 + -((char)-22019), -2055177600 + -((char)-5740), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2055177600 + -((char)-22016), 2055177600 + (char)-4448, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-2055177600 + -((char)-22017), -2055177600 + -((char)-11735), (int)l2));
                                    this.hPipe = hANDLE;
                                    windowsNamedPipeAgentIpc = this;
                                    if (bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-2055177600 + -((char)-22030), 2055177600 + (char)-25777, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2055177600 + -((char)-22031), 2055177600 + (char)-3999, (int)l2) + ErrorToolsKt.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2055177600 + -((char)-22028), -2055177600 + -((char)-17739), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-2055177600 + -((char)-22030), 2055177600 + (char)-25777, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2055177600 + -((char)-22029), -2055177600 + -((char)-16178), (int)l2));
                            if (ActionTimestamp.t() != null) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.t(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l2 = 113307761511475L;
                    bl = SshAgentIpcService.P();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (!bl) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (!bl) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        boolean bl;
        long l2;
        block27: {
            block28: {
                l2 = 65302696652056L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl2;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            bl = SshAgentIpcService.t();
                            boolean bl3 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (bl) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl4 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2013890550 - 15344, 2013890550 - 29257, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(2013890550 - 15348, -2013890550 - -17465, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2013890550 - 15343, -2013890550 - -5434, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl2 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl2) {
                        boolean bl5 = false;
                        String string = WindowsNamedPipeAgentIpc.b(2013890550 - 15348, -2013890550 - -17465, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2013890550 - 15346, -2013890550 - -27401, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl6 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2013890550 - 15344, 2013890550 - 29257, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2013890550 - 15348, -2013890550 - -17465, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2013890550 - 15345, -2013890550 - -23936, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (bl) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl7 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2013890550 - 15344, 2013890550 - 29257, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2013890550 - 15348, -2013890550 - -17465, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2013890550 - 15324, -2013890550 - -29992, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(2013890550 - 15348, -2013890550 - -17465, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2013890550 - 15323, -2013890550 - -22629, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl8;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl9 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (bl) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl8 = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl8) {
                boolean bl10 = false;
                String string = WindowsNamedPipeAgentIpc.b(2013890550 - 15348, -2013890550 - -17465, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2013890550 - 15346, -2013890550 - -27401, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl11 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2013890550 - 15344, 2013890550 - 29257, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(2013890550 - 15348, -2013890550 - -17465, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2013890550 - 15326, -2013890550 - -27987, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 87522931370135L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(87816900 - 28410, -87816900 - -24812, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 98903817079870L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-689821410 - -1604, -689821410 - -9725, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u0093\u008e\u0007\u0013T\u0002\u008b\u00fff\u00d0\u00c5\u00c6\u0095\u00abb\u0004\u00ee\u0007\\\u0014T>\u00ff\u0003P\u00c2vb[e\u00a7\u00a4\u001b\u001er9\u0001f\u00a6~";
                        var4_3 = "\u0093\u008e\u0007\u0013T\u0002\u008b\u00fff\u00d0\u00c5\u00c6\u0095\u00abb\u0004\u00ee\u0007\\\u0014T>\u00ff\u0003P\u00c2vb[e\u00a7\u00a4\u001b\u001er9\u0001f\u00a6~".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 44;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 50;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 117;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 78;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 69;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 35;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 113;
                                        break;
                                    }
                                    default: {
                                        v11 = 26;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x635D) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 49;
                            case 1 -> 136;
                            case 2 -> 130;
                            case 3 -> 155;
                            case 4 -> 86;
                            case 5 -> 185;
                            case 6 -> 80;
                            case 7 -> 48;
                            case 8 -> 108;
                            case 9 -> 2;
                            case 10 -> 156;
                            case 11 -> 69;
                            case 12 -> 17;
                            case 13 -> 140;
                            case 14 -> 7;
                            case 15 -> 5;
                            case 16 -> 188;
                            case 17 -> 203;
                            case 18 -> 61;
                            case 19 -> 63;
                            case 20 -> 142;
                            case 21 -> 174;
                            case 22 -> 129;
                            case 23 -> 68;
                            case 24 -> 230;
                            case 25 -> 245;
                            case 26 -> 72;
                            case 27 -> 164;
                            case 28 -> 150;
                            case 29 -> 239;
                            case 30 -> 233;
                            case 31 -> 166;
                            case 32 -> 209;
                            case 33 -> 192;
                            case 34 -> 42;
                            case 35 -> 214;
                            case 36 -> 216;
                            case 37 -> 112;
                            case 38 -> 18;
                            case 39 -> 14;
                            case 40 -> 44;
                            case 41 -> 128;
                            case 42 -> 170;
                            case 43 -> 223;
                            case 44 -> 183;
                            case 45 -> 75;
                            case 46 -> 198;
                            case 47 -> 30;
                            case 48 -> 62;
                            case 49 -> 74;
                            case 50 -> 251;
                            case 51 -> 23;
                            case 52 -> 242;
                            case 53 -> 41;
                            case 54 -> 161;
                            case 55 -> 252;
                            case 56 -> 107;
                            case 57 -> 65;
                            case 58 -> 193;
                            case 59 -> 4;
                            case 60 -> 104;
                            case 61 -> 134;
                            case 62 -> 213;
                            case 63 -> 60;
                            case 64 -> 22;
                            case 65 -> 25;
                            case 66 -> 38;
                            case 67 -> 195;
                            case 68 -> 201;
                            case 69 -> 33;
                            case 70 -> 20;
                            case 71 -> 240;
                            case 72 -> 177;
                            case 73 -> 158;
                            case 74 -> 1;
                            case 75 -> 85;
                            case 76 -> 126;
                            case 77 -> 215;
                            case 78 -> 59;
                            case 79 -> 200;
                            case 80 -> 82;
                            case 81 -> 67;
                            case 82 -> 79;
                            case 83 -> 124;
                            case 84 -> 190;
                            case 85 -> 117;
                            case 86 -> 56;
                            case 87 -> 28;
                            case 88 -> 54;
                            case 89 -> 0;
                            case 90 -> 184;
                            case 91 -> 219;
                            case 92 -> 186;
                            case 93 -> 9;
                            case 94 -> 253;
                            case 95 -> 160;
                            case 96 -> 51;
                            case 97 -> 231;
                            case 98 -> 162;
                            case 99 -> 210;
                            case 100 -> 116;
                            case 101 -> 176;
                            case 102 -> 218;
                            case 103 -> 135;
                            case 104 -> 119;
                            case 105 -> 137;
                            case 106 -> 241;
                            case 107 -> 139;
                            case 108 -> 145;
                            case 109 -> 27;
                            case 110 -> 247;
                            case 111 -> 165;
                            case 112 -> 64;
                            case 113 -> 110;
                            case 114 -> 171;
                            case 115 -> 93;
                            case 116 -> 224;
                            case 117 -> 159;
                            case 118 -> 206;
                            case 119 -> 122;
                            case 120 -> 118;
                            case 121 -> 182;
                            case 122 -> 138;
                            case 123 -> 97;
                            case 124 -> 29;
                            case 125 -> 172;
                            case 126 -> 204;
                            case 127 -> 50;
                            case 128 -> 168;
                            case 129 -> 21;
                            case 130 -> 12;
                            case 131 -> 36;
                            case 132 -> 227;
                            case 133 -> 197;
                            case 134 -> 31;
                            case 135 -> 101;
                            case 136 -> 57;
                            case 137 -> 10;
                            case 138 -> 106;
                            case 139 -> 189;
                            case 140 -> 234;
                            case 141 -> 220;
                            case 142 -> 6;
                            case 143 -> 249;
                            case 144 -> 180;
                            case 145 -> 70;
                            case 146 -> 151;
                            case 147 -> 179;
                            case 148 -> 147;
                            case 149 -> 163;
                            case 150 -> 141;
                            case 151 -> 71;
                            case 152 -> 250;
                            case 153 -> 173;
                            case 154 -> 202;
                            case 155 -> 243;
                            case 156 -> 187;
                            case 157 -> 149;
                            case 158 -> 226;
                            case 159 -> 53;
                            case 160 -> 208;
                            case 161 -> 87;
                            case 162 -> 95;
                            case 163 -> 16;
                            case 164 -> 167;
                            case 165 -> 123;
                            case 166 -> 207;
                            case 167 -> 196;
                            case 168 -> 132;
                            case 169 -> 127;
                            case 170 -> 52;
                            case 171 -> 15;
                            case 172 -> 144;
                            case 173 -> 232;
                            case 174 -> 115;
                            case 175 -> 181;
                            case 176 -> 35;
                            case 177 -> 81;
                            case 178 -> 120;
                            case 179 -> 255;
                            case 180 -> 175;
                            case 181 -> 211;
                            case 182 -> 121;
                            case 183 -> 40;
                            case 184 -> 212;
                            case 185 -> 73;
                            case 186 -> 152;
                            case 187 -> 111;
                            case 188 -> 66;
                            case 189 -> 11;
                            case 190 -> 236;
                            case 191 -> 248;
                            case 192 -> 91;
                            case 193 -> 34;
                            case 194 -> 100;
                            case 195 -> 83;
                            case 196 -> 58;
                            case 197 -> 105;
                            case 198 -> 237;
                            case 199 -> 146;
                            case 200 -> 109;
                            case 201 -> 32;
                            case 202 -> 92;
                            case 203 -> 194;
                            case 204 -> 96;
                            case 205 -> 113;
                            case 206 -> 55;
                            case 207 -> 77;
                            case 208 -> 94;
                            case 209 -> 45;
                            case 210 -> 84;
                            case 211 -> 102;
                            case 212 -> 228;
                            case 213 -> 254;
                            case 214 -> 47;
                            case 215 -> 153;
                            case 216 -> 199;
                            case 217 -> 76;
                            case 218 -> 169;
                            case 219 -> 78;
                            case 220 -> 154;
                            case 221 -> 221;
                            case 222 -> 246;
                            case 223 -> 235;
                            case 224 -> 24;
                            case 225 -> 3;
                            case 226 -> 217;
                            case 227 -> 238;
                            case 228 -> 222;
                            case 229 -> 13;
                            case 230 -> 157;
                            case 231 -> 143;
                            case 232 -> 191;
                            case 233 -> 90;
                            case 234 -> 99;
                            case 235 -> 103;
                            case 236 -> 225;
                            case 237 -> 37;
                            case 238 -> 88;
                            case 239 -> 244;
                            case 240 -> 114;
                            case 241 -> 19;
                            case 242 -> 39;
                            case 243 -> 98;
                            case 244 -> 205;
                            case 245 -> 26;
                            case 246 -> 46;
                            case 247 -> 229;
                            case 248 -> 125;
                            case 249 -> 148;
                            case 250 -> 8;
                            case 251 -> 178;
                            case 252 -> 133;
                            case 253 -> 131;
                            case 254 -> 89;
                            default -> 43;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (bl) {
                ActionTimestamp.t(new int[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 64185039375909L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.P();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (!bl2) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1048166790 - (char)-11701, 1048035720 + (char)-2808, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1048166790 - (char)-11705, -1048166790 - -((char)-7932), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1048166790 - (char)-11678, 1048166790 - (char)-10920, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1048166790 - (char)-11701, 1048035720 + (char)-2808, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1048166790 - (char)-11705, -1048166790 - -((char)-7932), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1048166790 - (char)-11677, -1048166790 - -((char)-11157), (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l2 = 130431835953345L;
                        boolean bl3 = SshAgentIpcService.t();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-2025817920 + -32506, 2025817920 + (char)-12425, (int)l2));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-2025817920 + -32507, -2025817920 + -((char)-20964), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l2;
        block25: {
            block26: {
                l2 = 42301028689816L;
                boolean bl2 = SshAgentIpcService.P();
                this.assertConnectionThread();
                Object object2 = this.lock;
                bl = bl2;
                synchronized (object2) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl4 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (!bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (!bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-104200650 + -16304, -104200650 + -26377, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-104200650 + -16308, 104200650 + 15609, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-104200650 + -16281, -104200650 + -21138, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-104200650 + -16308, 104200650 + 15609, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-104200650 + -16306, 104200650 + 28617, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-104200650 + -16304, -104200650 + -26377, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-104200650 + -16308, 104200650 + 15609, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-104200650 + -16292, 104200650 + 7541, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (!bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl7 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-104200650 + -16304, -104200650 + -26377, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-104200650 + -16308, 104200650 + 15609, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-104200650 + -16291, -104200650 + -6053, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl8 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (!bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl9 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-104200650 + -16304, -104200650 + -26377, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-104200650 + -16308, 104200650 + 15609, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-104200650 + -16294, 104200650 + 21140, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                boolean bl2;
                block16: {
                    l2 = 75851173778682L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                bl2 = SshAgentIpcService.P();
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (!bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28714, 2051376570 - (char)-9877, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28710, -2051376570 - -((char)-29861), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28729, 2051376570 - (char)-4775, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28730, -2051376570 - -((char)-7984), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28714, 2051376570 - (char)-9877, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28710, -2051376570 - -((char)-29861), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28731, -2051376570 - -((char)-1772), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (!bl2) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (!bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28714, 2051376570 - (char)-9877, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28710, -2051376570 - -((char)-29861), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28732, -2051376570 - -((char)-17959), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28714, 2051376570 - (char)-9877, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28710, -2051376570 - -((char)-29861), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28733, 2051376570 - (char)-26798, (int)l2));
                    if (!bl2) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28714, 2051376570 - (char)-9877, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28710, -2051376570 - -((char)-29861), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28686, -2051376570 - -((char)-2866), (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(2051376570 - (char)-28687, 2051376570 - (char)-26005, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u0019\u00a9%-i.\u00cb8\u0014\u007f\u00ba\u00d1\u00a8\t\u0016h%^Y\u00fd\u00e5W\u00fd\u00a8\u00d3\u00e8\u0093\u00c2\u00d1\u0006\u00f2\u00d5X\u00a2\u00ac\u009e\u0018`\u00ecRR\u00fb\u008c4\u00b6\u001dV\u009at\u00dd0\u00ab\u00e8!\u009d\u00d5\u008d\u00cf\u0003\u00b0\u009c\t\u0015Gb\u0096\u0096\u008b\u0081\u001e\u0097\u0005\u009b\u00b8u\u000f\u0013\bzpIg\u00b6A67\u0014l\u00d4\u00cb\u00fe'\u00d4\u0098\u00ea.}X\u00d5\u00a9X\u00cc\u008avk\u00e8\u008c\u0005\u0000L\u0006\u0091}\u001e\u0011\u001b1\u001f\u0006\u00e1)a\u001b\u00b8\u0011.\u00e0[\u00ae\u00e1`-/o<p\u00c2?9\u008c\u009b\n\u00e5)\u0010-\u001dR\u001a=s\u00b8\u00caT\u007fu+j\u00aeP\u00c0\tMZ\u00bf$~\u00fa\u00ba\u00af\u001e\u0010\u0002\u00e0\u00b7\u00a5\u0081\u0084/4\u00a6\u00a0+\u00d0\u00a1\u00d1)/?\u00b4\u00f1\u008dB\u009cC\u00ffY\u00b0n!\u000fY\u0089\u00a4\u0082\u00e4$\u00c2\u008b\u000f\u00be\u00df\u0080\u008a\u0093\u00e0]\u00bd\u00958\u00ddF\u00c7H@L\u00eb\u00c3\u00bd\u00d4\u00d4\u0088\bx\u001b \u0097n\u00b1]\u0010\u00f8\u009e\u0081K2&\u001e\u0081\u00ae;\u00da\b\u009d+\u00b5\f),\u00c5\u009a\f\u00b0S\u0000\u0018\u0082\u00cc^\u0081\u00a1^\u0099\u000bF\u00a9J#;\u00e6\u00a8\u00d2\r0\u00c3\u00a1|\u00df\u00efkh\u00e1\u001ebc\t\u00f1\u001c[\u00c4\u00c3\u00da\\E\u009c\u001d\u00c0\u00de\u00d2\u0099\u00c3\u00ac\u00d6t\u00de\u00b1\u00ad\u00af\u00dcB\u00043\t\u00eb\u009a\u008b\u00df\u00cd\u00f11\u00bd\u00bb\u008c\u00b9hio~\u00df0W\u00a6\u0088\u00dd\u00f8\u001f2\u00cdU\u00c5\u008a\u00ba\u00b8\n)\u00d5W\u0083(\u00f3\u00bcEYQu*\u00bcX\u0005\u0091\u00a0\u0089\u00bff|U8\u000bw\r\u00f8\u00d3\u009d\u00b5\u00bd\u00ae\u00dd\u00b7\u001c\u0015\u008f\u00a9\u00e7Dy/\u00cd\u0080\u00ed\u0092\u00d2\u00a0&;`\n9,\u00a4\u00fc\u00b0);\u00fet\u00a3\u00aev<\u0093\u00b9\u00e6E\u00e5n5\u00ea\u0098\u00ccb\u001c\u00eba\u0018x\u0081`\u00c2pw\u00aa\u0083`\u001d\u008f\u00cc\u00d5\u008d;\u0002\r\u00ed=\u0007\u000f\u0006\u00f8\u00a6\u001b\u008b\u0011\u0007&\u00f0\u00b9\u0014\u00d42\u00fe(\u00eb\u00e9\"`\u00d4d\u0085\u00f6\u00fe\u009d\u0087\u00bc\u0015\u009f\u00c7Nn\u0015\u00e6F_\u0093\u00d0;\u00e5)vq]#E\u0010\u00d0\u0006\u00a0y/\u00e1\u001cb\u000f\n\u00f8Pkri\u00f4\u0094\u00a5\\M\u00d5\u00ec\u00e6f\"\u001d$\u00b0\u00f86\u001d/\u00fe\u00dbK\tP\u00e4\u008f\u00df\u0001\u0081x?\u00ea\u00ef8\t\u00d5\u00dd\u001c\nr\u00c1\u0011\u00afHX\u0095\u000e\u00f5\u00d1\u00afN\u008d\u00cd\u000b\u0000Z\u00ce\u00b2\u0087\u001f\u00a6\u001b\u00b2\u00d8@j\u008b\u00fc^z\u00a7\u0006\u0080\u009f\t\u0093D\u0094Z`\u00f9u\f\u00ff\u0006\u008bw\u00ba\n\nQ\u00dd\u00f8\u00cd\u0088\u00ec\u00edRza\u0018\u00ff\u00c9\u00e9E\u00bf\u00a5\u00f9\u000fMa\u001f\u00ecC\u00ae\u00f1\u0012\u009b\u00b1\u00166\u0089\u00dc\u00ed\u00bc)\u009a\u00be@\u00ab(w\u00ec\u00b3\u00a3\u00e2\u0006e\u0002,\u00f8\u00c0\u00f0\u001cD\u00e1PI\u0017\u00a7\u00f8\u0094\u00feQ(\u001b\u008b\u009f\u00d7B\u000b\u00c8>\u008e\u00ad|)\t\u00b0\u00d1\u0000K\u0083\u00d8S\u00b0\u009e";
                var4_3 = "\u0019\u00a9%-i.\u00cb8\u0014\u007f\u00ba\u00d1\u00a8\t\u0016h%^Y\u00fd\u00e5W\u00fd\u00a8\u00d3\u00e8\u0093\u00c2\u00d1\u0006\u00f2\u00d5X\u00a2\u00ac\u009e\u0018`\u00ecRR\u00fb\u008c4\u00b6\u001dV\u009at\u00dd0\u00ab\u00e8!\u009d\u00d5\u008d\u00cf\u0003\u00b0\u009c\t\u0015Gb\u0096\u0096\u008b\u0081\u001e\u0097\u0005\u009b\u00b8u\u000f\u0013\bzpIg\u00b6A67\u0014l\u00d4\u00cb\u00fe'\u00d4\u0098\u00ea.}X\u00d5\u00a9X\u00cc\u008avk\u00e8\u008c\u0005\u0000L\u0006\u0091}\u001e\u0011\u001b1\u001f\u0006\u00e1)a\u001b\u00b8\u0011.\u00e0[\u00ae\u00e1`-/o<p\u00c2?9\u008c\u009b\n\u00e5)\u0010-\u001dR\u001a=s\u00b8\u00caT\u007fu+j\u00aeP\u00c0\tMZ\u00bf$~\u00fa\u00ba\u00af\u001e\u0010\u0002\u00e0\u00b7\u00a5\u0081\u0084/4\u00a6\u00a0+\u00d0\u00a1\u00d1)/?\u00b4\u00f1\u008dB\u009cC\u00ffY\u00b0n!\u000fY\u0089\u00a4\u0082\u00e4$\u00c2\u008b\u000f\u00be\u00df\u0080\u008a\u0093\u00e0]\u00bd\u00958\u00ddF\u00c7H@L\u00eb\u00c3\u00bd\u00d4\u00d4\u0088\bx\u001b \u0097n\u00b1]\u0010\u00f8\u009e\u0081K2&\u001e\u0081\u00ae;\u00da\b\u009d+\u00b5\f),\u00c5\u009a\f\u00b0S\u0000\u0018\u0082\u00cc^\u0081\u00a1^\u0099\u000bF\u00a9J#;\u00e6\u00a8\u00d2\r0\u00c3\u00a1|\u00df\u00efkh\u00e1\u001ebc\t\u00f1\u001c[\u00c4\u00c3\u00da\\E\u009c\u001d\u00c0\u00de\u00d2\u0099\u00c3\u00ac\u00d6t\u00de\u00b1\u00ad\u00af\u00dcB\u00043\t\u00eb\u009a\u008b\u00df\u00cd\u00f11\u00bd\u00bb\u008c\u00b9hio~\u00df0W\u00a6\u0088\u00dd\u00f8\u001f2\u00cdU\u00c5\u008a\u00ba\u00b8\n)\u00d5W\u0083(\u00f3\u00bcEYQu*\u00bcX\u0005\u0091\u00a0\u0089\u00bff|U8\u000bw\r\u00f8\u00d3\u009d\u00b5\u00bd\u00ae\u00dd\u00b7\u001c\u0015\u008f\u00a9\u00e7Dy/\u00cd\u0080\u00ed\u0092\u00d2\u00a0&;`\n9,\u00a4\u00fc\u00b0);\u00fet\u00a3\u00aev<\u0093\u00b9\u00e6E\u00e5n5\u00ea\u0098\u00ccb\u001c\u00eba\u0018x\u0081`\u00c2pw\u00aa\u0083`\u001d\u008f\u00cc\u00d5\u008d;\u0002\r\u00ed=\u0007\u000f\u0006\u00f8\u00a6\u001b\u008b\u0011\u0007&\u00f0\u00b9\u0014\u00d42\u00fe(\u00eb\u00e9\"`\u00d4d\u0085\u00f6\u00fe\u009d\u0087\u00bc\u0015\u009f\u00c7Nn\u0015\u00e6F_\u0093\u00d0;\u00e5)vq]#E\u0010\u00d0\u0006\u00a0y/\u00e1\u001cb\u000f\n\u00f8Pkri\u00f4\u0094\u00a5\\M\u00d5\u00ec\u00e6f\"\u001d$\u00b0\u00f86\u001d/\u00fe\u00dbK\tP\u00e4\u008f\u00df\u0001\u0081x?\u00ea\u00ef8\t\u00d5\u00dd\u001c\nr\u00c1\u0011\u00afHX\u0095\u000e\u00f5\u00d1\u00afN\u008d\u00cd\u000b\u0000Z\u00ce\u00b2\u0087\u001f\u00a6\u001b\u00b2\u00d8@j\u008b\u00fc^z\u00a7\u0006\u0080\u009f\t\u0093D\u0094Z`\u00f9u\f\u00ff\u0006\u008bw\u00ba\n\nQ\u00dd\u00f8\u00cd\u0088\u00ec\u00edRza\u0018\u00ff\u00c9\u00e9E\u00bf\u00a5\u00f9\u000fMa\u001f\u00ecC\u00ae\u00f1\u0012\u009b\u00b1\u00166\u0089\u00dc\u00ed\u00bc)\u009a\u00be@\u00ab(w\u00ec\u00b3\u00a3\u00e2\u0006e\u0002,\u00f8\u00c0\u00f0\u001cD\u00e1PI\u0017\u00a7\u00f8\u0094\u00feQ(\u001b\u008b\u009f\u00d7B\u000b\u00c8>\u008e\u00ad|)\t\u00b0\u00d1\u0000K\u0083\u00d8S\u00b0\u009e".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 125;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "15w\u0098\u008cS:u;xWtjL\u00b7\u008e[\u009b#\u00d7\u00ab\u00f2\u00d9L\u00c8\u00b7+2@\u0014\u00a46\u00e8{l.\u0086`\u00c1\u00b3L\u00fa#\\d\u00a53\u001f\u00fb\u0002";
                    var4_3 = "15w\u0098\u008cS:u;xWtjL\u00b7\u008e[\u009b#\u00d7\u00ab\u00f2\u00d9L\u00c8\u00b7+2@\u0014\u00a46\u00e8{l.\u0086`\u00c1\u00b3L\u00fa#\\d\u00a53\u001f\u00fb\u0002".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 127;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 12;
                            break;
                        }
                        case 1: {
                            v15 = 47;
                            break;
                        }
                        case 2: {
                            v15 = 91;
                            break;
                        }
                        case 3: {
                            v15 = 14;
                            break;
                        }
                        case 4: {
                            v15 = 90;
                            break;
                        }
                        case 5: {
                            v15 = 48;
                            break;
                        }
                        default: {
                            v15 = 81;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x2112) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 228;
                case 1 -> 34;
                case 2 -> 125;
                case 3 -> 227;
                case 4 -> 13;
                case 5 -> 81;
                case 6 -> 9;
                case 7 -> 87;
                case 8 -> 12;
                case 9 -> 245;
                case 10 -> 213;
                case 11 -> 131;
                case 12 -> 246;
                case 13 -> 7;
                case 14 -> 163;
                case 15 -> 110;
                case 16 -> 183;
                case 17 -> 209;
                case 18 -> 49;
                case 19 -> 58;
                case 20 -> 178;
                case 21 -> 240;
                case 22 -> 39;
                case 23 -> 219;
                case 24 -> 141;
                case 25 -> 67;
                case 26 -> 136;
                case 27 -> 134;
                case 28 -> 234;
                case 29 -> 101;
                case 30 -> 73;
                case 31 -> 25;
                case 32 -> 224;
                case 33 -> 3;
                case 34 -> 43;
                case 35 -> 181;
                case 36 -> 211;
                case 37 -> 57;
                case 38 -> 155;
                case 39 -> 208;
                case 40 -> 47;
                case 41 -> 103;
                case 42 -> 22;
                case 43 -> 204;
                case 44 -> 116;
                case 45 -> 199;
                case 46 -> 198;
                case 47 -> 153;
                case 48 -> 186;
                case 49 -> 45;
                case 50 -> 230;
                case 51 -> 95;
                case 52 -> 233;
                case 53 -> 171;
                case 54 -> 203;
                case 55 -> 139;
                case 56 -> 229;
                case 57 -> 148;
                case 58 -> 187;
                case 59 -> 24;
                case 60 -> 32;
                case 61 -> 88;
                case 62 -> 123;
                case 63 -> 37;
                case 64 -> 94;
                case 65 -> 119;
                case 66 -> 118;
                case 67 -> 254;
                case 68 -> 62;
                case 69 -> 133;
                case 70 -> 223;
                case 71 -> 231;
                case 72 -> 42;
                case 73 -> 190;
                case 74 -> 80;
                case 75 -> 247;
                case 76 -> 189;
                case 77 -> 150;
                case 78 -> 51;
                case 79 -> 158;
                case 80 -> 170;
                case 81 -> 160;
                case 82 -> 207;
                case 83 -> 193;
                case 84 -> 117;
                case 85 -> 120;
                case 86 -> 253;
                case 87 -> 65;
                case 88 -> 92;
                case 89 -> 38;
                case 90 -> 111;
                case 91 -> 91;
                case 92 -> 36;
                case 93 -> 15;
                case 94 -> 176;
                case 95 -> 10;
                case 96 -> 27;
                case 97 -> 97;
                case 98 -> 144;
                case 99 -> 200;
                case 100 -> 132;
                case 101 -> 50;
                case 102 -> 86;
                case 103 -> 6;
                case 104 -> 115;
                case 105 -> 210;
                case 106 -> 135;
                case 107 -> 30;
                case 108 -> 179;
                case 109 -> 4;
                case 110 -> 56;
                case 111 -> 192;
                case 112 -> 165;
                case 113 -> 90;
                case 114 -> 202;
                case 115 -> 161;
                case 116 -> 52;
                case 117 -> 17;
                case 118 -> 84;
                case 119 -> 83;
                case 120 -> 126;
                case 121 -> 166;
                case 122 -> 69;
                case 123 -> 102;
                case 124 -> 205;
                case 125 -> 114;
                case 126 -> 104;
                case 127 -> 154;
                case 128 -> 185;
                case 129 -> 147;
                case 130 -> 159;
                case 131 -> 250;
                case 132 -> 8;
                case 133 -> 184;
                case 134 -> 142;
                case 135 -> 149;
                case 136 -> 255;
                case 137 -> 14;
                case 138 -> 107;
                case 139 -> 182;
                case 140 -> 241;
                case 141 -> 1;
                case 142 -> 236;
                case 143 -> 212;
                case 144 -> 145;
                case 145 -> 78;
                case 146 -> 201;
                case 147 -> 140;
                case 148 -> 44;
                case 149 -> 16;
                case 150 -> 137;
                case 151 -> 29;
                case 152 -> 121;
                case 153 -> 127;
                case 154 -> 130;
                case 155 -> 243;
                case 156 -> 98;
                case 157 -> 109;
                case 158 -> 68;
                case 159 -> 197;
                case 160 -> 232;
                case 161 -> 76;
                case 162 -> 238;
                case 163 -> 167;
                case 164 -> 31;
                case 165 -> 194;
                case 166 -> 2;
                case 167 -> 180;
                case 168 -> 172;
                case 169 -> 122;
                case 170 -> 249;
                case 171 -> 157;
                case 172 -> 99;
                case 173 -> 225;
                case 174 -> 214;
                case 175 -> 174;
                case 176 -> 54;
                case 177 -> 143;
                case 178 -> 248;
                case 179 -> 235;
                case 180 -> 96;
                case 181 -> 21;
                case 182 -> 35;
                case 183 -> 195;
                case 184 -> 173;
                case 185 -> 26;
                case 186 -> 77;
                case 187 -> 251;
                case 188 -> 75;
                case 189 -> 244;
                case 190 -> 113;
                case 191 -> 105;
                case 192 -> 61;
                case 193 -> 151;
                case 194 -> 242;
                case 195 -> 162;
                case 196 -> 100;
                case 197 -> 93;
                case 198 -> 237;
                case 199 -> 221;
                case 200 -> 146;
                case 201 -> 252;
                case 202 -> 63;
                case 203 -> 28;
                case 204 -> 0;
                case 205 -> 82;
                case 206 -> 138;
                case 207 -> 226;
                case 208 -> 70;
                case 209 -> 18;
                case 210 -> 60;
                case 211 -> 124;
                case 212 -> 55;
                case 213 -> 46;
                case 214 -> 41;
                case 215 -> 23;
                case 216 -> 72;
                case 217 -> 19;
                case 218 -> 218;
                case 219 -> 177;
                case 220 -> 175;
                case 221 -> 106;
                case 222 -> 129;
                case 223 -> 188;
                case 224 -> 128;
                case 225 -> 217;
                case 226 -> 206;
                case 227 -> 215;
                case 228 -> 79;
                case 229 -> 164;
                case 230 -> 11;
                case 231 -> 169;
                case 232 -> 168;
                case 233 -> 220;
                case 234 -> 222;
                case 235 -> 20;
                case 236 -> 53;
                case 237 -> 74;
                case 238 -> 85;
                case 239 -> 66;
                case 240 -> 48;
                case 241 -> 33;
                case 242 -> 156;
                case 243 -> 196;
                case 244 -> 5;
                case 245 -> 216;
                case 246 -> 191;
                case 247 -> 152;
                case 248 -> 59;
                case 249 -> 108;
                case 250 -> 64;
                case 251 -> 89;
                case 252 -> 112;
                case 253 -> 239;
                case 254 -> 71;
                default -> 40;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 4351365541115L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-563732070 - -((char)-1722), 563601000 + (char)-10890, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l2 = 65078226093446L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.t();
                            try {
                                hANDLE2 = hANDLE;
                                if (bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-881576820 + -((char)-16144), 881707890 - (char)-12913, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-881576820 + -((char)-16147), -881707890 - -((char)-3131), (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-881576820 + -((char)-16146), 881707890 - (char)-5831, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "#\u0099\u00f22\u0091\u00b0\u00ef}\u0010+Y\u0002\u008b5<\u0082\u00b5c\u0000\u008a\u00c6\u00e8(\u0096`";
                    var4_3 = "#\u0099\u00f22\u0091\u00b0\u00ef}\u0010+Y\u0002\u008b5<\u0082\u00b5c\u0000\u008a\u00c6\u00e8(\u0096`".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 22;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u000f\u00ab\u00c6\u00c5\u00d65\u001f8\u00d3\u00db\u00a6\u00beY\u00ff\u00deC\u001e\u00df<P\u00b8TX\u009fq\u00a1\u00efY\u00ae\tm\u00be\u00cfX\u00ef\u00c4\u0082\u0018^\u000f\u00c5?\u00f9\u000f\u0099\u00f9\u00e3\u00f9\u00de\u0084\u00c6\u00c9\u00b6\u0093\u0082\u00e0\u0012>\u00fc";
                        var4_3 = "\u000f\u00ab\u00c6\u00c5\u00d65\u001f8\u00d3\u00db\u00a6\u00beY\u00ff\u00deC\u001e\u00df<P\u00b8TX\u009fq\u00a1\u00efY\u00ae\tm\u00be\u00cfX\u00ef\u00c4\u0082\u0018^\u000f\u00c5?\u00f9\u000f\u0099\u00f9\u00e3\u00f9\u00de\u0084\u00c6\u00c9\u00b6\u0093\u0082\u00e0\u0012>\u00fc".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 104;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 51;
                                break;
                            }
                            case 1: {
                                v15 = 86;
                                break;
                            }
                            case 2: {
                                v15 = 42;
                                break;
                            }
                            case 3: {
                                v15 = 62;
                                break;
                            }
                            case 4: {
                                v15 = 112;
                                break;
                            }
                            case 5: {
                                v15 = 77;
                                break;
                            }
                            default: {
                                v15 = 41;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFF61B) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 106;
                    case 1 -> 167;
                    case 2 -> 73;
                    case 3 -> 123;
                    case 4 -> 80;
                    case 5 -> 136;
                    case 6 -> 175;
                    case 7 -> 46;
                    case 8 -> 143;
                    case 9 -> 1;
                    case 10 -> 196;
                    case 11 -> 235;
                    case 12 -> 88;
                    case 13 -> 166;
                    case 14 -> 252;
                    case 15 -> 138;
                    case 16 -> 20;
                    case 17 -> 200;
                    case 18 -> 251;
                    case 19 -> 233;
                    case 20 -> 182;
                    case 21 -> 150;
                    case 22 -> 79;
                    case 23 -> 119;
                    case 24 -> 81;
                    case 25 -> 220;
                    case 26 -> 44;
                    case 27 -> 164;
                    case 28 -> 2;
                    case 29 -> 69;
                    case 30 -> 32;
                    case 31 -> 59;
                    case 32 -> 197;
                    case 33 -> 96;
                    case 34 -> 139;
                    case 35 -> 0;
                    case 36 -> 38;
                    case 37 -> 181;
                    case 38 -> 115;
                    case 39 -> 63;
                    case 40 -> 47;
                    case 41 -> 155;
                    case 42 -> 238;
                    case 43 -> 41;
                    case 44 -> 89;
                    case 45 -> 244;
                    case 46 -> 24;
                    case 47 -> 126;
                    case 48 -> 14;
                    case 49 -> 180;
                    case 50 -> 102;
                    case 51 -> 163;
                    case 52 -> 183;
                    case 53 -> 230;
                    case 54 -> 42;
                    case 55 -> 147;
                    case 56 -> 25;
                    case 57 -> 93;
                    case 58 -> 206;
                    case 59 -> 122;
                    case 60 -> 216;
                    case 61 -> 171;
                    case 62 -> 222;
                    case 63 -> 21;
                    case 64 -> 214;
                    case 65 -> 35;
                    case 66 -> 224;
                    case 67 -> 208;
                    case 68 -> 65;
                    case 69 -> 201;
                    case 70 -> 84;
                    case 71 -> 189;
                    case 72 -> 132;
                    case 73 -> 68;
                    case 74 -> 245;
                    case 75 -> 109;
                    case 76 -> 178;
                    case 77 -> 6;
                    case 78 -> 250;
                    case 79 -> 26;
                    case 80 -> 128;
                    case 81 -> 185;
                    case 82 -> 232;
                    case 83 -> 231;
                    case 84 -> 177;
                    case 85 -> 28;
                    case 86 -> 57;
                    case 87 -> 54;
                    case 88 -> 113;
                    case 89 -> 153;
                    case 90 -> 22;
                    case 91 -> 204;
                    case 92 -> 217;
                    case 93 -> 194;
                    case 94 -> 156;
                    case 95 -> 58;
                    case 96 -> 227;
                    case 97 -> 110;
                    case 98 -> 192;
                    case 99 -> 165;
                    case 100 -> 137;
                    case 101 -> 48;
                    case 102 -> 240;
                    case 103 -> 191;
                    case 104 -> 118;
                    case 105 -> 131;
                    case 106 -> 159;
                    case 107 -> 187;
                    case 108 -> 37;
                    case 109 -> 82;
                    case 110 -> 247;
                    case 111 -> 241;
                    case 112 -> 23;
                    case 113 -> 8;
                    case 114 -> 158;
                    case 115 -> 74;
                    case 116 -> 133;
                    case 117 -> 174;
                    case 118 -> 199;
                    case 119 -> 195;
                    case 120 -> 11;
                    case 121 -> 70;
                    case 122 -> 116;
                    case 123 -> 36;
                    case 124 -> 105;
                    case 125 -> 125;
                    case 126 -> 248;
                    case 127 -> 3;
                    case 128 -> 67;
                    case 129 -> 19;
                    case 130 -> 16;
                    case 131 -> 39;
                    case 132 -> 75;
                    case 133 -> 120;
                    case 134 -> 31;
                    case 135 -> 202;
                    case 136 -> 103;
                    case 137 -> 205;
                    case 138 -> 211;
                    case 139 -> 18;
                    case 140 -> 176;
                    case 141 -> 184;
                    case 142 -> 101;
                    case 143 -> 249;
                    case 144 -> 193;
                    case 145 -> 62;
                    case 146 -> 94;
                    case 147 -> 50;
                    case 148 -> 207;
                    case 149 -> 226;
                    case 150 -> 40;
                    case 151 -> 212;
                    case 152 -> 87;
                    case 153 -> 152;
                    case 154 -> 148;
                    case 155 -> 83;
                    case 156 -> 77;
                    case 157 -> 4;
                    case 158 -> 170;
                    case 159 -> 64;
                    case 160 -> 13;
                    case 161 -> 135;
                    case 162 -> 145;
                    case 163 -> 30;
                    case 164 -> 179;
                    case 165 -> 242;
                    case 166 -> 144;
                    case 167 -> 61;
                    case 168 -> 98;
                    case 169 -> 12;
                    case 170 -> 253;
                    case 171 -> 7;
                    case 172 -> 100;
                    case 173 -> 49;
                    case 174 -> 229;
                    case 175 -> 210;
                    case 176 -> 117;
                    case 177 -> 92;
                    case 178 -> 228;
                    case 179 -> 140;
                    case 180 -> 234;
                    case 181 -> 112;
                    case 182 -> 161;
                    case 183 -> 168;
                    case 184 -> 129;
                    case 185 -> 149;
                    case 186 -> 111;
                    case 187 -> 151;
                    case 188 -> 104;
                    case 189 -> 209;
                    case 190 -> 33;
                    case 191 -> 215;
                    case 192 -> 218;
                    case 193 -> 10;
                    case 194 -> 34;
                    case 195 -> 190;
                    case 196 -> 27;
                    case 197 -> 95;
                    case 198 -> 114;
                    case 199 -> 246;
                    case 200 -> 213;
                    case 201 -> 43;
                    case 202 -> 5;
                    case 203 -> 97;
                    case 204 -> 134;
                    case 205 -> 219;
                    case 206 -> 160;
                    case 207 -> 173;
                    case 208 -> 53;
                    case 209 -> 86;
                    case 210 -> 255;
                    case 211 -> 157;
                    case 212 -> 141;
                    case 213 -> 225;
                    case 214 -> 127;
                    case 215 -> 254;
                    case 216 -> 243;
                    case 217 -> 239;
                    case 218 -> 52;
                    case 219 -> 85;
                    case 220 -> 51;
                    case 221 -> 60;
                    case 222 -> 107;
                    case 223 -> 154;
                    case 224 -> 72;
                    case 225 -> 99;
                    case 226 -> 198;
                    case 227 -> 223;
                    case 228 -> 90;
                    case 229 -> 9;
                    case 230 -> 71;
                    case 231 -> 45;
                    case 232 -> 221;
                    case 233 -> 186;
                    case 234 -> 15;
                    case 235 -> 130;
                    case 236 -> 169;
                    case 237 -> 146;
                    case 238 -> 237;
                    case 239 -> 142;
                    case 240 -> 76;
                    case 241 -> 121;
                    case 242 -> 236;
                    case 243 -> 56;
                    case 244 -> 162;
                    case 245 -> 17;
                    case 246 -> 203;
                    case 247 -> 55;
                    case 248 -> 29;
                    case 249 -> 78;
                    case 250 -> 91;
                    case 251 -> 124;
                    case 252 -> 188;
                    case 253 -> 66;
                    case 254 -> 108;
                    default -> 172;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 21394083108186L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "`YT\f\u001b=\u00179\tgSG\u0006V\u007f\n%\u0015";
                    var5_4 = "`YT\f\u001b=\u00179\tgSG\u0006V\u007f\n%\u0015".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 121;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 114;
                                    break;
                                }
                                case 1: {
                                    v11 = 69;
                                    break;
                                }
                                case 2: {
                                    v11 = 95;
                                    break;
                                }
                                case 3: {
                                    v11 = 27;
                                    break;
                                }
                                case 4: {
                                    v11 = 7;
                                    break;
                                }
                                case 5: {
                                    v11 = 40;
                                    break;
                                }
                                default: {
                                    v11 = 93;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 56726380269394L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = " [P\u0003X>[\u0004&E\\\u0019\n*ZW\u0019T<C\u0000[^\t*ZW\u0019T<C\fQ\r-\\J\u0014^1Y\fVM\u001e_8";
                    var5_4 = " [P\u0003X>[\u0004&E\\\u0019\n*ZW\u0019T<C\u0000[^\t*ZW\u0019T<C\fQ\r-\\J\u0014^1Y\fVM\u001e_8".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 52;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "a\u0012\u001dO\u0013z\u001b\u0006a\u0012\u001dO\u001fp";
                        var5_4 = "a\u0012\u001dO\u0013z\u001b\u0006a\u0012\u001dO\u001fp".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 127;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 93;
                                break;
                            }
                            case 1: {
                                v15 = 1;
                                break;
                            }
                            case 2: {
                                v15 = 13;
                                break;
                            }
                            case 3: {
                                v15 = 67;
                                break;
                            }
                            case 4: {
                                v15 = 5;
                                break;
                            }
                            case 5: {
                                v15 = 107;
                                break;
                            }
                            default: {
                                v15 = 3;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 14679423078779L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-775147980 - -6263, -775147980 + -1880, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 111743899890426L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "x5\u0014c\u00aa\u0003q\u008d\u0081\u0005;\u00d1Z;\u0080\r\u00af\u0015\u00fe\u00e9\u00e1\u008a^\u00d9\u00a4\u00a2\u0091\u00ab\u0002\u0010n(\u0001\u00a5!\u0096mg\u000b\u00f1\u0087\u008c&\f\u00c8q\u0005\u008b\u007fL\u00eeB3N\f\u00e5\u00f7h\u0098t\u00b2U\u00b6\u00c7M\u00e8e=C\u00c2\u00d7\u0090v\u00a8\u0093\u0004\u00c2B\u009d\u001d\u00b6=\u0089\u00fd]\u00b5\u00df\u0084x\u000f\u00bfF [D\u00ee%\u00ab>\u00b0\u0099\u0017\u00a7t";
                    var4_3 = "x5\u0014c\u00aa\u0003q\u008d\u0081\u0005;\u00d1Z;\u0080\r\u00af\u0015\u00fe\u00e9\u00e1\u008a^\u00d9\u00a4\u00a2\u0091\u00ab\u0002\u0010n(\u0001\u00a5!\u0096mg\u000b\u00f1\u0087\u008c&\f\u00c8q\u0005\u008b\u007fL\u00eeB3N\f\u00e5\u00f7h\u0098t\u00b2U\u00b6\u00c7M\u00e8e=C\u00c2\u00d7\u0090v\u00a8\u0093\u0004\u00c2B\u009d\u001d\u00b6=\u0089\u00fd]\u00b5\u00df\u0084x\u000f\u00bfF [D\u00ee%\u00ab>\u00b0\u0099\u0017\u00a7t".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 63;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "C5>\u009c\\+XJ7\u00ce\u009a\u00f1\u001f9uML\u008dD\u0010x\u00b3\u007f\u00cb\u00ae\u00cc\u00c1I\u00a9k\u00bch\u0084\u00f7dSl\".\u00e5M\u00c7\u001d\u0012\u00fa\u00bc\u00d3\u00b8\u00e3\u0097|+\u008aR\u00a5M\u009f\u0096\u00d4\u0002\u00d0\u00b9\u00c4\u00a3d\u001d\u00b6G\u00e0\u0017\u00b5\u000b\u0010\u00ec\u00e6\u00ab#\u00c0\u009fs?\u009b\u00ea\u00aa\u00b2}$\u00fcG\u008a#\u00f1\u0013";
                        var4_3 = "C5>\u009c\\+XJ7\u00ce\u009a\u00f1\u001f9uML\u008dD\u0010x\u00b3\u007f\u00cb\u00ae\u00cc\u00c1I\u00a9k\u00bch\u0084\u00f7dSl\".\u00e5M\u00c7\u001d\u0012\u00fa\u00bc\u00d3\u00b8\u00e3\u0097|+\u008aR\u00a5M\u009f\u0096\u00d4\u0002\u00d0\u00b9\u00c4\u00a3d\u001d\u00b6G\u00e0\u0017\u00b5\u000b\u0010\u00ec\u00e6\u00ab#\u00c0\u009fs?\u009b\u00ea\u00aa\u00b2}$\u00fcG\u008a#\u00f1\u0013".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 2;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 92;
                                break;
                            }
                            case 1: {
                                v15 = 39;
                                break;
                            }
                            case 2: {
                                v15 = 96;
                                break;
                            }
                            case 3: {
                                v15 = 28;
                                break;
                            }
                            case 4: {
                                v15 = 65;
                                break;
                            }
                            case 5: {
                                v15 = 106;
                                break;
                            }
                            default: {
                                v15 = 110;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x17D0) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 230;
                    case 1 -> 46;
                    case 2 -> 83;
                    case 3 -> 65;
                    case 4 -> 113;
                    case 5 -> 128;
                    case 6 -> 18;
                    case 7 -> 161;
                    case 8 -> 211;
                    case 9 -> 8;
                    case 10 -> 56;
                    case 11 -> 133;
                    case 12 -> 169;
                    case 13 -> 213;
                    case 14 -> 188;
                    case 15 -> 242;
                    case 16 -> 40;
                    case 17 -> 148;
                    case 18 -> 145;
                    case 19 -> 200;
                    case 20 -> 25;
                    case 21 -> 60;
                    case 22 -> 12;
                    case 23 -> 64;
                    case 24 -> 139;
                    case 25 -> 144;
                    case 26 -> 147;
                    case 27 -> 45;
                    case 28 -> 164;
                    case 29 -> 138;
                    case 30 -> 39;
                    case 31 -> 50;
                    case 32 -> 149;
                    case 33 -> 36;
                    case 34 -> 103;
                    case 35 -> 217;
                    case 36 -> 5;
                    case 37 -> 160;
                    case 38 -> 11;
                    case 39 -> 16;
                    case 40 -> 223;
                    case 41 -> 17;
                    case 42 -> 157;
                    case 43 -> 162;
                    case 44 -> 95;
                    case 45 -> 130;
                    case 46 -> 222;
                    case 47 -> 206;
                    case 48 -> 184;
                    case 49 -> 165;
                    case 50 -> 69;
                    case 51 -> 253;
                    case 52 -> 185;
                    case 53 -> 189;
                    case 54 -> 35;
                    case 55 -> 78;
                    case 56 -> 210;
                    case 57 -> 251;
                    case 58 -> 135;
                    case 59 -> 30;
                    case 60 -> 92;
                    case 61 -> 178;
                    case 62 -> 154;
                    case 63 -> 88;
                    case 64 -> 192;
                    case 65 -> 37;
                    case 66 -> 240;
                    case 67 -> 111;
                    case 68 -> 181;
                    case 69 -> 233;
                    case 70 -> 205;
                    case 71 -> 197;
                    case 72 -> 23;
                    case 73 -> 176;
                    case 74 -> 179;
                    case 75 -> 123;
                    case 76 -> 224;
                    case 77 -> 66;
                    case 78 -> 29;
                    case 79 -> 58;
                    case 80 -> 62;
                    case 81 -> 232;
                    case 82 -> 170;
                    case 83 -> 33;
                    case 84 -> 140;
                    case 85 -> 195;
                    case 86 -> 219;
                    case 87 -> 59;
                    case 88 -> 97;
                    case 89 -> 48;
                    case 90 -> 85;
                    case 91 -> 204;
                    case 92 -> 119;
                    case 93 -> 1;
                    case 94 -> 199;
                    case 95 -> 209;
                    case 96 -> 193;
                    case 97 -> 122;
                    case 98 -> 255;
                    case 99 -> 53;
                    case 100 -> 156;
                    case 101 -> 129;
                    case 102 -> 112;
                    case 103 -> 3;
                    case 104 -> 109;
                    case 105 -> 116;
                    case 106 -> 42;
                    case 107 -> 207;
                    case 108 -> 43;
                    case 109 -> 7;
                    case 110 -> 136;
                    case 111 -> 134;
                    case 112 -> 190;
                    case 113 -> 70;
                    case 114 -> 115;
                    case 115 -> 15;
                    case 116 -> 54;
                    case 117 -> 75;
                    case 118 -> 228;
                    case 119 -> 38;
                    case 120 -> 246;
                    case 121 -> 175;
                    case 122 -> 89;
                    case 123 -> 137;
                    case 124 -> 180;
                    case 125 -> 196;
                    case 126 -> 227;
                    case 127 -> 187;
                    case 128 -> 74;
                    case 129 -> 106;
                    case 130 -> 141;
                    case 131 -> 163;
                    case 132 -> 132;
                    case 133 -> 105;
                    case 134 -> 104;
                    case 135 -> 236;
                    case 136 -> 171;
                    case 137 -> 77;
                    case 138 -> 86;
                    case 139 -> 13;
                    case 140 -> 125;
                    case 141 -> 10;
                    case 142 -> 22;
                    case 143 -> 31;
                    case 144 -> 158;
                    case 145 -> 2;
                    case 146 -> 126;
                    case 147 -> 102;
                    case 148 -> 61;
                    case 149 -> 94;
                    case 150 -> 27;
                    case 151 -> 57;
                    case 152 -> 19;
                    case 153 -> 87;
                    case 154 -> 9;
                    case 155 -> 21;
                    case 156 -> 186;
                    case 157 -> 218;
                    case 158 -> 194;
                    case 159 -> 44;
                    case 160 -> 49;
                    case 161 -> 174;
                    case 162 -> 131;
                    case 163 -> 82;
                    case 164 -> 6;
                    case 165 -> 241;
                    case 166 -> 143;
                    case 167 -> 0;
                    case 168 -> 79;
                    case 169 -> 4;
                    case 170 -> 110;
                    case 171 -> 81;
                    case 172 -> 239;
                    case 173 -> 47;
                    case 174 -> 252;
                    case 175 -> 107;
                    case 176 -> 225;
                    case 177 -> 76;
                    case 178 -> 177;
                    case 179 -> 191;
                    case 180 -> 73;
                    case 181 -> 124;
                    case 182 -> 118;
                    case 183 -> 152;
                    case 184 -> 32;
                    case 185 -> 226;
                    case 186 -> 231;
                    case 187 -> 28;
                    case 188 -> 151;
                    case 189 -> 93;
                    case 190 -> 168;
                    case 191 -> 34;
                    case 192 -> 72;
                    case 193 -> 68;
                    case 194 -> 71;
                    case 195 -> 41;
                    case 196 -> 250;
                    case 197 -> 55;
                    case 198 -> 173;
                    case 199 -> 120;
                    case 200 -> 67;
                    case 201 -> 26;
                    case 202 -> 237;
                    case 203 -> 249;
                    case 204 -> 14;
                    case 205 -> 51;
                    case 206 -> 80;
                    case 207 -> 121;
                    case 208 -> 245;
                    case 209 -> 182;
                    case 210 -> 90;
                    case 211 -> 202;
                    case 212 -> 229;
                    case 213 -> 208;
                    case 214 -> 243;
                    case 215 -> 63;
                    case 216 -> 150;
                    case 217 -> 24;
                    case 218 -> 52;
                    case 219 -> 247;
                    case 220 -> 212;
                    case 221 -> 183;
                    case 222 -> 159;
                    case 223 -> 215;
                    case 224 -> 101;
                    case 225 -> 216;
                    case 226 -> 220;
                    case 227 -> 244;
                    case 228 -> 238;
                    case 229 -> 234;
                    case 230 -> 167;
                    case 231 -> 166;
                    case 232 -> 172;
                    case 233 -> 221;
                    case 234 -> 100;
                    case 235 -> 146;
                    case 236 -> 91;
                    case 237 -> 114;
                    case 238 -> 98;
                    case 239 -> 20;
                    case 240 -> 201;
                    case 241 -> 248;
                    case 242 -> 117;
                    case 243 -> 84;
                    case 244 -> 235;
                    case 245 -> 254;
                    case 246 -> 153;
                    case 247 -> 155;
                    case 248 -> 203;
                    case 249 -> 99;
                    case 250 -> 96;
                    case 251 -> 142;
                    case 252 -> 214;
                    case 253 -> 127;
                    case 254 -> 108;
                    default -> 198;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 118194079462234L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(874367970 + (char)-14258, 874367970 + (char)-13012, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 68669487526666L;
                    boolean bl = SshAgentIpcService.P();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1550427030 - 20277, 1550427030 - 24593, (int)l2));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (!bl2) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 62213286617467L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00aa\u00861\u001b\u008a\u0003\u00ce\u00ee\u00eb";
                var4_3 = "\u00aa\u00861\u001b\u008a\u0003\u00ce\u00ee\u00eb".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 30;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 111;
                                break;
                            }
                            case 1: {
                                v11 = 47;
                                break;
                            }
                            case 2: {
                                v11 = 124;
                                break;
                            }
                            case 3: {
                                v11 = 22;
                                break;
                            }
                            case 4: {
                                v11 = 67;
                                break;
                            }
                            case 5: {
                                v11 = 113;
                                break;
                            }
                            default: {
                                v11 = 123;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x676A) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 231;
                    case 1 -> 171;
                    case 2 -> 109;
                    case 3 -> 181;
                    case 4 -> 188;
                    case 5 -> 4;
                    case 6 -> 227;
                    case 7 -> 100;
                    case 8 -> 223;
                    case 9 -> 99;
                    case 10 -> 175;
                    case 11 -> 177;
                    case 12 -> 61;
                    case 13 -> 55;
                    case 14 -> 76;
                    case 15 -> 184;
                    case 16 -> 117;
                    case 17 -> 216;
                    case 18 -> 207;
                    case 19 -> 135;
                    case 20 -> 150;
                    case 21 -> 40;
                    case 22 -> 34;
                    case 23 -> 254;
                    case 24 -> 196;
                    case 25 -> 221;
                    case 26 -> 72;
                    case 27 -> 96;
                    case 28 -> 45;
                    case 29 -> 125;
                    case 30 -> 7;
                    case 31 -> 191;
                    case 32 -> 232;
                    case 33 -> 189;
                    case 34 -> 165;
                    case 35 -> 12;
                    case 36 -> 104;
                    case 37 -> 246;
                    case 38 -> 228;
                    case 39 -> 95;
                    case 40 -> 200;
                    case 41 -> 54;
                    case 42 -> 75;
                    case 43 -> 215;
                    case 44 -> 179;
                    case 45 -> 20;
                    case 46 -> 176;
                    case 47 -> 51;
                    case 48 -> 240;
                    case 49 -> 152;
                    case 50 -> 94;
                    case 51 -> 87;
                    case 52 -> 128;
                    case 53 -> 159;
                    case 54 -> 213;
                    case 55 -> 170;
                    case 56 -> 103;
                    case 57 -> 85;
                    case 58 -> 69;
                    case 59 -> 244;
                    case 60 -> 236;
                    case 61 -> 44;
                    case 62 -> 208;
                    case 63 -> 77;
                    case 64 -> 112;
                    case 65 -> 122;
                    case 66 -> 123;
                    case 67 -> 185;
                    case 68 -> 49;
                    case 69 -> 9;
                    case 70 -> 124;
                    case 71 -> 127;
                    case 72 -> 203;
                    case 73 -> 27;
                    case 74 -> 19;
                    case 75 -> 78;
                    case 76 -> 58;
                    case 77 -> 35;
                    case 78 -> 138;
                    case 79 -> 5;
                    case 80 -> 239;
                    case 81 -> 102;
                    case 82 -> 218;
                    case 83 -> 233;
                    case 84 -> 86;
                    case 85 -> 115;
                    case 86 -> 206;
                    case 87 -> 146;
                    case 88 -> 68;
                    case 89 -> 224;
                    case 90 -> 120;
                    case 91 -> 33;
                    case 92 -> 155;
                    case 93 -> 133;
                    case 94 -> 1;
                    case 95 -> 164;
                    case 96 -> 255;
                    case 97 -> 25;
                    case 98 -> 57;
                    case 99 -> 142;
                    case 100 -> 147;
                    case 101 -> 10;
                    case 102 -> 174;
                    case 103 -> 36;
                    case 104 -> 144;
                    case 105 -> 26;
                    case 106 -> 210;
                    case 107 -> 190;
                    case 108 -> 52;
                    case 109 -> 225;
                    case 110 -> 111;
                    case 111 -> 16;
                    case 112 -> 251;
                    case 113 -> 47;
                    case 114 -> 248;
                    case 115 -> 212;
                    case 116 -> 162;
                    case 117 -> 23;
                    case 118 -> 0;
                    case 119 -> 235;
                    case 120 -> 97;
                    case 121 -> 134;
                    case 122 -> 66;
                    case 123 -> 2;
                    case 124 -> 226;
                    case 125 -> 252;
                    case 126 -> 84;
                    case 127 -> 114;
                    case 128 -> 217;
                    case 129 -> 130;
                    case 130 -> 64;
                    case 131 -> 121;
                    case 132 -> 126;
                    case 133 -> 241;
                    case 134 -> 71;
                    case 135 -> 74;
                    case 136 -> 140;
                    case 137 -> 250;
                    case 138 -> 173;
                    case 139 -> 73;
                    case 140 -> 166;
                    case 141 -> 156;
                    case 142 -> 237;
                    case 143 -> 234;
                    case 144 -> 193;
                    case 145 -> 194;
                    case 146 -> 141;
                    case 147 -> 192;
                    case 148 -> 101;
                    case 149 -> 15;
                    case 150 -> 214;
                    case 151 -> 137;
                    case 152 -> 151;
                    case 153 -> 107;
                    case 154 -> 105;
                    case 155 -> 131;
                    case 156 -> 153;
                    case 157 -> 50;
                    case 158 -> 139;
                    case 159 -> 56;
                    case 160 -> 205;
                    case 161 -> 238;
                    case 162 -> 169;
                    case 163 -> 247;
                    case 164 -> 17;
                    case 165 -> 79;
                    case 166 -> 145;
                    case 167 -> 6;
                    case 168 -> 24;
                    case 169 -> 37;
                    case 170 -> 253;
                    case 171 -> 219;
                    case 172 -> 21;
                    case 173 -> 43;
                    case 174 -> 230;
                    case 175 -> 172;
                    case 176 -> 108;
                    case 177 -> 3;
                    case 178 -> 183;
                    case 179 -> 39;
                    case 180 -> 163;
                    case 181 -> 149;
                    case 182 -> 22;
                    case 183 -> 242;
                    case 184 -> 198;
                    case 185 -> 30;
                    case 186 -> 48;
                    case 187 -> 119;
                    case 188 -> 243;
                    case 189 -> 113;
                    case 190 -> 38;
                    case 191 -> 195;
                    case 192 -> 18;
                    case 193 -> 106;
                    case 194 -> 249;
                    case 195 -> 65;
                    case 196 -> 8;
                    case 197 -> 245;
                    case 198 -> 11;
                    case 199 -> 187;
                    case 200 -> 161;
                    case 201 -> 186;
                    case 202 -> 197;
                    case 203 -> 220;
                    case 204 -> 42;
                    case 205 -> 91;
                    case 206 -> 178;
                    case 207 -> 182;
                    case 208 -> 167;
                    case 209 -> 29;
                    case 210 -> 90;
                    case 211 -> 31;
                    case 212 -> 98;
                    case 213 -> 82;
                    case 214 -> 222;
                    case 215 -> 60;
                    case 216 -> 13;
                    case 217 -> 93;
                    case 218 -> 62;
                    case 219 -> 154;
                    case 220 -> 180;
                    case 221 -> 67;
                    case 222 -> 209;
                    case 223 -> 202;
                    case 224 -> 118;
                    case 225 -> 160;
                    case 226 -> 80;
                    case 227 -> 14;
                    case 228 -> 28;
                    case 229 -> 136;
                    case 230 -> 83;
                    case 231 -> 199;
                    case 232 -> 129;
                    case 233 -> 148;
                    case 234 -> 116;
                    case 235 -> 88;
                    case 236 -> 211;
                    case 237 -> 157;
                    case 238 -> 70;
                    case 239 -> 92;
                    case 240 -> 46;
                    case 241 -> 59;
                    case 242 -> 63;
                    case 243 -> 32;
                    case 244 -> 229;
                    case 245 -> 158;
                    case 246 -> 41;
                    case 247 -> 53;
                    case 248 -> 201;
                    case 249 -> 132;
                    case 250 -> 89;
                    case 251 -> 204;
                    case 252 -> 143;
                    case 253 -> 168;
                    case 254 -> 81;
                    default -> 110;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

