/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMRootTestProxyFormatter;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.TestTreeRenderer;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.ide.browsers.OpenUrlHyperlinkInfo;
import com.intellij.javascript.debugger.JSDebugTabLayouter;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.karma.KarmaBundle;
import com.intellij.javascript.karma.execution.KarmaExecutionType;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.KarmaServerLogComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.connection.VmConnection;

public class KarmaConsoleView
extends SMTRunnerConsoleView
implements ExecutionConsoleEx {
    private static final Logger LOG = Logger.getInstance(KarmaConsoleView.class);
    private static final String TEST_RUN_CONTENT_ID = "ConsoleContent";
    private final KarmaServer myServer;
    private final KarmaExecutionType myExecutionType;
    private final ProcessHandler myProcessHandler;

    public KarmaConsoleView(@NotNull TestConsoleProperties consoleProperties, @NotNull KarmaServer server, @NotNull KarmaExecutionType executionType, @NotNull ProcessHandler processHandler) {
        if (consoleProperties == null) {
            KarmaConsoleView.$$$reportNull$$$0(0);
        }
        if (server == null) {
            KarmaConsoleView.$$$reportNull$$$0(1);
        }
        if (executionType == null) {
            KarmaConsoleView.$$$reportNull$$$0(2);
        }
        if (processHandler == null) {
            KarmaConsoleView.$$$reportNull$$$0(3);
        }
        super(consoleProperties);
        this.myServer = server;
        this.myExecutionType = executionType;
        this.myProcessHandler = processHandler;
    }

    public void buildUi(@NotNull RunnerLayoutUi ui) {
        if (ui == null) {
            KarmaConsoleView.$$$reportNull$$$0(4);
        }
        this.registerConsoleContent(ui);
        this.registerKarmaServerTab(ui);
    }

    @Nullable
    public String getExecutionConsoleId() {
        return null;
    }

    @NotNull
    private Content registerConsoleContent(@NotNull RunnerLayoutUi ui) {
        if (ui == null) {
            KarmaConsoleView.$$$reportNull$$$0(5);
        }
        ui.getOptions().setMinimizeActionEnabled(false);
        Content consoleContent = ui.createContent(TEST_RUN_CONTENT_ID, this.getComponent(), KarmaBundle.message("console.test_run_tab.name", new Object[0]), null, this.getPreferredFocusableComponent());
        ui.addContent(consoleContent, 1, PlaceInGrid.bottom, false);
        consoleContent.setCloseable(false);
        if (!this.myServer.areBrowsersReady()) {
            this.registerPrintingBrowserCapturingSuggestion();
        }
        if (this.myProcessHandler instanceof NopProcessHandler) {
            final KarmaRootTestProxyFormatter rootFormatter = new KarmaRootTestProxyFormatter(this);
            this.myProcessHandler.addProcessListener(new ProcessListener(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)KarmaConsoleView.this);
                    alarm.addRequest(() -> {
                        rootFormatter.onTestRunProcessTerminated();
                        Disposer.dispose((Disposable)alarm);
                    }, 200);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/execution/KarmaConsoleView$1", "processTerminated"));
                }
            }, (Disposable)this);
        }
        this.myServer.getProcessHandler().addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!KarmaConsoleView.this.myProcessHandler.isProcessTerminated()) {
                    KarmaConsoleView.this.print("Karma server terminated\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/execution/KarmaConsoleView$2", "processTerminated"));
            }
        }, (Disposable)this);
        Content content = consoleContent;
        if (content == null) {
            KarmaConsoleView.$$$reportNull$$$0(6);
        }
        return content;
    }

    private void registerPrintingBrowserCapturingSuggestion() {
        if (this.myExecutionType == KarmaExecutionType.DEBUG) {
            return;
        }
        this.myServer.onPortBound(() -> {
            if (Disposer.isDisposed((Disposable)this)) {
                return;
            }
            Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
            alarm.addRequest(() -> {
                if (!this.myProcessHandler.isProcessTerminated()) {
                    this.getResultsViewer().getTestsRootNode().addLast(printer -> {
                        printer.print("To capture a browser open ", ConsoleViewContentType.SYSTEM_OUTPUT);
                        String url = this.myServer.formatUrl("/");
                        printer.printHyperlink(url, (HyperlinkInfo)new OpenUrlHyperlinkInfo(url));
                        printer.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                    });
                }
                Disposer.dispose((Disposable)alarm);
            }, 1000, ModalityState.any());
            this.myServer.onBrowsersReady(() -> Disposer.dispose((Disposable)alarm));
        });
    }

    private void registerKarmaServerTab(@NotNull RunnerLayoutUi ui) {
        if (ui == null) {
            KarmaConsoleView.$$$reportNull$$$0(7);
        }
        KarmaServerLogComponent.register(this.getProperties().getProject(), this.myServer, ui);
        if (this.myServer.areBrowsersReady()) {
            KarmaConsoleView.selectContentId(ui, TEST_RUN_CONTENT_ID);
        } else {
            KarmaConsoleView.selectContentId(ui, "KarmaServer");
            this.myServer.onBrowsersReady(() -> KarmaConsoleView.selectContentId(ui, TEST_RUN_CONTENT_ID));
        }
    }

    private static void selectContentId(@NotNull RunnerLayoutUi ui, @NotNull String contentId) {
        if (ui == null) {
            KarmaConsoleView.$$$reportNull$$$0(8);
        }
        if (contentId == null) {
            KarmaConsoleView.$$$reportNull$$$0(9);
        }
        if (!ui.isDisposed()) {
            Content content = ui.findContent(contentId);
            if (content != null) {
                ui.selectAndFocus(content, false, false);
            } else {
                LOG.warn("Cannot find content for " + contentId);
            }
        }
    }

    @NotNull
    public KarmaServer getKarmaServer() {
        KarmaServer karmaServer = this.myServer;
        if (karmaServer == null) {
            KarmaConsoleView.$$$reportNull$$$0(10);
        }
        return karmaServer;
    }

    public JSDebugTabLayouter createDebugLayouter(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        if (debugProcess == null) {
            KarmaConsoleView.$$$reportNull$$$0(11);
        }
        return new KarmaDebugTabLayouter(debugProcess);
    }

    @Nullable
    public static KarmaConsoleView get(@NotNull ExecutionResult result, @NotNull RunProfileState state) {
        ExecutionConsole console;
        if (result == null) {
            KarmaConsoleView.$$$reportNull$$$0(12);
        }
        if (state == null) {
            KarmaConsoleView.$$$reportNull$$$0(13);
        }
        if ((console = result.getExecutionConsole()) instanceof KarmaConsoleView) {
            return (KarmaConsoleView)console;
        }
        Class consoleClass = console != null ? console.getClass() : null;
        LOG.info("Cannot cast " + String.valueOf(consoleClass) + " to " + KarmaConsoleView.class.getSimpleName() + ", RunProfileState: " + state.getClass().getName());
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaConsoleView";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaConsoleView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "registerConsoleContent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getKarmaServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildUi";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerConsoleContent";
                break;
            }
            case 6: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerKarmaServerTab";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "selectContentId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDebugLayouter";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10 -> new IllegalStateException(string);
        };
    }

    private static final class KarmaRootTestProxyFormatter
    implements SMRootTestProxyFormatter {
        private final TestTreeView myTreeView;
        private boolean myTestRunProcessTerminated;

        private KarmaRootTestProxyFormatter(@NotNull SMTRunnerConsoleView consoleView) {
            TestTreeRenderer originalRenderer;
            if (consoleView == null) {
                KarmaRootTestProxyFormatter.$$$reportNull$$$0(0);
            }
            this.myTestRunProcessTerminated = false;
            this.myTreeView = consoleView.getResultsViewer().getTreeView();
            if (this.myTreeView != null && (originalRenderer = (TestTreeRenderer)ObjectUtils.tryCast((Object)this.myTreeView.getCellRenderer(), TestTreeRenderer.class)) != null) {
                originalRenderer.setAdditionalRootFormatter((SMRootTestProxyFormatter)this);
            }
        }

        private static void render(@NotNull TestTreeRenderer renderer, @NotNull @Nls String msg) {
            if (renderer == null) {
                KarmaRootTestProxyFormatter.$$$reportNull$$$0(1);
            }
            if (msg == null) {
                KarmaRootTestProxyFormatter.$$$reportNull$$$0(2);
            }
            renderer.clear();
            renderer.append(msg);
        }

        public void format(@NotNull SMTestProxy.SMRootTestProxy testProxy, @NotNull TestTreeRenderer renderer) {
            if (testProxy == null) {
                KarmaRootTestProxyFormatter.$$$reportNull$$$0(3);
            }
            if (renderer == null) {
                KarmaRootTestProxyFormatter.$$$reportNull$$$0(4);
            }
            if (testProxy.isLeaf()) {
                KarmaRootTestProxyFormatter.render(renderer, this.myTestRunProcessTerminated ? KarmaBundle.message("test.run.process_terminated.text", new Object[0]) : KarmaBundle.message("test.run.waiting_for_browser_capturing.text", new Object[0]));
            }
        }

        private void onTestRunProcessTerminated() {
            this.myTestRunProcessTerminated = true;
            this.myTreeView.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleView";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "msg";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testProxy";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaConsoleView$KarmaRootTestProxyFormatter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "format";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class KarmaDebugTabLayouter
    extends JSDebugTabLayouter {
        KarmaDebugTabLayouter(JavaScriptDebugProcess<? extends VmConnection> debugProcess) {
            if (debugProcess == null) {
                KarmaDebugTabLayouter.$$$reportNull$$$0(0);
            }
            super(debugProcess);
        }

        @NotNull
        public Content registerConsoleContent(@NotNull RunnerLayoutUi ui, @NotNull ExecutionConsole console) {
            if (ui == null) {
                KarmaDebugTabLayouter.$$$reportNull$$$0(1);
            }
            if (console == null) {
                KarmaDebugTabLayouter.$$$reportNull$$$0(2);
            }
            Content content = KarmaConsoleView.this.registerConsoleContent(ui);
            if (content == null) {
                KarmaDebugTabLayouter.$$$reportNull$$$0(3);
            }
            return content;
        }

        public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
            if (ui == null) {
                KarmaDebugTabLayouter.$$$reportNull$$$0(4);
            }
            super.registerAdditionalContent(ui);
            KarmaConsoleView.this.registerKarmaServerTab(ui);
            ui.getDefaults().initContentAttraction(KarmaConsoleView.this.myServer.areBrowsersReady() ? KarmaConsoleView.TEST_RUN_CONTENT_ID : "KarmaServer", "startup", (LayoutAttractionPolicy)new LayoutAttractionPolicy.FocusOnce(false));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugProcess";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaConsoleView$KarmaDebugTabLayouter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaConsoleView$KarmaDebugTabLayouter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "registerConsoleContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "registerConsoleContent";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "registerAdditionalContent";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

