/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.trace.consent;

import com.intellij.ide.IdleTracker;
import com.intellij.ide.gdpr.ConsentConfigurable;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.DataCollectionAgreement;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.idea.AppMode;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.trace.consent.JBTraceConsentManager;
import com.intellij.platform.trace.consent.LicenseAwareTraceDataSharingService;
import com.intellij.platform.trace.consent.LicenseAwareTraceDataSharingServiceKt;
import com.intellij.platform.trace.consent.TraceConsentBundle;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002J\b\u0010\u0018\u001a\u00020\fH\u0002J\b\u0010\u0019\u001a\u00020\fH\u0002J\b\u0010\u001a\u001a\u00020\fH\u0002J\u001e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/intellij/platform/trace/consent/LicenseAwareTraceDataSharingService;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "isNotificationNeeded", "", "()Z", "onLicenseStateChanged", "", "licensingFacade", "Lcom/intellij/ui/LicensingFacade;", "onLicenseStateChanged$intellij_platform_trace_consent", "notifyAboutTraceDataCollectionForCommercialIfNeeded", "licenseTypeFlag", "", "enableTraceDataCollectionForNonCommercialIfNeeded", "notifyAboutInternalTraceDataCollectionIfNeeded", "userEmail", "", "notifyAboutEnabledTraceDataCollectionForOrganizationIfNeeded", "askForCommercialDataCollection", "askForNonCommercialDataCollection", "askForInternalDataCollection", "runOncePerAppWithIdleTracker", "taskId", "block", "Lkotlin/Function0;", "intellij.platform.trace.consent"})
public final class LicenseAwareTraceDataSharingService {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    private final boolean isNotificationNeeded;

    public LicenseAwareTraceDataSharingService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.isNotificationNeeded = !AppMode.isRunningFromDevBuild() && !PluginManagerCore.isRunningFromSources() && !ApplicationKt.getApplication().isUnitTestMode() && !ApplicationKt.getApplication().isHeadlessEnvironment() && !ApplicationKt.getApplication().isCommandLine() && !DebugAttachDetector.isAttached() && Registry.Companion.is("ide.enable.notification.trace.data.sharing") && new JBTraceConsentManager().isTraceConsentEnabled();
    }

    public final boolean isNotificationNeeded() {
        return this.isNotificationNeeded;
    }

    public final void onLicenseStateChanged$intellij_platform_trace_consent(@Nullable LicensingFacade licensingFacade) {
        if (this.isNotificationNeeded) {
            Object object = licensingFacade;
            if (object == null || (object = ((LicensingFacade)object).metadata) == null || (object = StringsKt.getOrNull((CharSequence)((CharSequence)object), (int)10)) == null) {
                return;
            }
            char licenseTypeFlag = ((Character)object).charValue();
            this.notifyAboutTraceDataCollectionForCommercialIfNeeded(licenseTypeFlag);
            this.enableTraceDataCollectionForNonCommercialIfNeeded(licenseTypeFlag);
            String string = licensingFacade.licenseeEmail;
            if (string == null) {
                string = "";
            }
            this.notifyAboutInternalTraceDataCollectionIfNeeded(licenseTypeFlag, string);
            this.notifyAboutEnabledTraceDataCollectionForOrganizationIfNeeded();
        }
    }

    private final void notifyAboutTraceDataCollectionForCommercialIfNeeded(char licenseTypeFlag) {
        if (!LicenseAwareTraceDataSharingServiceKt.isNonCommercialLicense(licenseTypeFlag) && ConsentOptions.getInstance().getTraceDataCollectionComPermission() == ConsentOptions.Permission.UNDEFINED && ConsentOptions.getInstance().getTraceDataCollectionNonComPermission() == ConsentOptions.Permission.YES) {
            this.runOncePerAppWithIdleTracker("trace.commercial.popup.id", (Function0<Unit>)((Function0)() -> LicenseAwareTraceDataSharingService.notifyAboutTraceDataCollectionForCommercialIfNeeded$lambda$0(this)));
        }
    }

    private final void enableTraceDataCollectionForNonCommercialIfNeeded(char licenseTypeFlag) {
        if (LicenseAwareTraceDataSharingServiceKt.isNonCommercialLicense(licenseTypeFlag) && ConsentOptions.getInstance().getTraceDataCollectionNonComPermission() == ConsentOptions.Permission.UNDEFINED) {
            this.runOncePerAppWithIdleTracker("trace.non.commercial.popup.id", (Function0<Unit>)((Function0)() -> LicenseAwareTraceDataSharingService.enableTraceDataCollectionForNonCommercialIfNeeded$lambda$0(this)));
        }
    }

    private final void notifyAboutInternalTraceDataCollectionIfNeeded(char licenseTypeFlag, String userEmail) {
        if (LicenseAwareTraceDataSharingServiceKt.isInternalUser(userEmail) && !LicenseAwareTraceDataSharingServiceKt.isNonCommercialLicense(licenseTypeFlag) && ConsentOptions.getInstance().getTraceDataCollectionComPermission() == ConsentOptions.Permission.UNDEFINED) {
            this.runOncePerAppWithIdleTracker("trace.internal.popup.id", (Function0<Unit>)((Function0)() -> LicenseAwareTraceDataSharingService.notifyAboutInternalTraceDataCollectionIfNeeded$lambda$0(this)));
        }
    }

    private final void notifyAboutEnabledTraceDataCollectionForOrganizationIfNeeded() {
        if (DataCollectionAgreement.Companion.getInstance() == DataCollectionAgreement.YES) {
            this.runOncePerAppWithIdleTracker("trace.organizational.enabled.popup.id", (Function0<Unit>)((Function0)() -> LicenseAwareTraceDataSharingService.notifyAboutEnabledTraceDataCollectionForOrganizationIfNeeded$lambda$0(this)));
        }
    }

    private final void askForCommercialDataCollection() {
        Object[] objectArray = new Object[]{LicenseAwareTraceDataSharingServiceKt.access$getTRACE_RELEASE_VERSION$p()};
        MessageDialogBuilder.YesNo messageDialog = MessageDialogBuilder.Companion.yesNo(TraceConsentBundle.message("notification.trace.data.sharing.commercial.title", new Object[0]), TraceConsentBundle.message("notification.trace.data.sharing.commercial.text", objectArray));
        messageDialog.yesText(TraceConsentBundle.message("notification.trace.data.sharing.yes", new Object[0]));
        ConsentOptions.getInstance().setTraceDataCollectionComPermission(messageDialog.ask(this.project));
    }

    private final void askForNonCommercialDataCollection() {
        Object[] objectArray = new Object[]{LicenseAwareTraceDataSharingServiceKt.access$getTRACE_RELEASE_VERSION$p()};
        MessageDialogBuilder.YesNo messageDialog = MessageDialogBuilder.Companion.yesNo(TraceConsentBundle.message("notification.trace.data.sharing.non.commercial.title", new Object[0]), TraceConsentBundle.message("notification.trace.data.sharing.non.commercial.text", objectArray));
        messageDialog.yesText(TraceConsentBundle.message("notification.trace.data.sharing.ok", new Object[0]));
        messageDialog.noText(TraceConsentBundle.message("notification.trace.data.sharing.adjust.settings", new Object[0]));
        boolean shouldOpenSettings = !messageDialog.ask(this.project);
        ConsentOptions.getInstance().setTraceDataCollectionNonComPermission(true);
        if (shouldOpenSettings) {
            ShowSettingsUtil.getInstance().showSettingsDialog(this.project, ConsentConfigurable.class);
        }
    }

    private final void askForInternalDataCollection() {
        String string = TraceConsentBundle.message("notification.trace.data.sharing.internal.title", new Object[0]);
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)ShowSettingsUtil.getSettingsMenuName(), (String)"getSettingsMenuName(...)");
        MessageDialogBuilder.YesNo consent = MessageDialogBuilder.Companion.yesNo(string, TraceConsentBundle.message("notification.trace.data.sharing.internal.text", objectArray));
        consent.yesText(TraceConsentBundle.message("notification.trace.data.sharing.yes", new Object[0]));
        ConsentOptions.getInstance().setTraceDataCollectionComPermission(consent.ask(this.project));
    }

    private final void runOncePerAppWithIdleTracker(String taskId, Function0<Unit> block) {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(taskId, block, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $taskId;
            final /* synthetic */ Function0<Unit> $block;
            {
                this.$taskId = $taskId;
                this.$block = $block;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$launch;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.label = 1;
                        Object object2 = FlowKt.debounce-HG0u8IE((Flow)((Flow)IdleTracker.Companion.getInstance().getEvents()), (long)LicenseAwareTraceDataSharingServiceKt.access$getIDLE_TRACKER_POPUP_DELAY$p()).collect(new FlowCollector(this.$taskId, (CoroutineScope)$this$launch, this.$block){
                            final /* synthetic */ String $taskId;
                            final /* synthetic */ CoroutineScope $$this$launch;
                            final /* synthetic */ Function0<Unit> $block;
                            {
                                this.$taskId = $taskId;
                                this.$$this$launch = $$this$launch;
                                this.$block = $block;
                            }

                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                if (new JBTraceConsentManager().canCollectTraceConsent()) {
                                    RunOnceUtil.runOnceForApp((String)this.$taskId, () -> runOncePerAppWithIdleTracker.1.emit$lambda$0(this.$block));
                                }
                                CoroutineScopeKt.cancel$default((CoroutineScope)this.$$this$launch, null, (int)1, null);
                                return Unit.INSTANCE;
                            }

                            private static final void emit$lambda$0(Function0 $block) {
                                $block.invoke();
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private static final Unit notifyAboutTraceDataCollectionForCommercialIfNeeded$lambda$0(LicenseAwareTraceDataSharingService this$0) {
        this$0.askForCommercialDataCollection();
        return Unit.INSTANCE;
    }

    private static final Unit enableTraceDataCollectionForNonCommercialIfNeeded$lambda$0(LicenseAwareTraceDataSharingService this$0) {
        this$0.askForNonCommercialDataCollection();
        return Unit.INSTANCE;
    }

    private static final Unit notifyAboutInternalTraceDataCollectionIfNeeded$lambda$0(LicenseAwareTraceDataSharingService this$0) {
        this$0.askForInternalDataCollection();
        return Unit.INSTANCE;
    }

    private static final Unit notifyAboutEnabledTraceDataCollectionForOrganizationIfNeeded$lambda$0(LicenseAwareTraceDataSharingService this$0) {
        Messages.showInfoMessage((Project)this$0.project, (String)TraceConsentBundle.message("notification.trace.enabled.data.sharing.organization.text", new Object[0]), (String)TraceConsentBundle.message("notification.trace.enabled.data.sharing.organization.title", new Object[0]));
        return Unit.INSTANCE;
    }
}

