/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.highlighting;

import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.ideolog.filters.BlackListFilterClassProvider;
import com.intellij.ideolog.filters.PrioritizedFilter;
import com.intellij.ideolog.highlighting.DynamicLogFilterServiceClassProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\b\u0016\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/ideolog/highlighting/LogHeavyFilterService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "blackListedFilterClasses", "", "Ljava/lang/Class;", "Lcom/intellij/execution/filters/Filter;", "getBlackListedFilterClasses", "()[Ljava/lang/Class;", "blackListedFilterClasses$delegate", "Lkotlin/Lazy;", "myFilters", "", "getMyFilters", "()Ljava/util/List;", "myFilters$delegate", "myCompositeFilter", "Lcom/intellij/execution/filters/CompositeFilter;", "getMyCompositeFilter", "()Lcom/intellij/execution/filters/CompositeFilter;", "myCompositeFilter$delegate", "hyperlinksFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lkotlin/Function0;", "", "enqueueHeavyFiltering", "editor", "Lcom/intellij/openapi/editor/Editor;", "eventOffset", "", "event", "", "dispose", "Companion", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nLogHeavyFilterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogHeavyFilterService.kt\ncom/intellij/ideolog/highlighting/LogHeavyFilterService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,123:1\n1#2:124\n1869#3,2:125\n1374#3:127\n1460#3,5:128\n1374#3:135\n1460#3,5:136\n827#3:141\n855#3,2:142\n1056#3:144\n1869#3,2:145\n1878#3,3:147\n37#4,2:133\n*S KotlinDebug\n*F\n+ 1 LogHeavyFilterService.kt\ncom/intellij/ideolog/highlighting/LogHeavyFilterService\n*L\n106#1:125,2\n36#1:127\n36#1:128,5\n42#1:135\n42#1:136,5\n43#1:141\n43#1:142,2\n44#1:144\n87#1:145,2\n113#1:147,3\n38#1:133,2\n*E\n"})
public class LogHeavyFilterService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy blackListedFilterClasses$delegate;
    @NotNull
    private final Lazy myFilters$delegate;
    @NotNull
    private final Lazy myCompositeFilter$delegate;
    @NotNull
    private final MutableSharedFlow<Function0<Unit>> hyperlinksFlow;
    @NotNull
    private static final Key<HashSet<Integer>> markupHighlightedExceptionsKey;
    @NotNull
    private static final Key<EditorHyperlinkSupport> markupHyperlinkSupportKey;

    public LogHeavyFilterService(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.blackListedFilterClasses$delegate = LazyKt.lazy(() -> LogHeavyFilterService.blackListedFilterClasses_delegate$lambda$0(this));
        this.myFilters$delegate = LazyKt.lazy(() -> LogHeavyFilterService.myFilters_delegate$lambda$0(this));
        this.myCompositeFilter$delegate = LazyKt.lazy(() -> LogHeavyFilterService.myCompositeFilter_delegate$lambda$0(this));
        this.hyperlinksFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ LogHeavyFilterService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.hyperlinksFlow), (Function2)((Function2)new Function2<Function0<? extends Unit>, Continuation<? super Unit>, Object>(null){
                            int label;
                            /* synthetic */ Object L$0;

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                Function0 function0 = (Function0)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void action;
                                        ResultKt.throwOnFailure((Object)$result);
                                        action.invoke();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(Function0<Unit> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Class<? extends Filter>[] getBlackListedFilterClasses() {
        Lazy lazy = this.blackListedFilterClasses$delegate;
        return (Class[])lazy.getValue();
    }

    private final List<Filter> getMyFilters() {
        Lazy lazy = this.myFilters$delegate;
        return (List)lazy.getValue();
    }

    private final CompositeFilter getMyCompositeFilter() {
        Lazy lazy = this.myCompositeFilter$delegate;
        return (CompositeFilter)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueHeavyFiltering(@NotNull Editor editor, int eventOffset, @NotNull CharSequence event) {
        HashSet<Integer> set;
        Object it;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (editor.isDisposed()) {
            return;
        }
        MarkupModel markupModel = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        MarkupModel markupModel2 = markupModel;
        HashSet<Integer> hashSet = (HashSet<Integer>)markupModel2.getUserData(markupHighlightedExceptionsKey);
        if (hashSet == null) {
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            it = hashSet2;
            boolean bl = false;
            markupModel2.putUserData(markupHighlightedExceptionsKey, it);
            hashSet = hashSet2;
        }
        HashSet<Integer> hashSet3 = set = hashSet;
        synchronized (hashSet3) {
            boolean bl = false;
            if (set.contains(eventOffset)) {
                return;
            }
            bl = set.add(eventOffset);
        }
        Object object = (EditorHyperlinkSupport)markupModel2.getUserData(markupHyperlinkSupportKey);
        if (object == null) {
            Project project = editor.getProject();
            Intrinsics.checkNotNull((Object)project);
            Object it2 = it = new EditorHyperlinkSupport(editor, project);
            boolean bl = false;
            markupModel2.putUserData(markupHyperlinkSupportKey, it2);
            object = it;
        }
        EditorHyperlinkSupport hyperlinkSupport = object;
        it = new char[1];
        it[0] = 10;
        List lines = StringsKt.split$default((CharSequence)event, (char[])it, (boolean)false, (int)0, (int)6, null);
        DocumentImpl subDoc = new DocumentImpl(event);
        int offset = 0;
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            LogHeavyFilterService.enqueueHeavyFiltering$consumeResult(editor, markupModel2, set, eventOffset, hyperlinkSupport, this.getMyCompositeFilter().applyFilter(line, eventOffset + (offset += line.length())), false);
            ++offset;
        }
        this.hyperlinksFlow.tryEmit(() -> LogHeavyFilterService.enqueueHeavyFiltering$lambda$5(this, lines, subDoc, editor, markupModel2, set, eventOffset, hyperlinkSupport));
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    private static final Class[] blackListedFilterClasses_delegate$lambda$0(LogHeavyFilterService this$0) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = BlackListFilterClassProvider.Companion.getBLACK_LIST_FILTER_PROVIDER_EP_NAME$intellij_ideolog().getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            BlackListFilterClassProvider it = (BlackListFilterClassProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ArraysKt.asIterable((Object[])it.getBlackListFilterClasses(this$0.project));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Class[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static final List myFilters_delegate$lambda$0(LogHeavyFilterService this$0) {
        void $this$filterNotTo$iv$iv;
        ConsoleFilterProvider it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = ConsoleFilterProvider.FILTER_PROVIDERS.getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ConsoleFilterProvider)element$iv$iv;
            boolean bl = false;
            Filter[] filterArray = it.getDefaultFilters(this$0.project);
            Intrinsics.checkNotNullExpressionValue((Object)filterArray, (String)"getDefaultFilters(...)");
            Iterable list$iv$iv = ArraysKt.asIterable((Object[])filterArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$flatMapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Filter)element$iv$iv;
            boolean bl = false;
            if (ArraysKt.contains((Object[])this$0.getBlackListedFilterClasses(), it.getClass())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Filter it = (Filter)a;
                boolean bl = false;
                int n = it instanceof PrioritizedFilter ? -1 : 1;
                it = (Filter)b;
                Comparable comparable = Integer.valueOf(n);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it instanceof PrioritizedFilter ? -1 : 1));
            }
        });
    }

    private static final CompositeFilter myCompositeFilter_delegate$lambda$0(LogHeavyFilterService this$0) {
        return new CompositeFilter(this$0.project, this$0.getMyFilters());
    }

    private static final void enqueueHeavyFiltering$consumeResult(Editor $editor, MarkupModel markupModel, HashSet<Integer> set, int $eventOffset, EditorHyperlinkSupport hyperlinkSupport, Filter.Result result, boolean addOffset) {
        if (result == null) {
            return;
        }
        if ($editor.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> LogHeavyFilterService.enqueueHeavyFiltering$consumeResult$lambda$3($editor, markupModel, set, addOffset, $eventOffset, result, hyperlinkSupport));
    }

    private static final void enqueueHeavyFiltering$consumeResult$lambda$3(Editor $editor, MarkupModel $markupModel, HashSet $set, boolean $addOffset, int $eventOffset, Filter.Result $result, EditorHyperlinkSupport $hyperlinkSupport) {
        if ($editor.isDisposed()) {
            return;
        }
        if ($markupModel.getUserData(markupHighlightedExceptionsKey) != $set) {
            return;
        }
        int extraOffset = $addOffset ? $eventOffset : 0;
        List list = $result.getResultItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResultItems(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Filter.ResultItem it = (Filter.ResultItem)element$iv;
            boolean bl = false;
            HyperlinkInfo hyperlinkInfo = it.getHyperlinkInfo();
            int highlightStartOffset = it.getHighlightStartOffset() + extraOffset;
            int highlightEndOffset = it.getHighlightEndOffset() + extraOffset;
            if (highlightEndOffset > $editor.getDocument().getTextLength()) continue;
            RangeHighlighter rangeHighlighter = hyperlinkInfo != null ? $hyperlinkSupport.createHyperlink(highlightStartOffset, highlightEndOffset, it.getHighlightAttributes(), hyperlinkInfo) : $markupModel.addRangeHighlighter(highlightStartOffset, highlightEndOffset, it.getHighlighterLayer(), it.getHighlightAttributes(), HighlighterTargetArea.EXACT_RANGE);
        }
    }

    private static final Unit enqueueHeavyFiltering$lambda$5(LogHeavyFilterService this$0, List $lines, DocumentImpl $subDoc, Editor $editor, MarkupModel $markupModel, HashSet $set, int $eventOffset, EditorHyperlinkSupport $hyperlinkSupport) {
        if (this$0.getMyCompositeFilter().shouldRunHeavy()) {
            Iterable $this$forEachIndexed$iv = $lines;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String cfr_ignored_0 = (String)item$iv;
                int index = n;
                boolean bl = false;
                this$0.getMyCompositeFilter().applyHeavyFilter((Document)$subDoc, 0, index, arg_0 -> LogHeavyFilterService.enqueueHeavyFiltering$lambda$5$0$1(arg_0 -> LogHeavyFilterService.enqueueHeavyFiltering$lambda$5$0$0($editor, $markupModel, $set, $eventOffset, $hyperlinkSupport, arg_0), arg_0));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit enqueueHeavyFiltering$lambda$5$0$0(Editor $editor, MarkupModel $markupModel, HashSet $set, int $eventOffset, EditorHyperlinkSupport $hyperlinkSupport, FilterMixin.AdditionalHighlight it) {
        LogHeavyFilterService.enqueueHeavyFiltering$consumeResult($editor, $markupModel, $set, $eventOffset, $hyperlinkSupport, (Filter.Result)it, true);
        return Unit.INSTANCE;
    }

    private static final void enqueueHeavyFiltering$lambda$5$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        Key key = Key.create((String)"Log.ParsedExceptions");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        markupHighlightedExceptionsKey = key;
        Key key2 = Key.create((String)"Log.ExceptionsHyperlinks");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        markupHyperlinkSupportKey = key2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R'\u0010\b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR'\u0010\u000f\u001a\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\t\u00a2\u0006\u0002\b\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ideolog/highlighting/LogHeavyFilterService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ideolog/highlighting/LogHeavyFilterService;", "project", "Lcom/intellij/openapi/project/Project;", "markupHighlightedExceptionsKey", "Lcom/intellij/openapi/util/Key;", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getMarkupHighlightedExceptionsKey", "()Lcom/intellij/openapi/util/Key;", "markupHyperlinkSupportKey", "Lcom/intellij/execution/impl/EditorHyperlinkSupport;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getMarkupHyperlinkSupportKey$intellij_ideolog", "intellij.ideolog"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LogHeavyFilterService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = (DynamicLogFilterServiceClassProvider)CollectionsKt.firstOrNull((List)DynamicLogFilterServiceClassProvider.EP_NAME.getExtensionList());
            if (object == null || (object = object.getFilterServiceClass()) == null) {
                object = LogHeavyFilterService.class;
            }
            Class<LogHeavyFilterService> serviceClass = object;
            Object object2 = project.getService(serviceClass);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getService(...)");
            return (LogHeavyFilterService)object2;
        }

        @NotNull
        public final Key<HashSet<Integer>> getMarkupHighlightedExceptionsKey() {
            return markupHighlightedExceptionsKey;
        }

        @NotNull
        public final Key<EditorHyperlinkSupport> getMarkupHyperlinkSupportKey$intellij_ideolog() {
            return markupHyperlinkSupportKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

