/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ideolog.IdeologBundle;
import com.intellij.ideolog.fileType.LogFileType;
import com.intellij.ideolog.foldings.FoldingCalculatorTask;
import com.intellij.ideolog.highlighting.LogParsingUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\u0005H&J\b\u0010\n\u001a\u00020\u0005H\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J8\u0010\u0013\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00050\u00150\u0014j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00050\u0015`\u00172\u0006\u0010\u000f\u001a\u00020\u0010H&J#\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u001a\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ideolog/intentions/LogThisIntentionBase;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "<init>", "()V", "lastText", "", "fieldText", "getFieldText", "()Ljava/lang/String;", "getText", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getIntentionItems", "Ljava/util/HashSet;", "Lkotlin/Pair;", "", "Lkotlin/collections/HashSet;", "invoke", "", "startInWriteAction", "intellij.ideolog"})
public abstract class LogThisIntentionBase
implements IntentionAction {
    @NotNull
    private String lastText = "";

    @NotNull
    protected final String getFieldText() {
        return this.lastText;
    }

    @NotNull
    public abstract String getText();

    @NotNull
    public String getFamilyName() {
        return IdeologBundle.message("intention.family.name.logs", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile psiFile) {
        boolean visible;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        PsiFile psiFile2 = psiFile;
        if (!Intrinsics.areEqual((Object)(psiFile2 != null ? psiFile2.getFileType() : null), (Object)((Object)LogFileType.INSTANCE))) {
            return false;
        }
        int columnCount = LogParsingUtils.INSTANCE.getEventColumnCount(editor);
        int currentColumn = LogParsingUtils.INSTANCE.getColumnByOffset(editor);
        boolean bl = visible = currentColumn >= 0 && currentColumn != columnCount - 1;
        if (visible) {
            CharSequence charSequence = LogParsingUtils.INSTANCE.getColumnValueByOffset(editor);
            if (charSequence == null) {
                charSequence = "?";
            }
            CharSequence columnValue = charSequence;
            this.lastText = ((Object)StringsKt.trim((CharSequence)((Object)columnValue).toString())).toString();
        }
        return visible;
    }

    @NotNull
    public abstract HashSet<Pair<Integer, String>> getIntentionItems(@NotNull Editor var1);

    public void invoke(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        HashSet<Pair<Integer, String>> set = this.getIntentionItems(editor);
        int currentColumn = LogParsingUtils.INSTANCE.getColumnByOffset(editor);
        CharSequence charSequence = LogParsingUtils.INSTANCE.getColumnValueByOffset(editor);
        if (charSequence == null) {
            charSequence = "?";
        }
        CharSequence columnValue = charSequence;
        set.add((Pair<Integer, String>)TuplesKt.to((Object)currentColumn, (Object)((Object)columnValue).toString()));
        FoldingCalculatorTask.Companion.restartFoldingCalculator(project, editor, psiFile);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

