/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.terminal.highlighting;

import com.intellij.ideolog.highlighting.LogEditorHighlighter;
import com.intellij.ideolog.terminal.highlighting.TerminalCommandBlockHighlighter;
import com.intellij.ideolog.terminal.highlighting.TerminalLogHighlightingIterator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ideolog/terminal/highlighting/TerminalLogEditorHighlighter;", "Lcom/intellij/ideolog/highlighting/LogEditorHighlighter;", "highlightingInfos", "Ljava/util/TreeSet;", "Lcom/intellij/ideolog/terminal/highlighting/TerminalCommandBlockHighlighter$HighlightingInfo;", "colors", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Ljava/util/TreeSet;Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "myColors", "createIterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "startOffset", "", "intellij.ideolog.terminal"})
public final class TerminalLogEditorHighlighter
extends LogEditorHighlighter {
    @NotNull
    private final TreeSet<TerminalCommandBlockHighlighter.HighlightingInfo> highlightingInfos;
    @NotNull
    private EditorColorsScheme myColors;

    public TerminalLogEditorHighlighter(@NotNull TreeSet<TerminalCommandBlockHighlighter.HighlightingInfo> highlightingInfos, @NotNull EditorColorsScheme colors) {
        Intrinsics.checkNotNullParameter(highlightingInfos, (String)"highlightingInfos");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        super(colors);
        this.highlightingInfos = highlightingInfos;
        this.myColors = colors;
    }

    @Override
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        if (this.getMyEditor() == null || !ApplicationManager.getApplication().isDispatchThread()) {
            HighlighterIterator highlighterIterator = new EmptyEditorHighlighter(new TextAttributes()).createIterator(startOffset);
            Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
            return highlighterIterator;
        }
        HighlighterClient highlighterClient = this.getMyEditor();
        Intrinsics.checkNotNull((Object)highlighterClient, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.Editor");
        return new TerminalLogHighlightingIterator(this.highlightingInfos, startOffset, (Editor)highlighterClient, (Function0<? extends CharSequence>)((Function0)TerminalLogEditorHighlighter::createIterator$lambda$0), (Function0<? extends EditorColorsScheme>)((Function0)() -> TerminalLogEditorHighlighter.createIterator$lambda$1(this)));
    }

    private static final CharSequence createIterator$lambda$0() {
        return "";
    }

    private static final EditorColorsScheme createIterator$lambda$1(TerminalLogEditorHighlighter this$0) {
        return this$0.myColors;
    }
}

