/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.diagnostic;

import com.intellij.ml.diagnostics.TextMessage;
import com.intellij.ml.inline.completion.impl.AnalyzedMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.MLCompletionProposal;
import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.diagnostic.AddCachedProposals;
import com.intellij.ml.inline.completion.impl.diagnostic.Analyzed;
import com.intellij.ml.inline.completion.impl.diagnostic.AnalyzedFilteringCompleted;
import com.intellij.ml.inline.completion.impl.diagnostic.CaretCustomLanguage;
import com.intellij.ml.inline.completion.impl.diagnostic.ClientSelected;
import com.intellij.ml.inline.completion.impl.diagnostic.CompletionInvoked;
import com.intellij.ml.inline.completion.impl.diagnostic.ContextMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.FilterModelMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.FilteredAnalyzed;
import com.intellij.ml.inline.completion.impl.diagnostic.FilteredRaw;
import com.intellij.ml.inline.completion.impl.diagnostic.Grouped;
import com.intellij.ml.inline.completion.impl.diagnostic.IncompatibleUxMode;
import com.intellij.ml.inline.completion.impl.diagnostic.InlineCompletionFeatureKt;
import com.intellij.ml.inline.completion.impl.diagnostic.IsComment;
import com.intellij.ml.inline.completion.impl.diagnostic.JsonSchemaLength;
import com.intellij.ml.inline.completion.impl.diagnostic.Mapper;
import com.intellij.ml.inline.completion.impl.diagnostic.Mappings;
import com.intellij.ml.inline.completion.impl.diagnostic.ModelInferred;
import com.intellij.ml.inline.completion.impl.diagnostic.MultilineApplicability;
import com.intellij.ml.inline.completion.impl.diagnostic.PipelineStartsWith;
import com.intellij.ml.inline.completion.impl.diagnostic.ProposalForFilterModel;
import com.intellij.ml.inline.completion.impl.diagnostic.RawFilteringCompleted;
import com.intellij.ml.inline.completion.impl.diagnostic.ResultProposals;
import com.intellij.ml.inline.completion.impl.diagnostic.SessionMessagePayload;
import com.intellij.ml.inline.completion.impl.diagnostic.SilentCompletion;
import com.intellij.ml.inline.completion.impl.diagnostic.SkipReason;
import com.intellij.ml.inline.completion.impl.diagnostic.TriggerModelOutcome;
import com.intellij.ml.inline.completion.impl.postprocessing.filter.ProposalFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0002\u001a.\u0010\u0003\u001a\u0004\u0018\u00010\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0002\u001a\f\u0010\u000b\u001a\u00020\u0004*\u00020\fH\u0002\u001aB\u0010\r\u001a\u001c\u0012\u0004\u0012\u0002H\u0005\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\u000e0\t0\b\"\b\b\u0000\u0010\u0005*\u00020\u0006*\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0002\u00a8\u0006\u000f"}, d2={"toTextMessage", "Lcom/intellij/ml/diagnostics/TextMessage;", "Lcom/intellij/ml/inline/completion/impl/diagnostic/SessionMessagePayload;", "filterDescription", "", "T", "Lcom/intellij/ml/inline/completion/impl/MLCompletionProposal;", "items", "", "", "Lcom/intellij/ml/inline/completion/impl/postprocessing/filter/ProposalFilter;", "describe", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "proposalFailures", "Ljava/lang/Class;", "intellij.fullLine.core.completion"})
@SourceDebugExtension(value={"SMAP\ndiagnosticMessages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 diagnosticMessages.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticMessagesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,342:1\n774#2:343\n865#2,2:344\n1563#2:346\n1634#2,3:347\n774#2:350\n865#2,2:351\n1252#2,2:363\n1563#2:365\n1634#2,3:366\n1255#2:369\n1#3:353\n504#4,7:354\n463#4:361\n413#4:362\n*S KotlinDebug\n*F\n+ 1 diagnosticMessages.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticMessagesKt\n*L\n54#1:343\n54#1:344,2\n58#1:346\n58#1:347,3\n70#1:350\n70#1:351,2\n241#1:363,2\n241#1:365\n241#1:366,3\n241#1:369\n100#1:354,7\n241#1:361\n241#1:362\n*E\n"})
public final class DiagnosticMessagesKt {
    /*
     * WARNING - void declaration
     */
    private static final TextMessage toTextMessage(SessionMessagePayload $this$toTextMessage) {
        Object object;
        SessionMessagePayload sessionMessagePayload = $this$toTextMessage;
        if (sessionMessagePayload instanceof CompletionInvoked) {
            object = "Completion invoked";
        } else if (sessionMessagePayload instanceof ModelInferred) {
            object = "Model inferred with generation_id " + ((ModelInferred)$this$toTextMessage).getGenerationId() + " in " + Duration.getInWholeMilliseconds-impl((long)((ModelInferred)$this$toTextMessage).getDuration-UwyO8pc()) + "ms";
        } else if (sessionMessagePayload instanceof ClientSelected) {
            object = "Client selected " + ((ClientSelected)$this$toTextMessage).getName();
        } else if (sessionMessagePayload instanceof AddCachedProposals) {
            object = null;
        } else if (sessionMessagePayload instanceof Analyzed) {
            object = "Analyzing for all " + ((Analyzed)$this$toTextMessage).getProposals().size() + " suggestions took " + ((Analyzed)$this$toTextMessage).getDuration() + "ms";
        } else if (sessionMessagePayload instanceof TriggerModelOutcome) {
            object = "Trigger model pass: " + ((TriggerModelOutcome)$this$toTextMessage).isPass() + ". " + $this$toTextMessage;
        } else if (sessionMessagePayload instanceof ContextMessage) {
            object = "Context assembled in " + Duration.getInWholeMilliseconds-impl((long)((ContextMessage)$this$toTextMessage).getTimeToAssemble-UwyO8pc()) + "ms";
        } else if (sessionMessagePayload instanceof FilterModelMessage) {
            object = "Filter model (state=" + ((FilterModelMessage)$this$toTextMessage).getState() + ") for " + ((FilterModelMessage)$this$toTextMessage).getProposal().getSuggestion() + " executed with " + ((FilterModelMessage)$this$toTextMessage).getResponse() + ". Should pass=" + ((FilterModelMessage)$this$toTextMessage).getPass() + ", took " + Duration.getInWholeMilliseconds-impl((long)((FilterModelMessage)$this$toTextMessage).getDuration-UwyO8pc()) + "ms";
        } else if (sessionMessagePayload instanceof FilteredAnalyzed) {
            object = DiagnosticMessagesKt.filterDescription(((FilteredAnalyzed)$this$toTextMessage).getItems());
        } else if (sessionMessagePayload instanceof FilteredRaw) {
            object = DiagnosticMessagesKt.filterDescription(((FilteredRaw)$this$toTextMessage).getItems());
        } else if (sessionMessagePayload instanceof CaretCustomLanguage) {
            object = "Caret custom language is " + ((CaretCustomLanguage)$this$toTextMessage).getLanguage();
        } else if (sessionMessagePayload instanceof AnalyzedFilteringCompleted) {
            object = "Analyzed filtering took " + Duration.getInWholeMilliseconds-impl((long)((AnalyzedFilteringCompleted)$this$toTextMessage).getDuration-UwyO8pc()) + "ms";
        } else if (sessionMessagePayload instanceof RawFilteringCompleted) {
            object = "Raw filtering took " + Duration.getInWholeMilliseconds-impl((long)((RawFilteringCompleted)$this$toTextMessage).getDuration-UwyO8pc()) + "ms";
        } else if (sessionMessagePayload instanceof Grouped) {
            Map.Entry it;
            void $this$filterTo$iv$iv;
            StringBuilder stringBuilder;
            StringBuilder $this$toTextMessage_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            Iterable $this$filter$iv = ((Grouped)$this$toTextMessage).getGroups().entrySet();
            boolean $i$f$filter2 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                if (!(((List)it.getValue()).size() != 1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List merges = (List)destination$iv$iv;
            if (!((Collection)merges).isEmpty()) {
                $this$toTextMessage_u24lambda_u240.append("Some elements were grouped").append('\n');
                for (Map.Entry $i$f$filter2 : merges) {
                    void $this$mapTo$iv$iv;
                    String $this$map$iv;
                    RawMLCompletionProposal to = (RawMLCompletionProposal)$i$f$filter2.getKey();
                    List from = (List)$i$f$filter2.getValue();
                    StringBuilder $i$f$filterTo2 = $this$toTextMessage_u24lambda_u240;
                    Iterable iterable2 = from;
                    String string = to.getSuggestion();
                    boolean $i$f$map = false;
                    it = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        RawMLCompletionProposal rawMLCompletionProposal = (RawMLCompletionProposal)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl3 = false;
                        collection.add(it2.getSuggestion());
                    }
                    $this$map$iv = "\t" + string + " <- " + (List)destination$iv$iv2;
                    $i$f$filterTo2.append($this$map$iv).append('\n');
                }
            }
            object = stringBuilder.toString();
        } else if (sessionMessagePayload instanceof Mapper) {
            String name = ((Mapper)$this$toTextMessage).getMapperDiagnostics().getName();
            String bl = "%.3f";
            Object[] $this$filter$iv = new Object[]{((Mapper)$this$toTextMessage).getMapperDiagnostics().getTotalTimeMs()};
            String string = String.format(bl, Arrays.copyOf($this$filter$iv, $this$filter$iv.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            String totalTimeMs = string;
            int transformedNumber = ((Mapper)$this$toTextMessage).getMapperDiagnostics().getMappings().size();
            int totalInvocations = ((Mapper)$this$toTextMessage).getMapperDiagnostics().getInvocations();
            object = "Mapper '" + name + "' took " + totalTimeMs + "ms and transformed " + transformedNumber + " out of " + totalInvocations + " variants";
        } else if (sessionMessagePayload instanceof Mappings) {
            Pair $this$filterTo$iv$iv2;
            StringBuilder stringBuilder;
            StringBuilder $this$toTextMessage_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            Iterable $this$filter$iv = CollectionsKt.zip((Iterable)((Mappings)$this$toTextMessage).getBefore(), (Iterable)((Mappings)$this$toTextMessage).getAfter());
            boolean $i$f$filter = false;
            Iterable to = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Pair it = (Pair)element$iv$iv;
                boolean bl4 = false;
                if (!(!Intrinsics.areEqual((Object)((MLCompletionProposal)it.getFirst()).getSuggestion(), (Object)((MLCompletionProposal)it.getSecond()).getSuggestion()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List changes = (List)destination$iv$iv;
            if (!((Collection)changes).isEmpty()) {
                $this$filterTo$iv$iv2 = ((Iterable)changes).iterator();
                if (!$this$filterTo$iv$iv2.hasNext()) {
                    throw new NoSuchElementException();
                }
                Pair it22 = (Pair)$this$filterTo$iv$iv2.next();
                boolean bl5 = false;
                int it22 = ((MLCompletionProposal)it22.getFirst()).getSuggestion().length();
                while ($this$filterTo$iv$iv2.hasNext()) {
                    Pair it32 = (Pair)$this$filterTo$iv$iv2.next();
                    $i$a$-maxOf-DiagnosticMessagesKt$toTextMessage$text$2$longest$1 = false;
                    int it32 = ((MLCompletionProposal)it32.getFirst()).getSuggestion().length();
                    if (it22 >= it32) continue;
                    it22 = it32;
                }
                int longest = it22;
                $this$toTextMessage_u24lambda_u241.append("Some elements were transformed due to Mapping").append('\n');
                for (Pair $this$filterTo$iv$iv2 : changes) {
                    MLCompletionProposal b = (MLCompletionProposal)$this$filterTo$iv$iv2.component1();
                    MLCompletionProposal a = (MLCompletionProposal)$this$filterTo$iv$iv2.component2();
                    $this$toTextMessage_u24lambda_u241.append("\t" + StringsKt.padEnd$default((String)b.getSuggestion(), (int)longest, (char)'\u0000', (int)2, null) + " -> " + a.getSuggestion()).append('\n');
                }
            }
            object = stringBuilder.toString();
        } else if (sessionMessagePayload instanceof PipelineStartsWith) {
            StringBuilder stringBuilder;
            StringBuilder $this$toTextMessage_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toTextMessage_u24lambda_u242.append("Got " + ((PipelineStartsWith)$this$toTextMessage).getProposals().size() + " raw ML proposals").append('\n');
            Iterator longest = ((Iterable)((PipelineStartsWith)$this$toTextMessage).getProposals()).iterator();
            if (!longest.hasNext()) {
                throw new NoSuchElementException();
            }
            RawMLCompletionProposal it = (RawMLCompletionProposal)longest.next();
            boolean bl6 = false;
            int n = it.getSuggestion().length();
            while (longest.hasNext()) {
                RawMLCompletionProposal it3 = (RawMLCompletionProposal)longest.next();
                $i$a$-maxOf-DiagnosticMessagesKt$toTextMessage$text$3$longest$1 = false;
                int n2 = it3.getSuggestion().length();
                if (n >= n2) continue;
                n = n2;
            }
            int longest2 = n;
            for (RawMLCompletionProposal proposal : ((PipelineStartsWith)$this$toTextMessage).getProposals()) {
                $this$toTextMessage_u24lambda_u242.append("\t" + StringsKt.padEnd$default((String)proposal.getSuggestion(), (int)longest2, (char)'\u0000', (int)2, null) + " [" + DiagnosticMessagesKt.describe(proposal) + "]").append('\n');
            }
            object = stringBuilder.toString();
        } else if (sessionMessagePayload instanceof ResultProposals) {
            object = "Result proposals:\n" + CollectionsKt.joinToString$default((Iterable)((ResultProposals)$this$toTextMessage).getProposals(), (CharSequence)"\n", null, null, (int)0, null, DiagnosticMessagesKt::toTextMessage$lambda$3, (int)30, null);
        } else if (sessionMessagePayload instanceof SilentCompletion) {
            object = "Silent completion";
        } else if (sessionMessagePayload instanceof SkipReason) {
            object = "Skip due to " + ((SkipReason)$this$toTextMessage).getReason();
        } else if (sessionMessagePayload instanceof ProposalForFilterModel) {
            object = null;
        } else if (sessionMessagePayload instanceof IncompatibleUxMode) {
            object = "Cannot show a completion because of incompatible UX mode";
        } else if (sessionMessagePayload instanceof MultilineApplicability) {
            object = "Multi-line can be requested: " + ((MultilineApplicability)$this$toTextMessage).getResult();
        } else if (sessionMessagePayload instanceof IsComment) {
            object = "The completion is in a comment";
        } else if (sessionMessagePayload instanceof JsonSchemaLength) {
            object = "Length of JSON schema used in enricher: " + ((JsonSchemaLength)$this$toTextMessage).getSchemaLength();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if (object == null) {
            return null;
        }
        String text2 = object;
        return new TextMessage(text2, InlineCompletionFeatureKt.getInlineCompletionFeature().getFeatureId(), 0L, 4, null);
    }

    private static final <T extends MLCompletionProposal> String filterDescription(Map<T, ? extends List<? extends ProposalFilter>> items) {
        Map<T, List<ProposalFilter>> $this$filterValues$iv = items;
        boolean $i$f$filterValues = false;
        LinkedHashMap<T, List<? extends ProposalFilter>> result$iv = new LinkedHashMap<T, List<? extends ProposalFilter>>();
        for (Map.Entry<T, List<ProposalFilter>> entry$iv : $this$filterValues$iv.entrySet()) {
            List<? extends ProposalFilter> it = entry$iv.getValue();
            boolean bl = false;
            boolean bl2 = !((Collection)it).isEmpty();
            if (!bl2) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map filteredWithReasons = result$iv;
        if (filteredWithReasons.isEmpty()) {
            return null;
        }
        return CollectionsKt.joinToString$default((Iterable)filteredWithReasons.entrySet(), (CharSequence)"\n", (CharSequence)"Some elements were filtered:\n", null, (int)0, null, DiagnosticMessagesKt::filterDescription$lambda$1, (int)28, null);
    }

    private static final String describe(RawMLCompletionProposal $this$describe) {
        StringBuilder stringBuilder;
        StringBuilder $this$describe_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$describe_u24lambda_u240.append("score: " + $this$describe.getScore());
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends MLCompletionProposal> Map<T, List<Class<? extends ProposalFilter>>> proposalFailures(Map<T, ? extends List<? extends ProposalFilter>> $this$proposalFailures) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map<T, List<ProposalFilter>> $this$mapValues$iv = $this$proposalFailures;
        boolean $i$f$mapValues = false;
        Map<T, List<ProposalFilter>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Iterable $this$map$iv = (Iterable)it.getValue();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void filter2;
                ProposalFilter proposalFilter = (ProposalFilter)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(filter2.getClass());
            }
            List list = (List)destination$iv$iv2;
            map4.put(k, list);
        }
        return destination$iv$iv$iv;
    }

    private static final CharSequence toTextMessage$lambda$3(AnalyzedMLCompletionProposal it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSuggestion();
    }

    private static final CharSequence filterDescription$lambda$1(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        MLCompletionProposal proposal = (MLCompletionProposal)entry.getKey();
        List reasons = (List)entry.getValue();
        return proposal.getSuggestion() + " <- " + CollectionsKt.first((List)reasons);
    }

    public static final /* synthetic */ TextMessage access$toTextMessage(SessionMessagePayload $receiver) {
        return DiagnosticMessagesKt.toTextMessage($receiver);
    }

    public static final /* synthetic */ Map access$proposalFailures(Map $receiver) {
        return DiagnosticMessagesKt.proposalFailures($receiver);
    }
}

