/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.session;

import com.intellij.codeInsight.inline.completion.InlineCompletionRequest;
import com.intellij.codeInsight.inline.completion.editor.InlineCompletionEditorType;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionContext;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\bH\u0007J\b\u0010\u001b\u001a\u00020\u0010H\u0002R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/inline/completion/impl/session/MLCompletionSession;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isDisposed", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Lkotlin/jvm/functions/Function0;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getFile", "()Lcom/intellij/psi/PsiFile;", "initialState", "Lcom/intellij/ml/inline/completion/impl/session/MLCompletionSession$State;", "myPosition", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/psi/PsiElement;", "position", "getPosition", "()Lcom/intellij/psi/PsiElement;", "initializePosition", "", "initializePosition$intellij_fullLine_core_completion", "isValid", "captureState", "State", "Companion", "intellij.fullLine.core.completion"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMLCompletionSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLCompletionSession.kt\ncom/intellij/ml/inline/completion/impl/session/MLCompletionSession\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,86:1\n23#2:87\n*S KotlinDebug\n*F\n+ 1 MLCompletionSession.kt\ncom/intellij/ml/inline/completion/impl/session/MLCompletionSession\n*L\n53#1:87\n*E\n"})
public final class MLCompletionSession {
    @NotNull
    public static final Companion Companion;
    @VisibleForTesting
    @NotNull
    private final Editor editor;
    @VisibleForTesting
    @NotNull
    private final PsiFile file;
    @NotNull
    private final Function0<Boolean> isDisposed;
    @NotNull
    private final State initialState;
    @NotNull
    private final AtomicReference<PsiElement> myPosition;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<MLCompletionSession> SESSION_KEY;

    private MLCompletionSession(Editor editor2, PsiFile file, Function0<Boolean> isDisposed) {
        this.editor = editor2;
        this.file = file;
        this.isDisposed = isDisposed;
        this.initialState = this.captureState();
        this.myPosition = new AtomicReference<Object>(null);
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @Nullable
    public final PsiElement getPosition() {
        return this.myPosition.get();
    }

    @RequiresReadLock
    public final void initializePosition$intellij_fullLine_core_completion(@NotNull PsiElement position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        ThreadingAssertions.assertReadAccess();
        this.myPosition.set(position);
    }

    @RequiresReadLock
    public final boolean isValid() {
        ThreadingAssertions.assertReadAccess();
        if (InlineCompletionEditorType.Companion.get(this.editor) == InlineCompletionEditorType.TERMINAL) {
            return (Boolean)this.isDisposed.invoke() == false;
        }
        if (((Boolean)this.isDisposed.invoke()).booleanValue() || !Intrinsics.areEqual((Object)this.captureState(), (Object)this.initialState) || !this.file.isValid()) {
            return false;
        }
        PsiElement psiElement = this.getPosition();
        return !(psiElement != null ? !psiElement.isValid() : false);
    }

    private final State captureState() {
        return new State(this.editor.getDocument().getModificationStamp());
    }

    public /* synthetic */ MLCompletionSession(Editor editor2, PsiFile file, Function0 isDisposed, DefaultConstructorMarker $constructor_marker) {
        this(editor2, file, (Function0<Boolean>)isDisposed);
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"ml.inline.completion.session");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SESSION_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u000fJ\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/inline/completion/impl/session/MLCompletionSession$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SESSION_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/inline/completion/impl/session/MLCompletionSession;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getOrNull", "editor", "Lcom/intellij/openapi/editor/Editor;", "createIfPossible", "createIfPossible$intellij_fullLine_core_completion", "getAliveInlineCompletionSession", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSession;", "intellij.fullLine.core.completion"})
    @SourceDebugExtension(value={"SMAP\nMLCompletionSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLCompletionSession.kt\ncom/intellij/ml/inline/completion/impl/session/MLCompletionSession$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MLCompletionSession getOrNull(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            InlineCompletionSession inlineCompletionSession = this.getAliveInlineCompletionSession(editor2);
            if (inlineCompletionSession == null) {
                return null;
            }
            InlineCompletionSession inlineSession = inlineCompletionSession;
            return (MLCompletionSession)inlineSession.getRequest().getUserData(SESSION_KEY);
        }

        @RequiresReadLock
        @Nullable
        public final MLCompletionSession createIfPossible$intellij_fullLine_core_completion(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            ThreadingAssertions.assertReadAccess();
            InlineCompletionSession inlineCompletionSession = this.getAliveInlineCompletionSession(editor2);
            if (inlineCompletionSession == null) {
                return null;
            }
            InlineCompletionSession inlineSession = inlineCompletionSession;
            InlineCompletionRequest inlineRequest = inlineSession.getRequest();
            if (inlineRequest.getUserData(SESSION_KEY) != null) {
                LOG.trace("ML completion session is already initialized. It will be replaced.");
            }
            MLCompletionSession newSession2 = new MLCompletionSession(editor2, inlineRequest.getFile(), (Function0)new PropertyReference0Impl(inlineSession.getContext()){

                public Object get() {
                    return ((InlineCompletionContext)this.receiver).isDisposed();
                }
            }, null);
            inlineRequest.putUserData(SESSION_KEY, (Object)newSession2);
            return newSession2;
        }

        private final InlineCompletionSession getAliveInlineCompletionSession(Editor $this$getAliveInlineCompletionSession) {
            Object object;
            InlineCompletionSession inlineCompletionSession = InlineCompletionSession.Companion.getOrNull($this$getAliveInlineCompletionSession);
            if (inlineCompletionSession != null) {
                InlineCompletionSession inlineCompletionSession2;
                InlineCompletionSession it = inlineCompletionSession2 = inlineCompletionSession;
                boolean bl = false;
                object = !it.getContext().isDisposed() ? inlineCompletionSession2 : null;
            } else {
                object = null;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/inline/completion/impl/session/MLCompletionSession$State;", "", "documentStamp", "", "<init>", "(J)V", "getDocumentStamp", "()J", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.fullLine.core.completion"})
    private static final class State {
        private final long documentStamp;

        public State(long documentStamp) {
            this.documentStamp = documentStamp;
        }

        public final long getDocumentStamp() {
            return this.documentStamp;
        }

        public final long component1() {
            return this.documentStamp;
        }

        @NotNull
        public final State copy(long documentStamp) {
            return new State(documentStamp);
        }

        public static /* synthetic */ State copy$default(State state, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = state.documentStamp;
            }
            return state.copy(l);
        }

        @NotNull
        public String toString() {
            return "State(documentStamp=" + this.documentStamp + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.documentStamp);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            return this.documentStamp == state.documentStamp;
        }
    }
}

