/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.generation;

import com.intellij.httpClient.actions.generation.HttpRequestUrlPathInfoError;
import com.intellij.httpClient.actions.generation.HttpRequestUrlQueryParameters;
import com.intellij.httpClient.actions.generation.RequestBody;
import com.intellij.httpClient.actions.generation.UrlChecker;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.executor.util.PartialResult;
import com.intellij.microservices.utils.UrlMappingBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u000f\u001a\u00020\u00002\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u000eH\u0007J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo;", "", "url", "", "methods", "", "<init>", "(Ljava/lang/String;Ljava/util/Collection;)V", "getUrl", "()Ljava/lang/String;", "getMethods", "()Ljava/util/Collection;", "heavyBuildingOperation", "Lkotlin/Function1;", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo$Computed;", "applyOnRequestGeneration", "heavyUrlInfoBuilder", "validated", "Lcom/intellij/httpClient/executor/util/PartialResult;", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfoError;", "project", "Lcom/intellij/openapi/project/Project;", "compute", "toString", "equals", "", "other", "hashCode", "", "Computed", "Companion", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpRequestGenerationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestGenerationUtil.kt\ncom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,348:1\n3301#2,10:349\n*S KotlinDebug\n*F\n+ 1 HttpRequestGenerationUtil.kt\ncom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo\n*L\n243#1:349,10\n*E\n"})
public class HttpRequestUrlPathInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final Collection<String> methods;
    @NotNull
    private Function1<? super HttpRequestUrlPathInfo, Computed> heavyBuildingOperation;

    private HttpRequestUrlPathInfo(String url, Collection<String> methods) {
        this.url = url;
        this.methods = methods;
        this.heavyBuildingOperation = HttpRequestUrlPathInfo::heavyBuildingOperation$lambda$0;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final Collection<String> getMethods() {
        return this.methods;
    }

    private final HttpRequestUrlPathInfo applyOnRequestGeneration(Function1<? super HttpRequestUrlPathInfo, Computed> heavyUrlInfoBuilder) {
        this.heavyBuildingOperation = heavyUrlInfoBuilder;
        return this;
    }

    private final PartialResult<HttpRequestUrlPathInfo, HttpRequestUrlPathInfoError> validated(Project project) {
        String validUrl = new UrlMappingBuilder("/").appendSegment(this.url).build();
        Collection<String> supportedMethods = RequestExecutionSupport.All.allSupportedMethods(project);
        Iterable $this$partition$iv = this.methods;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            boolean bl2 = supportedMethods.contains(it) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List validMethods = (List)pair.component1();
        List invalidMethods = (List)pair.component2();
        if (validMethods.isEmpty()) {
            return new PartialResult.Error<HttpRequestUrlPathInfoError.Methods>(new HttpRequestUrlPathInfoError.Methods(invalidMethods));
        }
        if (!UrlChecker.isValidRequest$default(UrlChecker.INSTANCE, project, new UrlMappingBuilder("/").appendSegment(this.url).build(), null, 4, null)) {
            return new PartialResult.Error<HttpRequestUrlPathInfoError.Url>(new HttpRequestUrlPathInfoError.Url(this.url));
        }
        HttpRequestUrlPathInfo validInfo = new HttpRequestUrlPathInfo(validUrl, CollectionsKt.toSet((Iterable)validMethods)).applyOnRequestGeneration(this.heavyBuildingOperation);
        return invalidMethods.isEmpty() ? (PartialResult)new PartialResult.Success<HttpRequestUrlPathInfo>(validInfo) : (PartialResult)new PartialResult.PartialSuccess<HttpRequestUrlPathInfo, HttpRequestUrlPathInfoError.Methods>(validInfo, new HttpRequestUrlPathInfoError.Methods(invalidMethods));
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public final Computed compute() {
        return (Computed)this.heavyBuildingOperation.invoke((Object)this);
    }

    @NotNull
    public String toString() {
        return "HttpRequestUrlPathInfo(url='" + this.url + "', methods=" + this.methods + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.httpClient.actions.generation.HttpRequestUrlPathInfo");
        HttpRequestUrlPathInfo cfr_ignored_0 = (HttpRequestUrlPathInfo)object2;
        if (!Intrinsics.areEqual((Object)this.url, (Object)((HttpRequestUrlPathInfo)other).url)) {
            return false;
        }
        return Intrinsics.areEqual(this.methods, ((HttpRequestUrlPathInfo)other).methods);
    }

    public int hashCode() {
        int result2 = this.url.hashCode();
        result2 = 31 * result2 + ((Object)this.methods).hashCode();
        return result2;
    }

    private static final Computed heavyBuildingOperation$lambda$0(HttpRequestUrlPathInfo baseUrlInfo) {
        Intrinsics.checkNotNullParameter((Object)baseUrlInfo, (String)"baseUrlInfo");
        return new Computed(baseUrlInfo, null, null, 6, null);
    }

    public /* synthetic */ HttpRequestUrlPathInfo(String url, Collection methods, DefaultConstructorMarker $constructor_marker) {
        this(url, methods);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/httpClient/executor/util/PartialResult;", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo;", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfoError;", "project", "Lcom/intellij/openapi/project/Project;", "url", "", "methods", "", "applyOnRequestGeneration", "Lkotlin/Function1;", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo$Computed;", "intellij.restClient"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PartialResult<HttpRequestUrlPathInfo, HttpRequestUrlPathInfoError> create(@NotNull Project project, @NotNull String url, @NotNull Collection<String> methods, @NotNull Function1<? super HttpRequestUrlPathInfo, Computed> applyOnRequestGeneration) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(methods, (String)"methods");
            Intrinsics.checkNotNullParameter(applyOnRequestGeneration, (String)"applyOnRequestGeneration");
            return new HttpRequestUrlPathInfo(url, methods, null).applyOnRequestGeneration((Function1<? super HttpRequestUrlPathInfo, Computed>)applyOnRequestGeneration).validated(project);
        }

        public static /* synthetic */ PartialResult create$default(Companion companion, Project project, String string, Collection collection, Function1 function1, int n, Object object) {
            if ((n & 8) != 0) {
                function1 = Companion::create$lambda$0;
            }
            return companion.create(project, string, collection, (Function1<? super HttpRequestUrlPathInfo, Computed>)function1);
        }

        private static final Computed create$lambda$0(HttpRequestUrlPathInfo baseInfo) {
            Intrinsics.checkNotNullParameter((Object)baseInfo, (String)"baseInfo");
            return new Computed(baseInfo, null, null, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015*\u0004\b\u0012\u0010\u0013R!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a*\u0004\b\u0018\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo$Computed;", "", "baseInfo", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo;", "queryParameters", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlQueryParameters;", "requestBody", "Lcom/intellij/httpClient/actions/generation/RequestBody;", "<init>", "(Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo;Lcom/intellij/httpClient/actions/generation/HttpRequestUrlQueryParameters;Lcom/intellij/httpClient/actions/generation/RequestBody;)V", "getBaseInfo", "()Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo;", "getQueryParameters", "()Lcom/intellij/httpClient/actions/generation/HttpRequestUrlQueryParameters;", "getRequestBody", "()Lcom/intellij/httpClient/actions/generation/RequestBody;", "url", "", "getUrl$delegate", "(Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo$Computed;)Ljava/lang/Object;", "getUrl", "()Ljava/lang/String;", "methods", "", "getMethods$delegate", "getMethods", "()Ljava/util/Collection;", "intellij.restClient"})
    public static final class Computed {
        @NotNull
        private final HttpRequestUrlPathInfo baseInfo;
        @NotNull
        private final HttpRequestUrlQueryParameters queryParameters;
        @NotNull
        private final RequestBody requestBody;

        public Computed(@NotNull HttpRequestUrlPathInfo baseInfo, @NotNull HttpRequestUrlQueryParameters queryParameters, @NotNull RequestBody requestBody) {
            Intrinsics.checkNotNullParameter((Object)baseInfo, (String)"baseInfo");
            Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
            Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
            this.baseInfo = baseInfo;
            this.queryParameters = queryParameters;
            this.requestBody = requestBody;
        }

        public /* synthetic */ Computed(HttpRequestUrlPathInfo httpRequestUrlPathInfo, HttpRequestUrlQueryParameters httpRequestUrlQueryParameters, RequestBody requestBody, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                httpRequestUrlQueryParameters = HttpRequestUrlQueryParameters.Empty.INSTANCE;
            }
            if ((n & 4) != 0) {
                requestBody = RequestBody.Empty.INSTANCE;
            }
            this(httpRequestUrlPathInfo, httpRequestUrlQueryParameters, requestBody);
        }

        @NotNull
        public final HttpRequestUrlPathInfo getBaseInfo() {
            return this.baseInfo;
        }

        @NotNull
        public final HttpRequestUrlQueryParameters getQueryParameters() {
            return this.queryParameters;
        }

        @NotNull
        public final RequestBody getRequestBody() {
            return this.requestBody;
        }

        @NotNull
        public final String getUrl() {
            return this.baseInfo.getUrl();
        }

        private static Object getUrl$delegate(Computed computed) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)computed.baseInfo, HttpRequestUrlPathInfo.class, "url", "getUrl()Ljava/lang/String;", 0)));
        }

        @NotNull
        public final Collection<String> getMethods() {
            return this.baseInfo.getMethods();
        }

        private static Object getMethods$delegate(Computed computed) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)computed.baseInfo, HttpRequestUrlPathInfo.class, "methods", "getMethods()Ljava/util/Collection;", 0)));
        }
    }
}

