/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.composer;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.execution.ComposerExecutionProvider;
import com.jetbrains.php.config.PhpInterpreterBasedConfig;
import com.jetbrains.php.config.PhpInterpreterConfigurationForm;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterComboBox;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.composer.ComposerRemoteInterpreterExecution;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.ui.PhpRemoteInterpreterConfigurationForm;
import com.jetbrains.php.run.remote.PhpInvalidSdkTypeException;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.plugins.remotesdk.SshCredentialsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerRemoteInterpreterForm
implements ComposerExecutionProvider.Form,
PhpInterpreterBasedConfig {
    private static final Logger LOG = Logger.getInstance(ComposerRemoteInterpreterForm.class);
    @NlsSafe
    private static final String COMPOSER = "composer";
    @NotNull
    private final Project myProject;
    private final PhpInterpreterConfigurationForm myInterpreterConfigurationForm;
    private JPanel myMainPanel;
    private JBLabel myComposerPathLabel;
    private TextFieldWithBrowseButton myComposerPathTextField;
    private JPanel myInterpreterPanel;
    private String myInterpreterName;

    public ComposerRemoteInterpreterForm(final @NotNull Project project, @NotNull Disposable disposable) {
        if (project == null) {
            ComposerRemoteInterpreterForm.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            ComposerRemoteInterpreterForm.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myComposerPathTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = ComposerRemoteInterpreterForm.this.myInterpreterConfigurationForm.getInterpreterName();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    return;
                }
                PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance((Project)project);
                PhpInterpreter interpreter = manager.findInterpreter(name);
                if (interpreter == null || !interpreter.isRemote()) {
                    return;
                }
                PhpSdkAdditionalData additionalData = interpreter.getPhpSdkAdditionalData();
                if (!(additionalData instanceof PhpRemoteSdkAdditionalData)) {
                    return;
                }
                PhpRemoteSdkAdditionalData data = (PhpRemoteSdkAdditionalData)additionalData;
                if (SshCredentialsUtil.producesSshSdkCredentials((RemoteSdkAdditionalData)data)) {
                    String title = PhpBundle.message((String)"php.test.framework.by.sdk.settings.remote.path.title", (Object[])new Object[0]);
                    try {
                        PhpRemoteInterpreterManager remoteInterpreterManager = PhpRemoteInterpreterManager.getInstance();
                        if (remoteInterpreterManager != null) {
                            ActionListener action = remoteInterpreterManager.createRemoteBrowserAction(project, (PhpSdkAdditionalData)data, title, ComposerRemoteInterpreterForm.this.myComposerPathTextField.getTextField(), false);
                            action.actionPerformed(e);
                        }
                    }
                    catch (PhpInvalidSdkTypeException ex) {
                        LOG.warn((Throwable)ex);
                    }
                }
            }
        });
        this.myInterpreterConfigurationForm = new ComposerPhpRemoteInterpreterConfigurationForm(project, this);
        this.myInterpreterPanel.setLayout(new BorderLayout());
        this.myInterpreterPanel.add((Component)this.myInterpreterConfigurationForm.getMainComponent(), "Center");
        this.myInterpreterConfigurationForm.setAnchor((JComponent)this.myComposerPathLabel);
        Disposer.register((Disposable)disposable, (Disposable)this.myInterpreterConfigurationForm);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            ComposerRemoteInterpreterForm.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public boolean isModified(@NotNull ComposerExecution execution) {
        if (execution == null) {
            ComposerRemoteInterpreterForm.$$$reportNull$$$0(3);
        }
        if (!(execution instanceof ComposerRemoteInterpreterExecution)) {
            return true;
        }
        if (this.myInterpreterConfigurationForm.isModified()) {
            return true;
        }
        return !StringUtil.equals((CharSequence)StringUtil.nullize((String)((ComposerRemoteInterpreterExecution)execution).getComposerPath()), (CharSequence)StringUtil.nullize((String)this.myComposerPathTextField.getText()));
    }

    public boolean reset(@NotNull ComposerExecution execution) {
        if (execution == null) {
            ComposerRemoteInterpreterForm.$$$reportNull$$$0(4);
        }
        if (execution instanceof ComposerRemoteInterpreterExecution) {
            this.myInterpreterName = ((ComposerRemoteInterpreterExecution)execution).getInterpreterName();
            this.myInterpreterConfigurationForm.reset();
            this.myComposerPathTextField.setText(((ComposerRemoteInterpreterExecution)execution).getComposerPath());
            return true;
        }
        this.myInterpreterName = null;
        this.myInterpreterConfigurationForm.reset();
        this.myComposerPathTextField.setText(COMPOSER);
        return false;
    }

    public void apply() {
        this.myInterpreterConfigurationForm.apply();
    }

    @NotNull
    public ComposerExecution getExecution() {
        return new ComposerRemoteInterpreterExecution(this.myInterpreterName, this.myComposerPathTextField.getText());
    }

    @Nullable
    public ValidationInfo validate() {
        String name = this.myInterpreterConfigurationForm.getInterpreterName();
        if (name == null) {
            return new ValidationInfo(PhpRemoteSdkBundle.message("dialog.message.no.interpreter.selected", new Object[0]), (JComponent)this.myInterpreterPanel);
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myComposerPathTextField.getText())) {
            return new ValidationInfo(PhpRemoteSdkBundle.message("dialog.message.no.composer.executable.provided", new Object[0]), (JComponent)this.myComposerPathTextField);
        }
        String validationMessage = ComposerRemoteInterpreterExecution.getValidationMessage(this.myProject, name);
        if (validationMessage != null) {
            return new ValidationInfo(validationMessage, (JComponent)this.myInterpreterPanel);
        }
        return null;
    }

    @Nullable
    public String getInterpreterName() {
        return this.myInterpreterName;
    }

    public void setInterpreterName(@Nullable String interpreterName) {
        this.myInterpreterName = interpreterName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/composer/ComposerRemoteInterpreterForm";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/composer/ComposerRemoteInterpreterForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myComposerPathTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myComposerPathLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpRemoteSdkBundle", ComposerRemoteInterpreterForm.class).getString("label.composer.executable"));
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myInterpreterPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jBLabel.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static final class ComposerPhpRemoteInterpreterConfigurationForm
    extends PhpRemoteInterpreterConfigurationForm {
        private ComposerPhpRemoteInterpreterConfigurationForm(@NotNull Project project, @NotNull PhpInterpreterBasedConfig config) {
            if (project == null) {
                ComposerPhpRemoteInterpreterConfigurationForm.$$$reportNull$$$0(0);
            }
            if (config == null) {
                ComposerPhpRemoteInterpreterConfigurationForm.$$$reportNull$$$0(1);
            }
            super(project, config);
        }

        @NotNull
        protected PhpInterpreterComboBox createInterpreterComboBox() {
            return new PhpInterpreterComboBox(this.myProject, PhpRemoteSdkAdditionalData.getRemoteSdkFilter(), false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "config";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/remote/composer/ComposerRemoteInterpreterForm$ComposerPhpRemoteInterpreterConfigurationForm";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

