/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.interpreter.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.ui.PhpProjectConfigComponentProvider;
import com.jetbrains.php.remote.interpreter.ui.PhpRemoteInterpreterConfigurationForm;
import com.jetbrains.plugins.remotesdk.ui.RemoteMappingsField;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PhpPathMappingsComponentProvider
extends PhpProjectConfigComponentProvider {
    private static final Logger LOG = Logger.getInstance(PhpPathMappingsComponentProvider.class);

    @Override
    @NotNull
    public PhpPathMappingsComponent create(@NotNull Project project) {
        if (project == null) {
            PhpPathMappingsComponentProvider.$$$reportNull$$$0(0);
        }
        return new PhpPathMappingsComponent(project);
    }

    @Override
    public boolean isChildComponent(@NotNull PhpProjectConfigComponentProvider.PhpProjectConfigComponent component) {
        if (component == null) {
            PhpPathMappingsComponentProvider.$$$reportNull$$$0(1);
        }
        return component instanceof PhpPathMappingsComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/remote/interpreter/ui/PhpPathMappingsComponentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isChildComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpPathMappingsComponent
    extends PhpProjectConfigComponentProvider.PhpProjectConfigComponent {
        private final Project myProject;
        private PhpRemoteSdkAdditionalData mySdkData;
        private final RemoteMappingsField myMappingsField;
        private final Disposable myDisposable;

        PhpPathMappingsComponent(@NotNull Project project) {
            if (project == null) {
                PhpPathMappingsComponent.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myDisposable = Disposer.newDisposable();
            this.myMappingsField = new RemoteMappingsField(project, "php", s -> {
                if (StringUtil.isNotEmpty((String)s)) {
                    Messages.showMessageDialog((Project)this.myProject, (String)s, (String)PhpRemoteSdkBundle.message("dialog.title.can.not.evaluate.path.mappings", new Object[0]), (Icon)Messages.getErrorIcon());
                    LOG.debug("Can not evaluate path mappings due to: " + s);
                }
            }, this.myDisposable);
            if (project.isDefault()) {
                this.myMappingsField.clearAndShowDisabled(PhpRemoteSdkBundle.message("PhpProjectConfigurable.path.mappings.default.project.error.tooltip", new Object[0]), null);
            } else if (this.myProject.isInitialized()) {
                this.myProject.getMessageBus().connect().subscribe(PhpRemoteInterpreterConfigurationForm.PhpRemoteInterpreterChangedListener.TOPIC, (Object)new PhpRemoteInterpreterConfigurationForm.PhpRemoteInterpreterChangedListener(){

                    @Override
                    public void configChanged() {
                        if (mySdkData == null || StringUtil.isEmpty((String)mySdkData.getInterpreterId())) {
                            LOG.warn("Can not update path mappings presentation, because interpreter is not configured");
                            return;
                        }
                        this.onInterpreterChange(mySdkData.getInterpreterId(), mySdkData);
                    }
                });
            }
            this.init((JComponent)this.myMappingsField.getField(), PhpRemoteSdkBundle.message("PhpProjectConfigurable.path.mappings", new Object[0]));
        }

        @Override
        public boolean isAvailable(@NotNull PhpRemoteSdkAdditionalData data) {
            if (data == null) {
                PhpPathMappingsComponent.$$$reportNull$$$0(1);
            }
            return true;
        }

        @Override
        public void onInterpreterChange(@NotNull String interpreterId, @NotNull PhpRemoteSdkAdditionalData data) {
            if (interpreterId == null) {
                PhpPathMappingsComponent.$$$reportNull$$$0(2);
            }
            if (data == null) {
                PhpPathMappingsComponent.$$$reportNull$$$0(3);
            }
            if (!this.myProject.isDefault()) {
                this.mySdkData = data;
                this.myMappingsField.updateServerId(interpreterId, (RemoteSdkAdditionalData)data);
            } else {
                LOG.debug("Path mappings are not available in default project settings");
            }
        }

        @Override
        public void disposeUI() {
            Disposer.dispose((Disposable)this.myDisposable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterId";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/remote/interpreter/ui/PhpPathMappingsComponentProvider$PhpPathMappingsComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onInterpreterChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

