/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.injection;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValue;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.injection.PhpInjectionUtil;
import com.jetbrains.php.injection.PhpInjectorBase;
import com.jetbrains.php.joomla.injection.JoomlaInjectionInternalFragmentSubstProvider;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JDatabaseQueryInjector
extends PhpInjectorBase {
    private static final Key<CachedValue<Map<Pair<String, Boolean>, Pair<PsiElement, Language>>>> KEY = Key.create((String)"php.field.injections.from.usages.joomla");
    public static final String[] NOT_SUPPORTED_METHODS = new String[]{"charlength", "castaschar", "concatenate", "join", "leftjoin", "rightjoin", "innerjoin", "extendwhere", "andwhere", "orwhere", "minute", "hour", "nulldate"};

    @Nullable
    public Language doGetInjectedLanguage(@NotNull PsiElement context) {
        block8: {
            block7: {
                PsiElement[] parameters;
                JoomlaDataService service;
                if (context == null) {
                    JDatabaseQueryInjector.$$$reportNull$$$0(0);
                }
                if (!(service = JoomlaDataService.getInstance(context.getProject())).isEnabled()) {
                    return null;
                }
                if (!(context instanceof StringLiteralExpression)) {
                    return null;
                }
                PhpDocComment comment = JDatabaseQueryInjector.getDocComment((PsiElement)context);
                if (comment != null && PhpDocUtil.hasDocTagWithName((PhpDocComment)comment, (String)"@lang")) {
                    return null;
                }
                MethodReference queryUsage = JDatabaseQueryInjector.getJDatabaseQueryUsage(context);
                if (queryUsage == null) break block7;
                for (PsiElement it : parameters = queryUsage.getParameters()) {
                    if (it != context) continue;
                    return Language.findLanguageByID((String)"SQL");
                }
                break block8;
            }
            MethodReference memberReference = JDatabaseQueryInjector.getJDatabaseDriverUsage(context);
            if (memberReference == null) break block8;
            String name = memberReference.getName();
            MethodReference queryUsage1 = JDatabaseQueryInjector.getJDatabaseQueryUsage((PsiElement)memberReference);
            if (queryUsage1 != null && name != null && (name.equals("quote") || name.equals("quoteName") || name.equals("qn"))) {
                PsiElement[] parameters;
                for (PsiElement it : parameters = queryUsage1.getParameters()) {
                    if (it != memberReference) continue;
                    return Language.findLanguageByID((String)"SQL");
                }
            }
        }
        return null;
    }

    @NotNull
    protected Key<CachedValue<Map<Pair<String, Boolean>, Pair<PsiElement, Language>>>> getLanguageFromFieldUsageCacheKey() {
        Key<CachedValue<Map<Pair<String, Boolean>, Pair<PsiElement, Language>>>> key = KEY;
        if (key == null) {
            JDatabaseQueryInjector.$$$reportNull$$$0(1);
        }
        return key;
    }

    @Nullable
    public static MethodReference getJDatabaseDriverUsage(@NotNull PsiElement context) {
        MemberReference memberReference;
        ParameterList parameterList;
        if (context == null) {
            JDatabaseQueryInjector.$$$reportNull$$$0(2);
        }
        if ((parameterList = (ParameterList)PhpPsiUtil.getParentOfClass((PsiElement)context, ParameterList.class)) != null && (memberReference = (MemberReference)PhpPsiUtil.getParentOfClass((PsiElement)parameterList, MemberReference.class)) instanceof MethodReference && JDatabaseQueryInjector.isDbDriverQuote((MethodReference)memberReference)) {
            return (MethodReference)memberReference;
        }
        return null;
    }

    public static boolean isDbDriverQuote(@NotNull MethodReference memberReference) {
        PsiElement resolved;
        PsiReference memberReferenceReference;
        if (memberReference == null) {
            JDatabaseQueryInjector.$$$reportNull$$$0(3);
        }
        if ((memberReferenceReference = memberReference.getReference()) != null && (resolved = memberReferenceReference.resolve()) instanceof Method) {
            Method method = (Method)resolved;
            PhpClass phpClass = method.getContainingClass();
            return JoomlaDataService.isDbDriverClass(phpClass);
        }
        return false;
    }

    @Nullable
    public static MethodReference getJDatabaseQueryUsage(@NotNull PsiElement context) {
        MethodReference methodReference;
        ParameterList parameterList;
        if (context == null) {
            JDatabaseQueryInjector.$$$reportNull$$$0(4);
        }
        if ((parameterList = (ParameterList)PhpPsiUtil.getParentOfClass((PsiElement)context, ParameterList.class)) != null && JDatabaseQueryInjector.isQueryClassMethodReference(methodReference = (MethodReference)PhpPsiUtil.getParentOfClass((PsiElement)parameterList, MethodReference.class))) {
            return methodReference;
        }
        return null;
    }

    public static boolean isQueryClassMethodReference(@Nullable MethodReference memberReference) {
        Method method;
        PhpClass phpClass;
        PsiElement resolved;
        if (memberReference == null) {
            return false;
        }
        PsiReference memberReferenceReference = memberReference.getReference();
        return memberReferenceReference != null && (resolved = memberReferenceReference.resolve()) instanceof Method && JoomlaDataService.isQueryClass(phpClass = (method = (Method)resolved).getContainingClass()) && JDatabaseQueryInjector.isSupported(method);
    }

    @Nullable
    protected PhpInjectionUtil.InjectionResult patchInjectionResult(@NotNull PhpInjectionUtil.InjectionResult result) {
        if (result == null) {
            JDatabaseQueryInjector.$$$reportNull$$$0(5);
        }
        Language language = result.getLanguage();
        List fragmentsSubstitutions = result.getInjectionInfos().stream().flatMap(info -> JDatabaseQueryInjector.substitute(info, language)).collect(Collectors.toList());
        return new PhpInjectionUtil.InjectionResult(result.isInjected(), fragmentsSubstitutions, result.containsUnparsableFragment(), language);
    }

    private static Stream<PhpInjectionUtil.PhpInjectionInfo> substitute(PhpInjectionUtil.PhpInjectionInfo info, Language language) {
        Collection<PhpInjectionUtil.PhpInjectionInfo> substitutions = JoomlaInjectionInternalFragmentSubstProvider.getInternalFragmentsSubstitutions(info, language);
        if (substitutions == null || substitutions.isEmpty()) {
            return Stream.of(info);
        }
        return substitutions.stream();
    }

    public static boolean isSupported(Method method) {
        return !ArrayUtil.contains((String)StringUtil.toLowerCase((String)method.getName()), (String[])NOT_SUPPORTED_METHODS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/joomla/injection/JDatabaseQueryInjector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/joomla/injection/JDatabaseQueryInjector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageFromFieldUsageCacheKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doGetInjectedLanguage";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getJDatabaseDriverUsage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDbDriverQuote";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getJDatabaseQueryUsage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "patchInjectionResult";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

